/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.source.AbstractSymbolSourceProviderFactory;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.jsp.JSPModelProcessor;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.SymbolUtil;
import plugin.Activator;

public class JSPTagVariableSymbolSourceProvider
extends AbstractSymbolSourceProviderFactory
implements ISymbolSourceProvider {
    protected ISymbolSourceProvider create(IProject project) {
        return this;
    }

    public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        IFile fileContext = FileContextUtil.deriveIFileFromContext(context);
        if (this.isProvider((IAdaptable)fileContext)) {
            try {
                JSPModelProcessor modelProcessor = JSPModelProcessor.get(fileContext);
                ArrayList symbols = new ArrayList();
                if ((symbolScopeMask & 1) != 0) {
                    symbols.addAll(modelProcessor.getMapForScope("request").values());
                }
                if ((symbolScopeMask & 2) != 0) {
                    symbols.addAll(modelProcessor.getMapForScope("session").values());
                }
                if ((symbolScopeMask & 4) != 0) {
                    symbols.addAll(modelProcessor.getMapForScope("application").values());
                }
                return symbols.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "FacesContextPrototype", 0, "Error acquiring model processor", (Throwable)e));
            }
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.filterSymbolsByPrefix(this.getSymbols(context, symbolScopeMask), prefix);
    }

    public boolean isProvider(IAdaptable context) {
        IFile file = FileContextUtil.deriveIFileFromContext(context);
        return file != null && file.getProject() == this.getProject();
    }
}

