/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jst.jsf.facesconfig.common.actions.OpenPageAction;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractOverviewSection
extends AbstractFacesConfigSection {
    protected TableViewer tableViewer;
    private String targetPageID;

    public AbstractOverviewSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit, String targetPageID, String title, String description, String helpContextId, String helpTooltip) {
        super(parent, managedForm, page, toolkit, helpContextId, helpTooltip);
        this.targetPageID = targetPageID;
        this.getSection().setText(title);
        this.getSection().setDescription(description);
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        toolkit.paintBordersFor(container);
        Table table = this.createTable(container);
        if (this.targetPageID != null) {
            table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (((IStructuredSelection)AbstractOverviewSection.this.tableViewer.getSelection()).size() == 1) {
                        OpenPageAction action = new OpenPageAction();
                        action.setPageName(AbstractOverviewSection.this.targetPageID);
                        action.setSelection(AbstractOverviewSection.this.tableViewer.getSelection());
                        action.run();
                    }
                }
            });
        }
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        ComposedAdapterFactory factory = (ComposedAdapterFactory)this.getAdapterFactory();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)factory));
        this.configTableViewer(this.tableViewer);
    }

    protected abstract Table createTable(Composite var1);

    protected abstract void configTableViewer(TableViewer var1);

    public void clearAll() {
        this.tableViewer.setInput(null);
    }

    public void refreshAll() {
        this.tableViewer.setInput(this.getInput());
    }
}

