/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jst.jsf.facesconfig.ui.preference.PortFigure;

public class PortConnectionAnchor
extends AbstractConnectionAnchor {
    protected int orientation = 0;

    public PortConnectionAnchor() {
    }

    public PortConnectionAnchor(IFigure owner) {
        super(owner);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int o) {
        this.orientation = o;
        ((PortFigure)this.getOwner()).setOrientation(this.orientation);
    }

    public Point getLocation(Point arg0) {
        PortFigure portFigure = (PortFigure)this.getOwner();
        Point result = new Point(0, 0);
        Rectangle r = portFigure.getBounds();
        switch (portFigure.getOrientation()) {
            case 1: {
                result = new PrecisionPoint(r.x + r.width / 2, r.y);
                break;
            }
            case 4: {
                result = new PrecisionPoint(r.x + r.width / 2, r.y + r.height);
                break;
            }
            case 8: {
                result = new PrecisionPoint(r.x, r.y + r.height / 2);
                break;
            }
            case 16: {
                result = new PrecisionPoint(r.x + r.width, r.y + r.height / 2);
            }
        }
        portFigure.translateToAbsolute((Translatable)result);
        return result;
    }

    public Vector getConnections() {
        Vector list = new Vector();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            Object listener = it.next();
            if (!(listener instanceof PolylineConnection)) continue;
            list.add(listener);
        }
        return list;
    }
}

