/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;

public class EditPartMarkerUtil {
    public static void removeAllMarkers(EObject model) throws CoreException {
        IResource resource = EditPartMarkerUtil.getResource(model);
        if (resource != null) {
            String[] markerTypes = new String[]{"org.eclipse.core.resources.problemmarker", "org.eclipse.core.resources.taskmarker"};
            int iMT = 0;
            while (iMT < markerTypes.length) {
                IMarker[] markers = resource.findMarkers(markerTypes[iMT], false, 1);
                int iMark = 0;
                while (iMark < markers.length) {
                    markers[iMark].delete();
                    ++iMark;
                }
                ++iMT;
            }
        }
    }

    public static void removeAllMarkers(EObject model, String sMarkerType, int iSeverity) throws CoreException {
        IResource resource = EditPartMarkerUtil.getResource(model);
        if (resource != null) {
            IMarker[] markers = resource.findMarkers(sMarkerType, false, 1);
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                int iMarkerSeverity = marker.getAttribute("severity", 2);
                if (iMarkerSeverity == iSeverity || iSeverity == -1) {
                    markers[i].delete();
                }
                ++i;
            }
        }
    }

    private static IResource getResource(EObject model) {
        IResource resource = null;
        resource = WebrootUtil.getResource(model);
        return resource;
    }

    public static void createMarker(EObject model, String sMarkerType, int severity, String message, String location) throws CoreException {
        IResource resource = EditPartMarkerUtil.getResource(model);
        if (resource != null) {
            IMarker marker = resource.createMarker(sMarkerType);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (location != null && location.length() > 0) {
                marker.setAttribute("location", (Object)location);
            }
        }
    }

    public static void removeMarker(EObject model, String sMarkerType) throws CoreException {
        IResource resource = EditPartMarkerUtil.getResource(model);
        if (resource != null) {
            IMarker[] markers = resource.findMarkers(sMarkerType, false, 1);
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                Object id = marker.getAttribute("location");
                if (model instanceof PageflowElement && ((PageflowElement)model).getId().equals(id)) {
                    markers[i].delete();
                }
                ++i;
            }
        }
    }

    public static GraphicalEditPart findEditPart(GraphicalEditPart containerPart, String id) {
        String modelId;
        Object model = containerPart.getModel();
        if (model instanceof PageflowElement && (modelId = ((PageflowElement)model).getId()) != null && modelId.equals(id)) {
            return containerPart;
        }
        Iterator iterNode = containerPart.getChildren().iterator();
        while (iterNode.hasNext()) {
            GraphicalEditPart child = (GraphicalEditPart)iterNode.next();
            GraphicalEditPart foundPart = EditPartMarkerUtil.findEditPart(child, id);
            if (foundPart == null) continue;
            return foundPart;
        }
        Iterator iterConnection = containerPart.getSourceConnections().iterator();
        while (iterConnection.hasNext()) {
            GraphicalEditPart child = (GraphicalEditPart)iterConnection.next();
            GraphicalEditPart foundPart = EditPartMarkerUtil.findEditPart(child, id);
            if (foundPart == null) continue;
            return foundPart;
        }
        return null;
    }
}

