/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.hibernate.internal.ui.config;

import org.eclipse.core.resources.IProject;
import org.eclipse.jsr220orm.generic.internal.ui.config.GenericProductActivationWizard;

public class HibernateActivationWizard extends GenericProductActivationWizard {

    private HibernateActivationPage activationPage = new HibernateActivationPage("Hibernate Classpath");
    
    public HibernateActivationWizard() {
    }

    public void addPages() {
        super.addPages();
        addPage(activationPage);
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            return activationPage.performFinish();
        }
        return false;
    }

    public boolean canFinish() {
        return super.canFinish() && activationPage.canFinish();
    }

    public void setIProject(IProject project) {
        super.setIProject(project);
        activationPage.setIProject(project);
    }
}
