package org.eclipse.jsr220orm.hibernate;

import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.io.ColumnNameStrategy;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;

public class HibernateEntityModelManager extends GenericEntityModelManager {

    /**
     * Return the default table name for an entity name.
     */
    public String getDefaultTableName(String entityName) {
        return entityName;
    }
    
    /**
     * Get the strategy for naming owning column names in the join table
     * for a collection.
     */
    public ColumnNameStrategy getJoinTableOwnerCNS(
            final CollectionAttribute amd) {
        return new ColumnNameStrategy(){
            public String getColumnName(OrmColumn dest){
                return dest.getTable().getName() + "_" + dest.getName();
            }
        };
    }
    
    /**
     * Get the strategy for naming owning column names in the join table
     * for a collection.
     */
    public ColumnNameStrategy getJoinTableInverseCNS(
            final CollectionAttribute amd) {
        return new ColumnNameStrategy(){
            public String getColumnName(OrmColumn dest){
                return amd.getName() + "_" + dest.getName();
            }
        };
    }
    
    /**
     * Get the strategy for naming column names for the table for emd that
     * join to the primary key columns for its superclass.
     */
    public ColumnNameStrategy getReferenceCNS(final ReferenceAttribute amd) {
        return new ColumnNameStrategy() {
            public String getColumnName(OrmColumn dest) {
                return amd.getName() + "_" + dest.getName();
            }
        };
    }
    
    /**
     * Get the default name of a column for a basic attribute. 
     */
    public String getDefaultColumnName(BasicAttribute amd) {
            return amd.getName();
    }
}
