/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.views;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.internal.views.provider.ModelContentProvider;
import org.eclipse.jsr220orm.ui.internal.views.provider.ModelLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ModelOutline extends AbstractMetadataView implements ISelectionProvider {

    private TreeViewer treeViewer;
    /**
     * This viewer's control.
     */
    private Tree tree;

    private MetadataElement rootElement;

    private PropertySheetPage propertySheetPage;

    private ComposedAdapterFactory adapterFactory;

    public void createPartControl(Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parent.setLayout(parentLayout);
        {
            GridData treeViewerLData = new GridData();
            treeViewerLData.grabExcessHorizontalSpace = true;
            treeViewerLData.grabExcessVerticalSpace = true;
            treeViewerLData.horizontalAlignment = GridData.FILL;
            treeViewerLData.verticalAlignment = GridData.FILL;
            treeViewer = new TreeViewer(parent, SWT.NONE);
            tree = (Tree) treeViewer.getControl();
            tree.setLayoutData(treeViewerLData);
            List factories = new ArrayList();
            factories.add(new ResourceItemProviderAdapterFactory());
            factories.add(new MetadataItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());
            adapterFactory = new ComposedAdapterFactory(
                    factories);

            treeViewer.setContentProvider(new ModelContentProvider(
                    adapterFactory));
            treeViewer.setLabelProvider(new ModelLabelProvider(
                    adapterFactory));
        }
    }

    public void setFocus() {
        treeViewer.getControl().setFocus();
    }

    private void setTreeRoot(MetadataElement element) {
        if (element == null || treeViewer == null) {
            return;
        }
        rootElement = element;
        Object[] roots = new Object[] { rootElement };
        treeViewer.setInput(roots);
        treeViewer.setExpandedElements(roots);
    }

    protected void doUpdate(MetadataElement metadataElement) {
        if(metadataElement == null){
            return;
        }
        MetadataElement element = (metadataElement)
                .getAncestor(EntityMetaData.class);
        if (element == null) {
            element = metadataElement;
        }
        if (element != null && !element.equals(rootElement)) {
            setTreeRoot(element);
        }
        if (treeViewer != null) {
            treeViewer.setSelection(new StructuredSelection(metadataElement));
        }
    }

    /**
     * This is how the framework determines which interfaces we implement.
     */
    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    /**
     * This accesses a cached version of the property sheet.
     */
    public IPropertySheetPage getPropertySheetPage() {
        if (propertySheetPage == null) {
            propertySheetPage = new PropertySheetPage();
            propertySheetPage.setPropertySourceProvider(new AdapterFactoryContentProvider(adapterFactory));
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
            
                public void selectionChanged(SelectionChangedEvent event) {
                    propertySheetPage.selectionChanged(ModelOutline.this, event.getSelection()); 
                }
            
            });
        }

        return propertySheetPage;
    }
    
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        treeViewer.removeSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        treeViewer.setSelection(selection);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose() {
        adapterFactory.dispose();
        if (propertySheetPage != null) {
            propertySheetPage.dispose();
        }
        super.dispose();
    }

}
