/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.Window;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataFactory;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.diagram.er.ErGraphicalEditor;
import org.eclipse.jsr220orm.ui.internal.diagram.er.IHelpTextHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class LiveErView extends AbstractMetadataView implements Adapter,
        IHelpTextHelper {

    public static final String ID_VIEW = "org.eclipse.jsr220orm.ui.internal.views.LiveErView"; //$NON-NLS-1$

    private static final EAttribute tableName = (EAttribute) MetadataPackage.eINSTANCE
            .getOrmTable_Name();

    private ErGraphicalEditor erEditor;

    // private MetadataElement lastElement;
    private PropertySheetPage propertySheetPage;

    private SashForm sashForm;

    private FormToolkit toolkit;

    private FormText helpText;

    private Composite erMain;

    private ArrayList helpTextList = new ArrayList();

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl(book);
        page.setMessage("No Mapping info to display.");
        return page;
    }

    public void createPartControl(Composite parent) {
        sashForm = new SashForm(parent, SWT.NONE);
        toolkit = createToolkit(parent.getDisplay());
        erMain = toolkit.createComposite(sashForm);
        erMain.setLayout(new GridLayout());
        erEditor = new ErGraphicalEditor(erMain);
        erEditor.getControl()
                .setLayoutData(
                        new GridData(GridData.FILL_HORIZONTAL
                                | GridData.FILL_VERTICAL));
        helpText = toolkit.createFormText(erMain, false);
        helpText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        helpText.setColor("red", ColorConstants.red);
        Font initialFont = helpText.getFont();
        FontData[] fontData = initialFont.getFontData();
        for (int i = 0; i < fontData.length; i++) {
            fontData[i].setHeight(fontData[i].getHeight() - 1);
        }
        Font newFont = new Font(parent.getDisplay(), fontData);
        helpText.setFont(newFont);
        erEditor.setIHelpTextHelper(this);
        erEditor.setEditDomain(new EditDomain());
        getPropertySheetPage().createControl(sashForm);
        sashForm.setWeights(new int[] { 60, 40 });
        erEditor.addSelectionChangedListener(new ISelectionChangedListener() {

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection) event
                        .getSelection();
                EditPart editPart = (EditPart) selection.getFirstElement();
                // if (editPart != null && !(editPart instanceof
                // ColumnListEditPart)) {
                Object model = editPart.getModel();
                if (model instanceof MetadataElement) {
                    getPropertySheetPage().selectionChanged(LiveErView.this,
                            new StructuredSelection(model));
                } else {
                    getPropertySheetPage().selectionChanged(LiveErView.this,
                            new StructuredSelection());
                }
                // }
            }

        });
    }

    protected FormToolkit createToolkit(Display display) {
        // Create a toolkit that shares colors between editors.
        return new FormToolkit(OrmUiPlugin.getDefault().getFormColors(display));
    }

    public void setFocus() {
        if (erEditor != null) {
            erEditor.getControl().setFocus();
        }
    }

    protected void doUpdate(MetadataElement element) {
        if (sashForm == null || !sashForm.isVisible()) {
            return;
        }
        // if(lastElement != null){
        // lastElement.eAdapters().remove(this);
        // }
        helpTextList.clear();
        showHelpText();
        erEditor.setMetaDataElement(element);
        Object firstModelObject = erEditor.getFirstModelObject();
        if (firstModelObject != null) {
            erEditor.setSelection(new StructuredSelection(firstModelObject));
        }
        // lastElement = element;
        // if (lastElement != null){
        // lastElement.eAdapters().add(this);
        // }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(EObject.class) != Notification.NO_FEATURE_ID) {
            doUpdate(true);
        }
    }

    public Notifier getTarget() {
        // TODO Auto-generated method stub
        return null;
    }

    public void setTarget(Notifier newTarget) {
        // TODO Auto-generated method stub

    }

    public boolean isAdapterForType(Object type) {
        // "+type.getClass().getName());
        return type == EntityMetaData.class || type == OrmTable.class
                || type == OrmColumn.class;
    }

    /**
     * This accesses a cached version of the property sheet.
     */
    public IPropertySheetPage getPropertySheetPage() {
        if (propertySheetPage == null) {
            propertySheetPage = new PropertySheetPage();
            // Create an adapter factory that yields item providers.
            //
            List factories = new ArrayList();
            factories.add(new ResourceItemProviderAdapterFactory());
            factories.add(new MetadataItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());

            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(
                    factories);
            AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider(
                    adapterFactory) {
                protected IPropertySource createPropertySource(Object object,
                        IItemPropertySource itemPropertySource) {
                    if (object instanceof OrmTable) {
                        return new PropertySource(object, itemPropertySource) {
                            protected IPropertyDescriptor createPropertyDescriptor(
                                    IItemPropertyDescriptor itemPropertyDescriptor) {
                                if (itemPropertyDescriptor.getFeature(object) == tableName) {
                                    return new PropertyDescriptor(object,
                                            itemPropertyDescriptor) {
                                        public CellEditor createPropertyEditor(
                                                Composite composite) {
                                            CellEditor cellEditor = createTableNameEditor(
                                                    composite,
                                                    getEditLabelProvider(),
                                                    object);
                                            if (cellEditor != null) {
                                                return cellEditor;
                                            }
                                            return super
                                                    .createPropertyEditor(composite);
                                        }
                                    };
                                }
                                return super
                                        .createPropertyDescriptor(itemPropertyDescriptor);
                            }

                        };
                    }
                    return super.createPropertySource(object,
                            itemPropertySource);
                }
            };
            propertySheetPage
                    .setPropertySourceProvider(adapterFactoryContentProvider);
        }

        return propertySheetPage;
    }
//
//    private CellEditor createTableNameEditor(Composite composite,
//            ILabelProvider labelProvider, Object object) {
//        final OrmTable ormTable = (OrmTable) object;
//        Schema schema = (Schema) ormTable.adapt(Schema.class);
//        if (schema == null) {
//            return null;
//        }
//        final ArrayList tableNames = new ArrayList();
//        List tables = schema.getTables();
//        for (Iterator it = tables.iterator(); it.hasNext();) {
//            Table table = (Table) it.next();
//            tableNames.add(table.getName());
//        }
//        Collections.sort(tableNames);
//        TableViewer viewer = new TableViewer(composite);
//        return new TableTextCellEditor(viewer, 0);
//    }

    private CellEditor createTableNameEditor(Composite composite,
            ILabelProvider labelProvider, Object object) {
        final OrmTable ormTable = (OrmTable) object;
        Schema schema = (Schema) ormTable.adapt(Schema.class);
        if (schema == null) {
            return null;
        }
        final ArrayList tableNames = new ArrayList();
        List tables = schema.getTables();
        for (Iterator it = tables.iterator(); it.hasNext();) {
            Table table = (Table) it.next();
            tableNames.add(table.getName());
        }
        if(tableNames.isEmpty()){
            return null;
        }
        Collections.sort(tableNames);
        return new ExtendedDialogCellEditor(composite, labelProvider) {

            Text text;
            
            protected void updateContents(Object object) {
                text.setText(object == null ? "" : object.toString());
            }

            protected Control createContents(Composite cell) {
                text = new Text(cell, SWT.LEFT);
                text.setFont(cell.getFont());
                text.setBackground(cell.getBackground());
                text.addFocusListener(new FocusAdapter() {
                    public void focusLost(FocusEvent e) {
                        endEditFromText();
                    }
                });
                text.addKeyListener(new KeyAdapter() {
                    public void keyReleased(KeyEvent e) {
                        if (e.character == '\u001b') { // Escape
                            fireCancelEditor();
                        }
                    }
                });
                text.addSelectionListener(new SelectionAdapter() {
                    public void widgetDefaultSelected(SelectionEvent e) {
                        endEditFromText();
                    }
                });
                return text;
            }
            
            protected void endEditFromText() {
                if(isActivated()){
                    markDirty();
                    doSetValue(text.getText());
                    fireApplyEditorValue();
                    deactivate();
                }
            }
        
            protected Object openDialogBox(Control cellEditorWindow) {
                ILabelProvider labelProvider = new LabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(
                        getSite().getShell(), labelProvider);
                dialog.setTitle("Select a Project");
                dialog.setMessage("Select a Project");
                dialog.setElements(tableNames.toArray());
                dialog.setAllowDuplicates(false);
                dialog
                        .setInitialSelections(new Object[] { ormTable.getName() });
                if (dialog.open() == Window.OK) {
                    return dialog.getFirstResult();
                }
                return null;
            }
        };
    }

    public void addHelpText(String text) {
        if (!helpTextList.contains(text)) {
            helpTextList.add(text);
            showHelpText();
            erMain.layout();
        }
    }

    private void showHelpText() {
        StringBuffer helpTextBuffer = new StringBuffer("<form>");
        for (Iterator it = helpTextList.iterator(); it.hasNext();) {
            helpTextBuffer.append("<li>");
            helpTextBuffer.append(it.next());
            helpTextBuffer.append("</li>");
        }
        helpTextBuffer.append("</form>");
        helpText.setText(helpTextBuffer.toString(), true, false);
    }
}
