/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.popup.actions;

import java.util.Collections;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class NewEntityAction implements IObjectActionDelegate{

    private ICompilationUnit unit;
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
       this.targetPart = targetPart;
    }

    public void run(IAction action) {
        IType type = unit.findPrimaryType();
        String name = type.getFullyQualifiedName();
        IJavaProject javaProject = (IJavaProject) unit.getAncestor(IJavaElement.JAVA_PROJECT);
        IProject project = javaProject.getProject();
        try {

            if (project.hasNature(OrmNature.ID)) {
                OrmNature nature = (OrmNature) project.getNature(OrmNature.ID);
                if (nature != null) {
                    nature.getActiveOrmProject().getModelManager().makePersistent(
                    		Collections.singleton(name), null);
                    // TODO use IIntOption for type of entity instead of null
                }
            } else {

            }
        } catch (CoreException e) {
            OrmUiPlugin.logException(e, "Could not add class "+name, targetPart.getSite().getShell());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        unit = (ICompilationUnit) ((StructuredSelection)selection).getFirstElement();
        
    }

}
