/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping.composite;

import java.util.List;

import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.TypeMetaData;
import org.eclipse.jsr220orm.ui.internal.binding.AttElementTypeBinding;
import org.eclipse.jsr220orm.ui.internal.binding.EmfWidgetBinding;
import org.eclipse.jsr220orm.ui.internal.views.provider.OutlineLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CollectionAttributeComposite extends AttributeComposite {

    private boolean busy;
    private OutlineLabelProvider labelProvider;
    private EmfWidgetBinding orderBinding = new EmfWidgetBinding();
    private AttElementTypeBinding elementTypeBinding = new AttElementTypeBinding(); 

    public CollectionAttributeComposite() {
    }

    public Composite createComposite(final Composite parent, FormToolkit toolkit, ComposedAdapterFactory adapterFactory) {
        Composite composite = super.createComposite(parent, toolkit, adapterFactory);
        addCascade(composite, toolkit, adapterFactory, MetadataPackage.COLLECTION_ATTRIBUTE__CASCADE_TYPE);
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 2;
        gridData1.horizontalAlignment = GridData.FILL;
        gridData1.grabExcessHorizontalSpace = true;
//        setSize(new org.eclipse.swt.graphics.Point(328,200));
        toolkit.createLabel(composite, "Element type");
        Text tElementType = toolkit.createText(composite, "", SWT.BORDER);
        elementTypeBinding.bind(adapterFactory, tElementType);
        tElementType.setEditable(false);
        tElementType.setLayoutData(gridData1);
        Button bElementType = toolkit.createButton(composite, "...", SWT.NONE);
        bElementType.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                setElementType();
            }
        });
        addMappedBy(composite, toolkit, adapterFactory);
        toolkit.createLabel(composite, "Order by");
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        gridData3.horizontalAlignment = GridData.FILL;
        gridData3.grabExcessHorizontalSpace = true;
//        setSize(new org.eclipse.swt.graphics.Point(328,200));
        Text tOrder = toolkit.createText(composite, "", SWT.BORDER);
        tOrder.setLayoutData(gridData3);
        orderBinding.bind(adapterFactory, tOrder, MetadataPackage.COLLECTION_ATTRIBUTE__ORDER_BY);
        labelProvider = new OutlineLabelProvider(adapterFactory);
        return composite;
    }

    /**
     * 
     */
    private void setElementType() {
        final CollectionAttribute collection = (CollectionAttribute) attributeMD;
        IEntityModelManager manager = (IEntityModelManager) attributeMD.adapt(IEntityModelManager.class);
        if (manager != null) {
            List possibleElementTypes = manager.getPossibleElementTypes(collection);
            final ListDialog dialog = new ListDialog(getComposite().getShell()){

                protected int getShellStyle() {
                    return super.getShellStyle() | SWT.RESIZE;
                }
                
            };
            dialog.setHeightInChars(30);
            dialog.setWidthInChars(100);
//            dialog.sets
            dialog.setInput(possibleElementTypes.toArray());
            dialog.setTitle("Select element type.");
            dialog.setMessage("Please select the element type for collection: "+collection.getName());
            dialog.setLabelProvider(labelProvider);
            dialog.setContentProvider(new ArrayContentProvider());
            TypeMetaData et = collection.getElementType();
            if (et != null) {
                dialog.setInitialSelections(new Object[] { et });
            }
            dialog.setBlockOnOpen(true);
            if(dialog.open() == Window.OK){
                manager.executeModelChanges(new Runnable() {
                    public void run() {
                        collection.setElementType((TypeMetaData) dialog.getResult()[0]);
                    }
                });
            }
        }
    }

    public void setAttributeMetaData(AttributeMetaData attributeMD) {
        busy = true;
        super.setAttributeMetaData(attributeMD);
        elementTypeBinding.setEObject(attributeMD);
        orderBinding.setEObject(attributeMD);
        busy = false;
    }

    protected boolean canBeOptional() {
        return false;
    }

}  //  @jve:decl-index=0:visual-constraint="10,10"
