/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping.composite;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.ui.internal.binding.AttIsPkBinding;
import org.eclipse.jsr220orm.ui.internal.binding.AttIsVersionBinding;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BasicAttributeComposite extends AttributeComposite {

    private AttIsPkBinding attIsPkBinding = new AttIsPkBinding();
    private AttIsVersionBinding attIsVersionBinding = new AttIsVersionBinding();

    public BasicAttributeComposite() {
    }

    public Composite createComposite(final Composite parent, FormToolkit toolkit, AdapterFactory adapterFactory) {
        Composite composite = super.createComposite(parent, toolkit, adapterFactory);
        toolkit.createLabel(composite, "Primary key");
        Button tPk = toolkit.createButton(composite, "", SWT.CHECK);
        attIsPkBinding.bind(adapterFactory, tPk);
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 3;
        tPk.setLayoutData(gridData4);
        toolkit.createLabel(composite, "Version");
        Button tVersion = toolkit.createButton(composite, "", SWT.CHECK);
        attIsVersionBinding.bind(adapterFactory, tVersion);
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 3;
        tVersion.setLayoutData(gridData1);
        return composite;
    }

    public void setAttributeMetaData(AttributeMetaData attributeMD) {
        super.setAttributeMetaData(attributeMD);
        attIsPkBinding.setEObject(attributeMD);
        attIsVersionBinding.setEObject(attributeMD);
    }

}
