/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.jsr220orm.ui.internal.diagram.er.edit.RdbColumnDragPolicy;
import org.eclipse.jsr220orm.ui.internal.diagram.er.figure.ColumnFigure;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

/**
 * @author dirk
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RdbColumnEditPart extends AbstractGraphicalEditPart {
    
    /**
     * @param object
     */
    public RdbColumnEditPart(Object model) {
        setModel(model);
    }
    
    public IFigure createFigure() {
        TableEditPart tableEditPart = (TableEditPart) getParent();
        return new ColumnFigure(tableEditPart.getOrmCols(), tableEditPart.getRdbCols(), 
                tableEditPart.isConnected());
    }
    
    protected void createEditPolicies() {
        installEditPolicy(EditPolicy.COMPONENT_ROLE, new RdbColumnDragPolicy());
   }

    protected void refreshVisuals() {
        refreshVisuals(getFigure(), getModel());
    }
    
    public void refreshVisuals(IFigure figure, Object object) {
        Column c = (Column)object;
        ColumnFigure cf = (ColumnFigure)figure;
        cf.setName(c.getName());
        cf.setType(RdbUtils.getColumnTypeDescr(c));
    }

    public void setSelected(int value)
    {
        super.setSelected(value);
        ColumnFigure figure = (ColumnFigure) getFigure();
        if (value != EditPart.SELECTED_NONE)
            figure.setSelected(true);
        else
            figure.setSelected(false);
    }


    /**
     * Overridden to return a default <code>DragTracker</code> for GraphicalEditParts.
     * @see org.eclipse.gef.EditPart#getDragTracker(Request)
     */
    public DragTracker getDragTracker(Request request) {
        return new org.eclipse.gef.tools.DragEditPartsTracker(this){
            protected boolean isMove() {
//                EditPart part = getSourceEditPart();
//                while (part != getTargetEditPart() && part != null) {
//                    if (part.getParent() == getTargetEditPart() 
//                            && part.getSelected() != EditPart.SELECTED_NONE)
                        return true;
//                    part = part.getParent();
//                }
//                return false;
            }
        };
    }

    /**
     * @see org.eclipse.gef.EditPart#performRequest(org.eclipse.gef.Request)
     */
    public void performRequest(Request request) {
//        System.out.println("TableEditPart.performRequest(): "+ request.getType());
//        if (request.getType() == RequestConstants.REQ_DIRECT_EDIT) {
//            if (request instanceof DirectEditRequest
//                    && !directEditHitTest(((DirectEditRequest) request)
//                            .getLocation().getCopy()))
//                return;
//            performDirectEdit();
//        }
    }
}