/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/*
 * Created on Mar 22, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.figure;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jsr220orm.ui.internal.diagram.EditableLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;

/**
 * @author dirk
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class TableFigure extends Figure {

    public static Color classColor = new Color(null, 255, 255, 255);
    public static final Color TOP_COLOR = new Color(null, 250,250,230);

    private EditableLabel nameLabel = new EditableLabel();
    private IFigure contentPane;
    
    public TableFigure() {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(ToolbarLayout.ALIGN_TOPLEFT);
        layout.setStretchMinorAxis(true);
        layout.setSpacing(2);
        setLayoutManager(layout);
        setBorder(new DropShadowBorder());
        nameLabel.setBorder(new BottomLineBorder());
        setBackgroundColor(TOP_COLOR);
        setOpaque(false);
        add(nameLabel);
        nameLabel.setOpaque(true);
        nameLabel.setBackgroundColor(TOP_COLOR);
        contentPane = new Figure(){
            protected void paintFigure(Graphics graphics) {
                graphics.pushState();
                graphics.setForegroundColor(TOP_COLOR);
                graphics.setBackgroundColor(ColorConstants.white);
                Rectangle bounds2 = new Rectangle(getBounds());
                graphics.fillGradient(bounds2, true);
                graphics.popState();
            }
        };
        ToolbarLayout contentLayout = new ToolbarLayout(false);
        layout.setMinorAlignment(ToolbarLayout.ALIGN_TOPLEFT);
        layout.setStretchMinorAxis(true);
        layout.setSpacing(0);
        contentPane.setLayoutManager(layout);
        add(contentPane);
    }

    public IFigure getContentPane() {
        return contentPane;
    }

    public void setName(String name) {
        nameLabel.setText(name);
    }

    public void setToolTipText(String toolTipText){
        if(toolTipText == null || toolTipText.trim().length() == 0){
            setToolTip(null);
        }else{
            Label label = new Label(toolTipText);
            label.setBackgroundColor(ColorConstants.tooltipBackground);
            label.setForegroundColor(ColorConstants.tooltipForeground);
            setToolTip(label);
        }
    }

    public class BottomLineBorder extends AbstractBorder {
        Insets insets = new Insets(0, 0, 1, 0);
        public Insets getInsets(IFigure figure) {
            return insets;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setForegroundColor(ColorConstants.black);
            tempRect.setBounds(getPaintRectangle(figure, insets));
//            graphics.setForegroundColor(figure.getForegroundColor());
            int y = tempRect.y + tempRect.height - 1;
            graphics.drawLine(tempRect.x, y, tempRect.x + tempRect.width, y);

            // graphics.drawLine(getPaintRectangle(figure,
            // insets).getBottomLeft(),
            // tempRect.getBottomRight());
        }
    }

    public void setNameVisible(boolean visible) {
        nameLabel.setVisible(visible);
        
    }

    public EditableLabel getNameLabel() {
        return nameLabel;
    }

    public void setSelected(boolean selected) {
        nameLabel.setSelected(selected);
        repaint();
    }

    protected void paintFigured(Graphics graphics) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.lightBlue);
        graphics.setBackgroundColor(ColorConstants.white);
        Rectangle bounds2 = new Rectangle(getBounds());
        graphics.fillGradient(bounds2.crop(getBorder().getInsets(this)), true);
        bounds2.height = nameLabel.getBounds().height;
        graphics.setForegroundColor(ColorConstants.white);
        graphics.setBackgroundColor(ColorConstants.lightBlue);
        graphics.fillGradient(bounds2.crop(getBorder().getInsets(this)), true);
        graphics.popState();    
    }
    
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;
  
    public void setBackground(Color[] colors, int[] percents, boolean vertical) {   
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(SWT.ERROR_INVALID_ARGUMENT);
            }
            if (PlatformUI.getWorkbench().getDisplay().getDepth() < 15) {
                // Don't use gradients on low color displays
                colors = new Color[] {colors[colors.length - 1]};
                percents = new int[] { };
            }
            for (int i = 0; i < percents.length; i++) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(SWT.ERROR_INVALID_ARGUMENT);
                }
                if (i > 0 && percents[i] < percents[i-1]) {
                    SWT.error(SWT.ERROR_INVALID_ARGUMENT);
                }
            }
        }
        
        // Store the new settings
        if (colors == null) {
            gradientColors = null;
            gradientPercents = null;
            gradientVertical = false;
        } else {
            gradientColors = new Color[colors.length];
            for (int i = 0; i < colors.length; ++i)
                gradientColors[i] = (colors[i] != null) ? colors[i] : getBackgroundColor();
            gradientPercents = new int[percents.length];
            for (int i = 0; i < percents.length; ++i)
                gradientPercents[i] = percents[i];
            gradientVertical = vertical;
        }
    }  

    protected void paintFigures(Graphics graphics) {
        Rectangle rect = getClientArea();
        if (rect.width == 0 || rect.height == 0) return;
        if (gradientColors != null) {
            // draw a gradient 
            final Color oldBackground = graphics.getBackgroundColor();
            if (gradientColors.length == 1) {
                if (gradientColors[0] != null) graphics.setBackgroundColor(gradientColors[0]);
                graphics.fillRectangle(0, 0, rect.width, rect.height);
            } else {
                final Color oldForeground = graphics.getForegroundColor();
                Color lastColor = gradientColors[0];
                if (lastColor == null) lastColor = oldBackground;
                int pos = 0;
                for (int i = 0; i < gradientPercents.length; ++i) {
                    graphics.setForegroundColor(lastColor);
                    lastColor = gradientColors[i + 1];
                    if (lastColor == null) lastColor = oldBackground;
                    graphics.setBackgroundColor(lastColor);
                    if (gradientVertical) {
                        final int gradientHeight = (gradientPercents[i] * rect.height / 100) - pos;
                        graphics.fillGradient(0, pos, rect.width, gradientHeight, true);
                        pos += gradientHeight;
                    } else {
                        final int gradientWidth = (gradientPercents[i] * rect.width / 100) - pos;
                        graphics.fillGradient(pos, 0, gradientWidth, rect.height, false);
                        pos += gradientWidth;
                    }
                }
                if (gradientVertical && pos < rect.height) {
                    graphics.setBackgroundColor(getBackgroundColor());
                    graphics.fillRectangle(0, pos, rect.width, rect.height - pos);
                }
                if (!gradientVertical && pos < rect.width) {
                    graphics.setBackgroundColor(getBackgroundColor());
                    graphics.fillRectangle(pos, 0, rect.width - pos, rect.height);
                }
                graphics.setForegroundColor(oldForeground);
            }
            graphics.setBackgroundColor(oldBackground);
        } else {
            Rectangle bounds2 = new Rectangle(getBounds());
            graphics.fillRectangle(bounds2.crop(getBorder().getInsets(this)));
        }
    }
}
