/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.edit;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.ui.internal.diagram.er.command.RdbColumnDragCommand;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ColumnEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.RdbColumnEditPart;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class OrmColumnDragPolicy extends GraphicalEditPolicy {

    private EditPart host;
    private IFigure dragFigure;
    private IFigure targetFeedback;

    public OrmColumnDragPolicy() {
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void eraseSourceFeedback(Request request) {
        if (dragFigure != null) {
            removeFeedback(dragFigure);
        }
        clearTargetFeedback();
    }

    public void eraseTargetFeedback(Request request) {
    }

    public Command getCommand(Request request) {
        EditPart editPart = getTargetEditPart(request);
        if(editPart instanceof RdbColumnEditPart && host instanceof ColumnEditPart){
            OrmColumn ormColumn = (OrmColumn) host.getModel();
            Column rdbColumn = (Column) editPart.getModel();
            RdbColumnDragCommand command = new RdbColumnDragCommand(ormColumn, rdbColumn);
            return command;
        }
        return null;
    }

    public EditPart getHost() {
        return host;
    }

    public EditPart getTargetEditPart(Request request) {
        if(request instanceof ChangeBoundsRequest){
            ChangeBoundsRequest request2 = (ChangeBoundsRequest) request;
            List children = getHost().getParent().getChildren();
            for(Iterator it = children.iterator(); it.hasNext();){
                GraphicalEditPart editPart = (GraphicalEditPart) it.next();
                IFigure figure = editPart.getFigure();
                if(figure.getBounds().contains(request2.getLocation())){
                    return editPart;
                }
            }
        }
        return host;
    }

    public void setHost(EditPart editpart) {
        host = editpart;
    }

    public void showSourceFeedback(Request request) {
        IFigure figure = getDragFigure();
        ChangeBoundsRequest request2 = (ChangeBoundsRequest) request;
        Dimension size = figure.getSize();
        figure.setLocation(request2.getLocation().getTranslated(15,0));
        addFeedback(figure);
    
        clearTargetFeedback();
        setTargetFeedBack(request);
    }

    private void setTargetFeedBack(Request request) {
        EditPart target = getTargetEditPart(request);
        if(target != null && target != host){
            targetFeedback = ((AbstractGraphicalEditPart)target).getFigure();
            targetFeedback.setOpaque(true);
            targetFeedback.repaint();
        }
    }

    private void clearTargetFeedback() {
        if(targetFeedback != null){
            targetFeedback.setOpaque(false);
            targetFeedback = null;
        }
    }

    public IFigure getDragFigure(){
        if(dragFigure == null){
            ColumnEditPart rep = (ColumnEditPart)getHost();
            dragFigure = rep.createFigure();
            rep.refreshVisuals(dragFigure);
            IFigure hostFigure = getHostFigure();
            dragFigure.setFont(hostFigure.getFont());
            dragFigure.setSize(dragFigure.getPreferredSize());
        }
        return dragFigure;
    }
    
    public void showTargetFeedback(Request request) {
    }

    public boolean understandsRequest(Request request) {
        return REQ_MOVE.equals(request.getType());
    }
}
