/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EmfRadioButtonGroupBinding extends EmfAbstractBinding implements SelectionListener{
    protected Composite composite;
    private FormToolkit toolkit;
    protected int style = SWT.RADIO;
    private Color foreground;
    
    public EmfRadioButtonGroupBinding(FormToolkit toolkit) {
        super();
        this.toolkit = toolkit;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jsr220orm.ui.internal.binding.IEmfWidgetBinding#bind(org.eclipse.emf.common.notify.AdapterFactory, org.eclipse.swt.widgets.Widget, int)
     */
    public void bind(AdapterFactory adapterFactory, Widget widget, int featureId) {
        super.bind(adapterFactory, widget, featureId);
        this.composite = (Composite) widget;
    }

    protected void installListeners() {
        super.installListeners();
        Control[] children = composite.getChildren();
        for (int x = 0; x < children.length; x++) {
            Button button = (Button) children[x];
            button.addSelectionListener(this);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        Control[] children = composite.getChildren();
        for (int x = 0; x < children.length; x++) {
            Button button = (Button) children[x];
            button.removeSelectionListener(this);
        }
    }

    protected void setChoicesFromModel(IItemLabelProvider labelProvider, Collection choices) {
        Control[] children = composite.getChildren();
        for (int x = children.length; x < choices.size(); x++) {
            Button button = toolkit.createButton(composite, "", style);
            if(foreground != null){
                button.setForeground(foreground);
            }
        }
        for (int x = choices.size(); x < children.length; x++) {
            Button button = (Button) children[x];
            button.removeSelectionListener(this);
            button.dispose();
        }
        children = composite.getChildren();
        ArrayList temp = new ArrayList(choices);
        for (int x = 0; x < children.length; x++) {
            Button button = (Button) children[x];
            Object choice = temp.get(x);
            button.removeSelectionListener(this);
            button.setData(choice);

            String text = labelProvider.getText(choice);
            button.setText(text);
            Object image = labelProvider.getImage(choice);
            if (image instanceof Image) {
                button.setImage((Image) image);
            } else {
                button.setImage(null);
            }
            button.addSelectionListener(this);
        }
        composite.redraw();
    }

    protected void setValueFromModel(IItemLabelProvider labelProvider, Object value) {
        Control[] children = composite.getChildren();
        for (int x = 0; x < children.length; x++) {
            Button button = (Button) children[x];
            Object data = button.getData();
            button.setSelection(isValidOption(value, data));
        }
    }

    protected boolean isValidOption(Object value, Object option) {
        return value != null && value.equals(option);
    }

    public void widgetSelected(SelectionEvent e) {
        setValuesFromWidget(((Button)e.getSource()).getData());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}
