/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Widget;

public class EmfComboBinding extends EmfAbstractBinding implements SelectionListener{
    private CCombo combo;
    private List choices;
    
    /* (non-Javadoc)
     * @see org.eclipse.jsr220orm.ui.internal.binding.IEmfWidgetBinding#bind(org.eclipse.emf.common.notify.AdapterFactory, org.eclipse.swt.widgets.Widget, int)
     */
    public void bind(AdapterFactory adapterFactory, Widget widget, int featureId) {
        super.bind(adapterFactory, widget, featureId);
        this.combo = (CCombo) widget;
    }

    protected void installListeners() {
        super.installListeners();
        combo.addSelectionListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        combo.removeSelectionListener(this);
    }

    protected void setChoicesFromModel(IItemLabelProvider labelProvider, Collection choices) {
        this.choices = new ArrayList(choices);
        combo.removeAll();
        for(Iterator it = choices.iterator(); it.hasNext();){
            String s = getTextFromObject(labelProvider, it.next());
            combo.add(s);
        }
    }

    protected String getTextFromObject(IItemLabelProvider labelProvider, Object value) {
        return labelProvider.getText(value);
    }

    protected void setValueFromModel(IItemLabelProvider labelProvider, Object value) {
        String newValue = getTextFromObject(labelProvider, value);
        if(newValue == null){
            return;
        }
        for(int x = 0; x < combo.getItemCount(); x++){
            if(newValue.equals(combo.getItem(x))){
                combo.select(x);
                return;
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        int selectionIndex = combo.getSelectionIndex();
        if(selectionIndex >= 0){
            setValuesFromWidget(choices.get(selectionIndex));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}
