/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EmfCheckButtonGroupBinding extends EmfRadioButtonGroupBinding {

    public EmfCheckButtonGroupBinding(FormToolkit toolkit) {
        super(toolkit);
        style = SWT.CHECK;
    }

    protected boolean isValidOption(Object value, Object option) {
        int v = ((Integer)value).intValue();
        int o = ((Integer)option).intValue();
        return (v & o) != 0;
    }

    public void widgetSelected(SelectionEvent e) {
        int value = 0;
        Control[] children = composite.getChildren();
        for (int x = 0; x < children.length; x++) {
            Button button = (Button) children[x];
            if (button.getSelection()) {
                int o = ((Integer) button.getData()).intValue();
                value = value | o;
            }
        }
        final Integer integer = new Integer(value);
        Runnable runnable = new Runnable() {
            public void run() {
                setValuesFromWidget(integer);
            }
        };
        composite.getDisplay().asyncExec(runnable);          
    }
}
