/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.Collection;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

public class AttIsPkBinding extends EmfAbstractBinding implements SelectionListener{
    private Button button;
    private Runnable lastTask;
    private AttributeMetaData attribute;
   /* (non-Javadoc)
     * @see org.eclipse.jsr220orm.ui.internal.binding.IEmfWidgetBinding#bind(org.eclipse.emf.common.notify.AdapterFactory, org.eclipse.swt.widgets.Widget, int)
     */
    public void bind(AdapterFactory adapterFactory, Widget widget) {
        super.bind(adapterFactory, widget, MetadataPackage.ENTITY_META_DATA__PRIMARY_KEY_LIST);
        this.button = (Button) widget;
    }

    public void setEObject(EObject notifier) {
        attribute = (AttributeMetaData) notifier;
        super.setEObject(attribute.getEntityMetaData());
    }

    protected void installListeners() {
        super.installListeners();
        button.addSelectionListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        button.removeSelectionListener(this);
    }

    protected void setValueFromModel(IItemLabelProvider labelProvider, Object value) {
        button.setSelection(attribute.isPrimaryKey());
        button.setEnabled(!attribute.isVersion());
    }

    protected void setChoicesFromModel(IItemLabelProvider provider, Collection choices) {
    }

    public void widgetSelected(SelectionEvent e) {
        Runnable runnable = null;
        if(button.getSelection()){
            if(!attribute.isPrimaryKey()){
                runnable = new Runnable() {
                    public void run() {
                        EntityMetaData emd = attribute.getEntityMetaData();
                        emd.getPrimaryKeyList().add(attribute);
                    }
                };
            }
        }else{
            if(attribute.isPrimaryKey()){
                runnable = new Runnable() {
                    public void run() {
                        EntityMetaData emd = attribute.getEntityMetaData();
                        emd.getPrimaryKeyList().remove(attribute);
                    }
                };
            }
        }
        if(runnable != null){
            setValuesFromWidget(runnable);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}
