/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.product;

import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.metadata.EntityModel;

/**
 * Associates an OrmProduct with an EntityModel and its manager.
 */
public class OrmProductState {

	private OrmProduct product;

	private IEntityModelManager modelManager;

	private EntityModel model;

	public EntityModel getModel() {
		return model;
	}

	public void setModel(EntityModel model) {
		this.model = model;
	}

	public IEntityModelManager getModelManager() {
		return modelManager;
	}

	public void setModelManager(IEntityModelManager modelManager) {
		this.modelManager = modelManager;
	}

	public OrmProduct getProduct() {
		return product;
	}

	public void setProduct(OrmProduct product) {
		this.product = product;
	}

	public String toString() {
		return product.toString();
	}
}
