/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.reflect;

/**
 * Replacement for the parts of the JDK reflection API. Implementations can
 * choose to get the info from somewhere else (e.g. source code or XML). 
 */
public interface RClass extends RAnnotatedElement {
	
	/**
	 * Get the fully qualified name of the class. 
	 */
	public String getName();
	
	/**
	 * Returns the simple name of the underlying class as given in the 
	 * source code.
	 */
	public String getSimpleName();
	
	/**
	 * Returns an array of Field objects reflecting all the fields declared 
	 * by the class or interface represented by this Class object. 
	 */
	public RField[] getDeclaredFields(); 
	
	/**
	 * Returns an array of Method objects reflecting all the methods 
	 * declared by the class or interface represented by this Class object.
	 */
	public RMethod[] getDeclaredMethods(); 
	
	/**
	 * Get the fully qualified name of our superclass.
	 */
	public String getSuperclassName();
	
	/**
	 * Lookup a field declared in this class by name or return null if none.
	 */
	public RField getDeclaredField(String name);

	/**
	 * Lookup a method declared in this class by name or return null if none.
	 */
	public RMethod getDeclaredMethod(String name);
	
}
