/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.internal.ui.config;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jsr220orm.ui.IProductActivationWizard;

public class GenericProductActivationWizard extends Wizard implements
        IProductActivationWizard {

    private GenericProductActivationPage activationPage = new GenericProductActivationPage("EJB3 persistence.xml Settings");
    
    public GenericProductActivationWizard() {
    }

    @Override
    public void addPages() {
        super.addPages();
        addPage(activationPage);
    }

    @Override
    public boolean performFinish() {
        return activationPage.performFinish();
    }

    public void setIProject(IProject project) {
        activationPage.setIProject(project);
    }

}
