/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: OrmColumnItemProvider.java,v 1.16 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;

/**
 * This is the item provider adapter for a {@link org.eclipse.jsr220orm.metadata.OrmColumn} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class OrmColumnItemProvider
	extends MetadataElementItemProvider
	implements	
		IEditingDomainItemProvider,	
		IStructuredItemContentProvider,	
		ITreeItemContentProvider,	
		IItemLabelProvider,	
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumnItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addNamePropertyDescriptor(object);
			addJdbcTypePropertyDescriptor(object);
			addNullablePropertyDescriptor(object);
			addInsertablePropertyDescriptor(object);
			addUpdatablePropertyDescriptor(object);
			addLengthPropertyDescriptor(object);
			addScalePropertyDescriptor(object);
			addColumnDefinitionPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_name_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OrmColumn_name_feature", "_UI_OrmColumn_type"),
				 MetadataPackage.eINSTANCE.getOrmColumn_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Jdbc Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	protected void addJdbcTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new IntOptionDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_jdbcType_feature"),
				 getString("_UI_OrmColumn_jdbcType_description"),
				 MetadataPackage.eINSTANCE.getOrmColumn_JdbcType(),
				 true,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Nullable feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNullablePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_nullable_feature"),
				 getString("_UI_OrmColumn_nullable_description"),
				 MetadataPackage.eINSTANCE.getOrmColumn_Nullable(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Insertable feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInsertablePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_insertable_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OrmColumn_insertable_feature", "_UI_OrmColumn_type"),
				 MetadataPackage.eINSTANCE.getOrmColumn_Insertable(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Updatable feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUpdatablePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_updatable_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OrmColumn_updatable_feature", "_UI_OrmColumn_type"),
				 MetadataPackage.eINSTANCE.getOrmColumn_Updatable(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Length feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLengthPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_length_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OrmColumn_length_feature", "_UI_OrmColumn_type"),
				 MetadataPackage.eINSTANCE.getOrmColumn_Length(),
				 true,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Scale feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addScalePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_scale_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OrmColumn_scale_feature", "_UI_OrmColumn_type"),
				 MetadataPackage.eINSTANCE.getOrmColumn_Scale(),
				 true,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Column Definition feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addColumnDefinitionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_OrmColumn_columnDefinition_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_OrmColumn_columnDefinition_feature", "_UI_OrmColumn_type"),
				 MetadataPackage.eINSTANCE.getOrmColumn_ColumnDefinition(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(MetadataPackage.eINSTANCE.getOrmColumn_Table());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getOrmColumn_SrcJoinPairs());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getOrmColumn_DestJoinPairs());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns OrmColumn.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return getResourceLocator().getImage("full/obj16/OrmColumn");
	}

    /**
     * This returns the label text for the adapted class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     */
	public String getText(Object object) {
        OrmColumn ormColumn = (OrmColumn)object;
        String name = ormColumn.getName();
        if(name == null){
            name = "";
        }
        OrmTable table = ormColumn.getTable();
        if (table != null) {
            String tableName = table.getName();
            if(tableName != null){
                name = tableName+"."+name;
            }
        }
        return name + " " + ormColumn.getRelativePositionInTable();
    }

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(OrmColumn.class)) {
			case MetadataPackage.ORM_COLUMN__NAME:
			case MetadataPackage.ORM_COLUMN__JDBC_TYPE:
			case MetadataPackage.ORM_COLUMN__NULLABLE:
			case MetadataPackage.ORM_COLUMN__INSERTABLE:
			case MetadataPackage.ORM_COLUMN__UPDATABLE:
			case MetadataPackage.ORM_COLUMN__LENGTH:
			case MetadataPackage.ORM_COLUMN__SCALE:
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION:
			case MetadataPackage.ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED:
			case MetadataPackage.ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION:
			case MetadataPackage.ORM_COLUMN__DATABASE_TYPE:
			case MetadataPackage.ORM_COLUMN__COMMENT:
			case MetadataPackage.ORM_COLUMN__RELATIVE_POSITION_IN_TABLE:
			case MetadataPackage.ORM_COLUMN__IDENTITY:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return MetadataEditPlugin.INSTANCE;
	}

}
