/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: EntityMetaDataImpl.java,v 1.17 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Entity Meta Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getEntityType <em>Entity Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getSchemaName <em>Schema Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getSuperEntity <em>Super Entity</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getSubEntityList <em>Sub Entity List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getAttributeList <em>Attribute List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getPrimaryKeyList <em>Primary Key List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getVersionList <em>Version List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getIdGeneratorType <em>Id Generator Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getIdGeneratorName <em>Id Generator Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getIdClass <em>Id Class</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getTable <em>Table</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getSecondaryTableJoinList <em>Secondary Table Join List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getAccessType <em>Access Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getInheritance <em>Inheritance</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#isInheritanceSpecified <em>Inheritance Specified</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getDiscriminatorType <em>Discriminator Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getDiscriminatorValue <em>Discriminator Value</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getDiscriminatorColumn <em>Discriminator Column</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl#getSuperJoin <em>Super Join</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EntityMetaDataImpl extends TypeMetaDataImpl implements
		EntityMetaData {
	/**
	 * The default value of the '{@link #getEntityType() <em>Entity Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntityType()
	 * @generated
	 * @ordered
	 */
	protected static final int ENTITY_TYPE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getEntityType() <em>Entity Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntityType()
	 * @generated
	 * @ordered
	 */
	protected int entityType = ENTITY_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSchemaName() <em>Schema Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSchemaName()
	 * @generated
	 * @ordered
	 */
	protected static final String SCHEMA_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSchemaName() <em>Schema Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSchemaName()
	 * @generated
	 * @ordered
	 */
	protected String schemaName = SCHEMA_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSuperEntity() <em>Super Entity</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSuperEntity()
	 * @generated
	 * @ordered
	 */
	protected EntityMetaData superEntity = null;

	/**
	 * The cached value of the '{@link #getSubEntityList() <em>Sub Entity List</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSubEntityList()
	 * @generated
	 * @ordered
	 */
	protected EList subEntityList = null;

	/**
	 * The cached value of the '{@link #getAttributeList() <em>Attribute List</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAttributeList()
	 * @generated
	 * @ordered
	 */
	protected EList attributeList = null;

	/**
	 * The cached value of the '{@link #getPrimaryKeyList() <em>Primary Key List</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getPrimaryKeyList()
	 * @generated
	 * @ordered
	 */
	protected EList primaryKeyList = null;

	/**
	 * The cached value of the '{@link #getVersionList() <em>Version List</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersionList()
	 * @generated
	 * @ordered
	 */
	protected EList versionList = null;

	/**
	 * The default value of the '{@link #getIdGeneratorType() <em>Id Generator Type</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getIdGeneratorType()
	 * @generated
	 * @ordered
	 */
    protected static final int ID_GENERATOR_TYPE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getIdGeneratorType() <em>Id Generator Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getIdGeneratorType()
	 * @generated
	 * @ordered
	 */
	protected int idGeneratorType = ID_GENERATOR_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getIdGeneratorName() <em>Id Generator Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getIdGeneratorName()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_GENERATOR_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIdGeneratorName() <em>Id Generator Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getIdGeneratorName()
	 * @generated
	 * @ordered
	 */
	protected String idGeneratorName = ID_GENERATOR_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getIdClass() <em>Id Class</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getIdClass()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_CLASS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIdClass() <em>Id Class</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getIdClass()
	 * @generated
	 * @ordered
	 */
	protected String idClass = ID_CLASS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTable() <em>Table</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getTable()
	 * @generated
	 * @ordered
	 */
	protected OrmTable table = null;

	/**
	 * The cached value of the '{@link #getSecondaryTableJoinList() <em>Secondary Table Join List</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSecondaryTableJoinList()
	 * @generated
	 * @ordered
	 */
	protected EList secondaryTableJoinList = null;

	/**
	 * The default value of the '{@link #getAccessType() <em>Access Type</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getAccessType()
	 * @generated
	 * @ordered
	 */
    protected static final int ACCESS_TYPE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getAccessType() <em>Access Type</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getAccessType()
	 * @generated
	 * @ordered
	 */
    protected int accessType = ACCESS_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritance() <em>Inheritance</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritance()
	 * @generated
	 * @ordered
	 */
	protected static final int INHERITANCE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInheritance() <em>Inheritance</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritance()
	 * @generated
	 * @ordered
	 */
	protected int inheritance = INHERITANCE_EDEFAULT;

	/**
	 * The default value of the '{@link #isInheritanceSpecified() <em>Inheritance Specified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInheritanceSpecified()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INHERITANCE_SPECIFIED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInheritanceSpecified() <em>Inheritance Specified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInheritanceSpecified()
	 * @generated
	 * @ordered
	 */
	protected boolean inheritanceSpecified = INHERITANCE_SPECIFIED_EDEFAULT;

	/**
	 * The default value of the '{@link #getDiscriminatorType() <em>Discriminator Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscriminatorType()
	 * @generated
	 * @ordered
	 */
	protected static final int DISCRIMINATOR_TYPE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDiscriminatorType() <em>Discriminator Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscriminatorType()
	 * @generated
	 * @ordered
	 */
	protected int discriminatorType = DISCRIMINATOR_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDiscriminatorValue() <em>Discriminator Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscriminatorValue()
	 * @generated
	 * @ordered
	 */
	protected static final String DISCRIMINATOR_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDiscriminatorValue() <em>Discriminator Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscriminatorValue()
	 * @generated
	 * @ordered
	 */
	protected String discriminatorValue = DISCRIMINATOR_VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDiscriminatorColumn() <em>Discriminator Column</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscriminatorColumn()
	 * @generated
	 * @ordered
	 */
	protected OrmColumn discriminatorColumn = null;

	/**
	 * The cached value of the '{@link #getSuperJoin() <em>Super Join</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSuperJoin()
	 * @generated
	 * @ordered
	 */
	protected Join superJoin = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityMetaDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getEntityMetaData();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getEntityType() {
		return entityType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntityType(int newEntityType) {
		int oldEntityType = entityType;
		entityType = newEntityType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__ENTITY_TYPE, oldEntityType, entityType));
	}

    	public String getSchemaName() {
        String schemaName = getSchemaNameGen();
        if(schemaName == null && className != null){
            schemaName = className.substring(className.lastIndexOf('.')+1);
        }
        return schemaName;
    }
	
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getSchemaNameGen() {
		return schemaName;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSchemaName(String newSchemaName) {
		String oldSchemaName = schemaName;
		schemaName = newSchemaName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__SCHEMA_NAME, oldSchemaName, schemaName));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EntityMetaData getSuperEntity() {
		if (superEntity != null && superEntity.eIsProxy()) {
			EntityMetaData oldSuperEntity = superEntity;
			superEntity = (EntityMetaData)eResolveProxy((InternalEObject)superEntity);
			if (superEntity != oldSuperEntity) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY, oldSuperEntity, superEntity));
			}
		}
		return superEntity;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EntityMetaData basicGetSuperEntity() {
		return superEntity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSuperEntity(EntityMetaData newSuperEntity, NotificationChain msgs) {
		EntityMetaData oldSuperEntity = superEntity;
		superEntity = newSuperEntity;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY, oldSuperEntity, newSuperEntity);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuperEntity(EntityMetaData newSuperEntity) {
		if (newSuperEntity != superEntity) {
			NotificationChain msgs = null;
			if (superEntity != null)
				msgs = ((InternalEObject)superEntity).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST, EntityMetaData.class, msgs);
			if (newSuperEntity != null)
				msgs = ((InternalEObject)newSuperEntity).eInverseAdd(this, MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST, EntityMetaData.class, msgs);
			msgs = basicSetSuperEntity(newSuperEntity, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY, newSuperEntity, newSuperEntity));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubEntityList() {
		if (subEntityList == null) {
			subEntityList = new EObjectWithInverseResolvingEList(EntityMetaData.class, this, MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST, MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY);
		}
		return subEntityList;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList getAttributeList() {
		if (attributeList == null) {
			attributeList = new EObjectWithInverseEList(AttributeMetaData.class, this, MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST, MetadataPackage.ATTRIBUTE_META_DATA__ENTITY_META_DATA);
		}
		return attributeList;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPrimaryKeyList() {
		if (primaryKeyList == null) {
			primaryKeyList = new EObjectResolvingEList(AttributeMetaData.class, this, MetadataPackage.ENTITY_META_DATA__PRIMARY_KEY_LIST);
		}
		return primaryKeyList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getVersionList() {
		if (versionList == null) {
			versionList = new EObjectResolvingEList(AttributeMetaData.class, this, MetadataPackage.ENTITY_META_DATA__VERSION_LIST);
		}
		return versionList;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public int getIdGeneratorType() {
		return idGeneratorType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdGeneratorType(int newIdGeneratorType) {
		int oldIdGeneratorType = idGeneratorType;
		idGeneratorType = newIdGeneratorType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_TYPE, oldIdGeneratorType, idGeneratorType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getIdGeneratorName() {
		return idGeneratorName;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdGeneratorName(String newIdGeneratorName) {
		String oldIdGeneratorName = idGeneratorName;
		idGeneratorName = newIdGeneratorName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_NAME, oldIdGeneratorName, idGeneratorName));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getIdClass() {
		return idClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdClass(String newIdClass) {
		String oldIdClass = idClass;
		idClass = newIdClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__ID_CLASS, oldIdClass, idClass));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public OrmTable getTable() {
		if (table != null && table.eIsProxy()) {
			OrmTable oldTable = table;
			table = (OrmTable)eResolveProxy((InternalEObject)table);
			if (table != oldTable) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ENTITY_META_DATA__TABLE, oldTable, table));
			}
		}
		return table;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public OrmTable basicGetTable() {
		return table;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setTable(OrmTable newTable) {
		OrmTable oldTable = table;
		table = newTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__TABLE, oldTable, table));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSecondaryTableJoinList() {
		if (secondaryTableJoinList == null) {
			secondaryTableJoinList = new EObjectResolvingEList(Join.class, this, MetadataPackage.ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST);
		}
		return secondaryTableJoinList;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public int getAccessType() {
		return accessType;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setAccessType(int newAccessType) {
		int oldAccessType = accessType;
		accessType = newAccessType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__ACCESS_TYPE, oldAccessType, accessType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getInheritance() {
		return inheritance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritance(int newInheritance) {
		int oldInheritance = inheritance;
		inheritance = newInheritance;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__INHERITANCE, oldInheritance, inheritance));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInheritanceSpecified() {
		return inheritanceSpecified;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritanceSpecified(boolean newInheritanceSpecified) {
		boolean oldInheritanceSpecified = inheritanceSpecified;
		inheritanceSpecified = newInheritanceSpecified;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__INHERITANCE_SPECIFIED, oldInheritanceSpecified, inheritanceSpecified));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getDiscriminatorType() {
		return discriminatorType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDiscriminatorType(int newDiscriminatorType) {
		int oldDiscriminatorType = discriminatorType;
		discriminatorType = newDiscriminatorType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_TYPE, oldDiscriminatorType, discriminatorType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDiscriminatorValue() {
		return discriminatorValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDiscriminatorValue(String newDiscriminatorValue) {
		String oldDiscriminatorValue = discriminatorValue;
		discriminatorValue = newDiscriminatorValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_VALUE, oldDiscriminatorValue, discriminatorValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn getDiscriminatorColumn() {
		if (discriminatorColumn != null && discriminatorColumn.eIsProxy()) {
			OrmColumn oldDiscriminatorColumn = discriminatorColumn;
			discriminatorColumn = (OrmColumn)eResolveProxy((InternalEObject)discriminatorColumn);
			if (discriminatorColumn != oldDiscriminatorColumn) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN, oldDiscriminatorColumn, discriminatorColumn));
			}
		}
		return discriminatorColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn basicGetDiscriminatorColumn() {
		return discriminatorColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDiscriminatorColumn(OrmColumn newDiscriminatorColumn) {
		OrmColumn oldDiscriminatorColumn = discriminatorColumn;
		discriminatorColumn = newDiscriminatorColumn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN, oldDiscriminatorColumn, discriminatorColumn));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join getSuperJoin() {
		if (superJoin != null && superJoin.eIsProxy()) {
			Join oldSuperJoin = superJoin;
			superJoin = (Join)eResolveProxy((InternalEObject)superJoin);
			if (superJoin != oldSuperJoin) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ENTITY_META_DATA__SUPER_JOIN, oldSuperJoin, superJoin));
			}
		}
		return superJoin;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join basicGetSuperJoin() {
		return superJoin;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuperJoin(Join newSuperJoin) {
		Join oldSuperJoin = superJoin;
		superJoin = newSuperJoin;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ENTITY_META_DATA__SUPER_JOIN, oldSuperJoin, superJoin));
	}

	public boolean isBaseEntity() {
		return entityType == TYPE_ENTITY && (superEntity == null 
				|| superEntity.getEntityType() == TYPE_EMBEDDABLE_SUPERCLASS);
	}

	public boolean hasSubEntities() {
		return subEntityList != null && !subEntityList.isEmpty();
	}

	public boolean isEntity() {
		return entityType == TYPE_ENTITY;
	}

	public boolean isEmbeddable() {
		return entityType == TYPE_EMBEDDABLE;
	}

	public boolean isEmbeddableSuperclass() {
		return entityType == TYPE_EMBEDDABLE_SUPERCLASS;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL, msgs);
				case MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY:
					if (superEntity != null)
						msgs = ((InternalEObject)superEntity).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST, EntityMetaData.class, msgs);
					return basicSetSuperEntity((EntityMetaData)otherEnd, msgs);
				case MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST:
					return ((InternalEList)getSubEntityList()).basicAdd(otherEnd, msgs);
				case MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST:
					return ((InternalEList)getAttributeList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL:
					return eBasicSetContainer(null, MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL, msgs);
				case MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY:
					return basicSetSuperEntity(null, msgs);
				case MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST:
					return ((InternalEList)getSubEntityList()).basicRemove(otherEnd, msgs);
				case MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST:
					return ((InternalEList)getAttributeList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL:
					return eContainer.eInverseRemove(this, MetadataPackage.ENTITY_MODEL__TYPE_LIST, EntityModel.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL:
				return getEntityModel();
			case MetadataPackage.ENTITY_META_DATA__CLASS_NAME:
				return getClassName();
			case MetadataPackage.ENTITY_META_DATA__CLS:
				return getCls();
			case MetadataPackage.ENTITY_META_DATA__ENTITY_TYPE:
				return new Integer(getEntityType());
			case MetadataPackage.ENTITY_META_DATA__SCHEMA_NAME:
				return getSchemaName();
			case MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY:
				if (resolve) return getSuperEntity();
				return basicGetSuperEntity();
			case MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST:
				return getSubEntityList();
			case MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST:
				return getAttributeList();
			case MetadataPackage.ENTITY_META_DATA__PRIMARY_KEY_LIST:
				return getPrimaryKeyList();
			case MetadataPackage.ENTITY_META_DATA__VERSION_LIST:
				return getVersionList();
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_TYPE:
				return new Integer(getIdGeneratorType());
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_NAME:
				return getIdGeneratorName();
			case MetadataPackage.ENTITY_META_DATA__ID_CLASS:
				return getIdClass();
			case MetadataPackage.ENTITY_META_DATA__TABLE:
				if (resolve) return getTable();
				return basicGetTable();
			case MetadataPackage.ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST:
				return getSecondaryTableJoinList();
			case MetadataPackage.ENTITY_META_DATA__ACCESS_TYPE:
				return new Integer(getAccessType());
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE:
				return new Integer(getInheritance());
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE_SPECIFIED:
				return isInheritanceSpecified() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_TYPE:
				return new Integer(getDiscriminatorType());
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_VALUE:
				return getDiscriminatorValue();
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN:
				if (resolve) return getDiscriminatorColumn();
				return basicGetDiscriminatorColumn();
			case MetadataPackage.ENTITY_META_DATA__SUPER_JOIN:
				if (resolve) return getSuperJoin();
				return basicGetSuperJoin();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__CLASS_NAME:
				setClassName((String)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__CLS:
				setCls((Class)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__ENTITY_TYPE:
				setEntityType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ENTITY_META_DATA__SCHEMA_NAME:
				setSchemaName((String)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY:
				setSuperEntity((EntityMetaData)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST:
				getSubEntityList().clear();
				getSubEntityList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST:
				getAttributeList().clear();
				getAttributeList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__PRIMARY_KEY_LIST:
				getPrimaryKeyList().clear();
				getPrimaryKeyList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__VERSION_LIST:
				getVersionList().clear();
				getVersionList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_TYPE:
				setIdGeneratorType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_NAME:
				setIdGeneratorName((String)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__ID_CLASS:
				setIdClass((String)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__TABLE:
				setTable((OrmTable)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST:
				getSecondaryTableJoinList().clear();
				getSecondaryTableJoinList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__ACCESS_TYPE:
				setAccessType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE:
				setInheritance(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE_SPECIFIED:
				setInheritanceSpecified(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_TYPE:
				setDiscriminatorType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_VALUE:
				setDiscriminatorValue((String)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN:
				setDiscriminatorColumn((OrmColumn)newValue);
				return;
			case MetadataPackage.ENTITY_META_DATA__SUPER_JOIN:
				setSuperJoin((Join)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)null);
				return;
			case MetadataPackage.ENTITY_META_DATA__CLASS_NAME:
				setClassName(CLASS_NAME_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__CLS:
				setCls(CLS_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__ENTITY_TYPE:
				setEntityType(ENTITY_TYPE_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__SCHEMA_NAME:
				setSchemaName(SCHEMA_NAME_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY:
				setSuperEntity((EntityMetaData)null);
				return;
			case MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST:
				getSubEntityList().clear();
				return;
			case MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST:
				getAttributeList().clear();
				return;
			case MetadataPackage.ENTITY_META_DATA__PRIMARY_KEY_LIST:
				getPrimaryKeyList().clear();
				return;
			case MetadataPackage.ENTITY_META_DATA__VERSION_LIST:
				getVersionList().clear();
				return;
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_TYPE:
				setIdGeneratorType(ID_GENERATOR_TYPE_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_NAME:
				setIdGeneratorName(ID_GENERATOR_NAME_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__ID_CLASS:
				setIdClass(ID_CLASS_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__TABLE:
				setTable((OrmTable)null);
				return;
			case MetadataPackage.ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST:
				getSecondaryTableJoinList().clear();
				return;
			case MetadataPackage.ENTITY_META_DATA__ACCESS_TYPE:
				setAccessType(ACCESS_TYPE_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE:
				setInheritance(INHERITANCE_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE_SPECIFIED:
				setInheritanceSpecified(INHERITANCE_SPECIFIED_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_TYPE:
				setDiscriminatorType(DISCRIMINATOR_TYPE_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_VALUE:
				setDiscriminatorValue(DISCRIMINATOR_VALUE_EDEFAULT);
				return;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN:
				setDiscriminatorColumn((OrmColumn)null);
				return;
			case MetadataPackage.ENTITY_META_DATA__SUPER_JOIN:
				setSuperJoin((Join)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_META_DATA__ENTITY_MODEL:
				return getEntityModel() != null;
			case MetadataPackage.ENTITY_META_DATA__CLASS_NAME:
				return CLASS_NAME_EDEFAULT == null ? className != null : !CLASS_NAME_EDEFAULT.equals(className);
			case MetadataPackage.ENTITY_META_DATA__CLS:
				return CLS_EDEFAULT == null ? cls != null : !CLS_EDEFAULT.equals(cls);
			case MetadataPackage.ENTITY_META_DATA__ENTITY_TYPE:
				return entityType != ENTITY_TYPE_EDEFAULT;
			case MetadataPackage.ENTITY_META_DATA__SCHEMA_NAME:
				return SCHEMA_NAME_EDEFAULT == null ? schemaName != null : !SCHEMA_NAME_EDEFAULT.equals(schemaName);
			case MetadataPackage.ENTITY_META_DATA__SUPER_ENTITY:
				return superEntity != null;
			case MetadataPackage.ENTITY_META_DATA__SUB_ENTITY_LIST:
				return subEntityList != null && !subEntityList.isEmpty();
			case MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST:
				return attributeList != null && !attributeList.isEmpty();
			case MetadataPackage.ENTITY_META_DATA__PRIMARY_KEY_LIST:
				return primaryKeyList != null && !primaryKeyList.isEmpty();
			case MetadataPackage.ENTITY_META_DATA__VERSION_LIST:
				return versionList != null && !versionList.isEmpty();
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_TYPE:
				return idGeneratorType != ID_GENERATOR_TYPE_EDEFAULT;
			case MetadataPackage.ENTITY_META_DATA__ID_GENERATOR_NAME:
				return ID_GENERATOR_NAME_EDEFAULT == null ? idGeneratorName != null : !ID_GENERATOR_NAME_EDEFAULT.equals(idGeneratorName);
			case MetadataPackage.ENTITY_META_DATA__ID_CLASS:
				return ID_CLASS_EDEFAULT == null ? idClass != null : !ID_CLASS_EDEFAULT.equals(idClass);
			case MetadataPackage.ENTITY_META_DATA__TABLE:
				return table != null;
			case MetadataPackage.ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST:
				return secondaryTableJoinList != null && !secondaryTableJoinList.isEmpty();
			case MetadataPackage.ENTITY_META_DATA__ACCESS_TYPE:
				return accessType != ACCESS_TYPE_EDEFAULT;
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE:
				return inheritance != INHERITANCE_EDEFAULT;
			case MetadataPackage.ENTITY_META_DATA__INHERITANCE_SPECIFIED:
				return inheritanceSpecified != INHERITANCE_SPECIFIED_EDEFAULT;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_TYPE:
				return discriminatorType != DISCRIMINATOR_TYPE_EDEFAULT;
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_VALUE:
				return DISCRIMINATOR_VALUE_EDEFAULT == null ? discriminatorValue != null : !DISCRIMINATOR_VALUE_EDEFAULT.equals(discriminatorValue);
			case MetadataPackage.ENTITY_META_DATA__DISCRIMINATOR_COLUMN:
				return discriminatorColumn != null;
			case MetadataPackage.ENTITY_META_DATA__SUPER_JOIN:
				return superJoin != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (entityType: ");
		result.append(entityType);
		result.append(", schemaName: ");
		result.append(schemaName);
		result.append(", idGeneratorType: ");
		result.append(idGeneratorType);
		result.append(", idGeneratorName: ");
		result.append(idGeneratorName);
		result.append(", idClass: ");
		result.append(idClass);
		result.append(", accessType: ");
		result.append(accessType);
		result.append(", inheritance: ");
		result.append(inheritance);
		result.append(", inheritanceSpecified: ");
		result.append(inheritanceSpecified);
		result.append(", discriminatorType: ");
		result.append(discriminatorType);
		result.append(", discriminatorValue: ");
		result.append(discriminatorValue);
		result.append(')');
		return result.toString();
	}

	public AttributeMetaData findAttributeMetaData(String fieldName) {
		if (fieldName == null) {
			return null;
		}
		for (Iterator it = getAttributeList().iterator(); it.hasNext();) {
			AttributeMetaData am = (AttributeMetaData) it.next();
			if (fieldName.equals(am.getName())) {
				return am;
			}
		}
		return null;
	}

    public void getTopLevelSqlObjects(HashSet sqlObjects) {
        sqlObjects.add(getTable());
        for(Iterator joins = getSecondaryTableJoinList().iterator(); joins.hasNext();){
            Join join = (Join) joins.next();
            sqlObjects.add(join.getSrcTable());
            sqlObjects.add(join.getDestTable());
        }
        for(Iterator types = getAttributeList().iterator(); types.hasNext();){
            AttributeMetaData attribute = (AttributeMetaData) types.next();
            attribute.getTopLevelSqlObjects(sqlObjects);
        }
    }

	public String getShortName() {
		if (schemaName != null) {
			return schemaName;
		}
		return super.getShortName();
	}

} // EntityMetaDataImpl
