/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

import java.util.HashSet;

import org.eclipse.emf.common.util.EList;

/**
 * A persistent entity. This might be a class or something else.
 * 
 * @model
 * @generated
 */
public interface EntityMetaData extends TypeMetaData{

	/**
	 * Normal entity.
	 */
	public static final int TYPE_ENTITY = 1;
	
	/**
	 * Embeddable entity.
	 */
	public static final int TYPE_EMBEDDABLE = 2;
	
	/**
	 * Embeddable superclass.
	 */
	public static final int TYPE_EMBEDDABLE_SUPERCLASS = 3;
	
	/**
	 * The application is responsible for providing the pk.
	 */
	public static final int ID_GENERATOR_TYPE_NONE = 1;

	/**
	 * Use a lookup table to generate the pk.
	 */
	public static final int ID_GENERATOR_TYPE_TABLE = 2;

	/**
	 * Use database sequence to generate the pk.
	 */
	public static final int ID_GENERATOR_TYPE_SEQUENCE = 3;

	/**
	 * Use a database identity or autoincrement column for the pk.
	 */
	public static final int ID_GENERATOR_TYPE_IDENTITY = 4;

	/**
	 * Use a persistence provider chosen stragegy suitable to the target
	 * database to generate the pk.
	 */
	public static final int ID_GENERATOR_TYPE_AUTO = 5;
   
    /**
     * Default persistent attributes are fields of the entity.
     */
    public static final int ACCESS_TYPE_FIELD = 1;

    /**
     * Defualt persistent attributes are Javabean style properties (get and 
     * set methods).
     */
    public static final int ACCESS_TYPE_PROPERTY = 2;

    /**
     * No inheritance.
     */
    public static final int INHERITANCE_NONE = 0;
    
    /**
     * All classes in the heirachy stored in one table.
     */
    public static final int INHERITANCE_SINGLE_TABLE = 1;
    
    /**
     * Each class mapped to a separate table.
     */
    public static final int INHERITANCE_TABLE_PER_CLASS = 2;
    
    /**
     * Each class mapped to a table containing only its field and not those
     * from superclasses.
     */
    public static final int INHERITANCE_JOINED = 3;
    
    /**
     * Discriminator values are Strings.
     */
    public static final int DISC_TYPE_STRING = 1;
    
    /**
     * Discriminator values are ints.
     */
    public static final int DISC_TYPE_INTEGER = 2;
    
    /**
     * Discriminator values are chars.
     */
    public static final int DISC_TYPE_CHAR = 3;
    
	/**
	 * What type of entity is this?
	 * 
	 * @see #TYPE_ENTITY
	 * @see #TYPE_EMBEDDABLE
	 * @see #TYPE_EMBEDDABLE_SUPERCLASS
	 * 
	 * @model
	 * @generated
	 */
	int getEntityType();

	void setEntityType(int value);

	/**
	 * Get the schema name.
	 * 
	 * @model
	 * @generated
	 */
	String getSchemaName();

	/**
	 * @generated
	 */
	void setSchemaName(String value);

	/**
	 * Get the persistent 'superclass' of this entity or null if none.
	 * 
	 * @see #isBaseEntity()
	 * 
	 * @model
	 * @generated
	 */
	EntityMetaData getSuperEntity();

	/**
	 * @generated
	 */
	void setSuperEntity(EntityMetaData value);

	/**
	 * Return the list of persistent entites that are direct subclasses of this
	 * entity.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.EntityMetaData"
	 * @generated
	 */
	EList getSubEntityList();

	/**
	 * The persistent attributes of this entity. This list does not include
	 * attributes from super and subclasses. It is bidirectional and its
	 * opposite is '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getEntityMetaData <em>Entity Meta Data</em>}'.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.AttributeMetaData"
	 *        opposite="entityMetaData" containment="true"
	 * @generated
	 */
	EList getAttributeList();

	/**
	 * Get the list of attributes that form the primary key of this entity in
	 * order. This is a subset of {@link #getAttributeList()}.
	 * 
	 * @see AttributeMetaData#isPrimaryKey()
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.AttributeMetaData"
	 * @generated
	 */
	EList getPrimaryKeyList();

	/**
	 * Get the list of attributes that form the optimistic locking version
	 * of this entity. This is a subset of {@link #getAttributeList()}.
	 * 
	 * @see AttributeMetaData#isVersion()
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.BasicAttribute"
	 * @generated
	 */
	EList getVersionList();

	/**
	 * The type of primary key generator to use for this entity (see
	 * {@link #ID_GENERATOR_TYPE_AUTO} etc.).
	 * 
	 * @see #getIdGeneratorName()
	 * 
	 * @model
	 * @generated
	 */
	int getIdGeneratorType();

	/**
	 * @generated
	 */
	void setIdGeneratorType(int value);

	/**
	 * The name of the primary key generator (if any).
	 * 
	 * @see #getIdGeneratorType()
	 * 
	 * @model
	 * @generated
	 */
	String getIdGeneratorName();

	/**
	 * @generated
	 */
	void setIdGeneratorName(String value);

	/**
	 * Get the name of the class used for identity for this entity. This may be
	 * null if no identity class is required (e.g. for an entity not using a
	 * composite primary key).
	 * 
	 * @model
	 * @generated
	 */
	String getIdClass();

	/**
	 * @generated
	 */
	void setIdClass(String value);

	/**
	 * The primary table for this entity.
	 * 
	 * @model
	 * @generated
	 */
	OrmTable getTable();

	void setTable(OrmTable value);

	/**
	 * The joins to secondary tables for this entity. The attributes ({@link #getAttributeList()})
	 * are mapped to the primary table ({@link #getTable()} or to one of the
	 * secondary tables.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.mapping.OrmTable"
	 *        opposite="parentElement" containment="false"
	 * @generated
	 */
	EList getSecondaryTableJoinList();

    /**
     * Is default persistent attributes fields or a propertys (see {@link #ACCESS_TYPE_FIELD}
     * etc.)?
     * 
     * @return the value of the '<em>Access Type</em>' attribute.
     * @see #ACCESS_TYPE_FIELD
     * @see #ACCESS_TYPE_PROPERTY
     * @see org.eclipse.jsr220orm.metadata.MetadataPackage#getEntityMetaData_AccessType()
     * @model
     * @generated
     */
    int getAccessType();

    void setAccessType(int value);

	/**
	 * Get the inheritance strategy for this class.
	 * 
	 * @see #INHERITANCE_SINGLE_TABLE
	 * @see #INHERITANCE_TABLE_PER_CLASS
	 * @see #INHERITANCE_JOINED
	 * @see #getDiscriminatorColumn()
	 * @see #getDiscriminatorValue()
	 * 
	 * @model
	 * @generated
	 */
	int getInheritance();

	void setInheritance(int value);

	/**
	 * Was the {@link #getInheritance()} value in the model specified in the
	 * mapping meta data or defaulted when the model was built?
	 * 
	 * @model
	 * @generated
	 */
	boolean isInheritanceSpecified();

	void setInheritanceSpecified(boolean value);

	/**
	 * Get the type of discriminator value for this heirachy (
	 * {@link #DISC_TYPE_STRING} etc.).
	 * 
	 * @model
	 * @generated
	 */
	int getDiscriminatorType();

	void setDiscriminatorType(int value);

	/**
	 * Get the discriminator column value for this class.
	 * 
	 * @see #getDiscriminatorColumn()
	 * @see #getInheritance()
	 * 
	 * @model
	 * @generated
	 */
	String getDiscriminatorValue();

	void setDiscriminatorValue(String value);

	/**
	 * Get the discriminator column.
	 * 
	 * @see #getDiscriminatorValue()()
	 * @see #getInheritance()
	 * 
	 * @model
	 * @generated
	 */
	OrmColumn getDiscriminatorColumn();

	void setDiscriminatorColumn(OrmColumn value);

	/**
	 * For subclasses of a class using {@link #INHERITANCE_JOINED} this is
	 * the join to the superclass table.
	 * 
	 * @model
	 * @generated
	 */
	Join getSuperJoin();

	void setSuperJoin(Join value);

	/**
	 * Is this a base entity? An entity is considered a base entity if it has
	 * no {@link #getSuperEntity()} or its super entity is an embeddable 
	 * superclass (see {@link #getEntityType()} and 
	 * {@link #TYPE_EMBEDDABLE_SUPERCLASS}).
	 * 
	 * @model kind="operation"
	 * @generated
	 */
	boolean isBaseEntity();

	/**
	 * Does this entity have at least one entry in 
	 * {@link #getSubEntityList()}?
	 * 
	 * @model
	 * @generated
	 */
	boolean hasSubEntities();

	/**
	 * Is our {@link #getEntityType()} == {@link #TYPE_ENTITY}?
	 * 
	 * @model kind="operation"
	 */
	boolean isEntity();

	/**
	 * Is our {@link #getEntityType()} == {@link #TYPE_EMBEDDABLE}?
	 * 
	 * @model kind="operation"
	 */
	boolean isEmbeddable();

	/**
	 * Is our {@link #getEntityType()} == {@link #TYPE_EMBEDDABLE_SUPERCLASS}?
	 * 
	 * @model kind="operation"
	 */
	boolean isEmbeddableSuperclass();

	AttributeMetaData findAttributeMetaData(String fieldName);

    void getTopLevelSqlObjects(HashSet sqlObjects);

} // EntityMetaData
