/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.AttributeIO;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.SimpleTypeMetaData;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

public class OverrideAttributeIO
extends AttributeIO {
    protected AttributeMetaData amd;
    protected EmbeddedAttribute embeddedAttribute;
    protected String defColName;

    public OverrideAttributeIO(EntityIO entityIO, EmbeddedAttribute embeddedAttribute) {
        super(entityIO);
        this.embeddedAttribute = embeddedAttribute;
    }

    public boolean updateModelFromMetaData(RClass cls, RAnnotatedElement attribute, boolean metaDataChanged) {
        throw new IllegalStateException("updateModelFromMetaData invoked on " + this);
    }

    protected void updateMetaDataFromModel(RClass cls, RAnnotatedElement attribute) {
        throw new IllegalStateException("updateMetaDataFromModel invoked on " + this);
    }

    public AttributeMetaData getAttributeMetaData() {
        return this.amd;
    }

    public void getPossibleMappings(List ans) {
    }

    public IntOption getMapping() {
        return null;
    }

    public void setMapping(IntOption mapping) {
    }

    public boolean updateModelFromMetaData(RClass cls, AttributeMetaData overrideOf, AttributeOverride override, boolean metaDataChanged, int relativePositionOffset) {
        boolean isNewAttribute;
        if (!(overrideOf instanceof BasicAttribute)) {
            throw new IllegalArgumentException("Unsupported: " + overrideOf);
        }
        EntityMetaData emd = this.entityIO.getEntityMetaData();
        boolean bl = isNewAttribute = this.amd == null;
        if (isNewAttribute) {
            GenericEntityModelManager mm = this.entityIO.getModelManager();
            this.amd = (AttributeMetaData)mm.getFactory().create(overrideOf.eClass());
            this.amd.registerAdapterFactory((IAdapterFactory)this);
            this.amd.eAdapters().add((Object)this.entityIO);
        }
        this.amd.setOverrideOf(overrideOf);
        this.amd.setName(overrideOf.getName());
        this.amd.setGetterMethodName(overrideOf.getGetterMethodName());
        this.amd.setSetterMethodName(overrideOf.getSetterMethodName());
        this.amd.setJavaType(overrideOf.getJavaType());
        this.amd.setOptional(overrideOf.isOptional());
        this.amd.setFetchType(overrideOf.getFetchType());
        if (this.embeddedAttribute == null) {
            if (this.amd.isNonPersistent()) {
                emd.getAttributeList().add((Object)this.amd);
            }
            if (overrideOf.isPrimaryKey()) {
                if (!this.amd.isPrimaryKey()) {
                    emd.getPrimaryKeyList().add((Object)this.amd);
                }
            } else if (this.amd.isPrimaryKey()) {
                emd.getPrimaryKeyList().remove((Object)this.amd);
            }
            if (overrideOf.isVersion()) {
                if (!this.amd.isVersion()) {
                    emd.getVersionList().add((Object)this.amd);
                }
            } else if (this.amd.isVersion()) {
                emd.getVersionList().remove((Object)this.amd);
            }
        } else if (this.amd.getEmbeddedIn() == null) {
            this.amd.setEmbeddedIn(this.embeddedAttribute);
        }
        if (!(this.amd instanceof BasicAttribute)) {
            throw new IllegalStateException("Not implemented: " + overrideOf);
        }
        this.updateModelFromMetaDataBasic(cls, (BasicAttribute)overrideOf, override, metaDataChanged, relativePositionOffset);
        return true;
    }

    protected OrmColumn getDefaultColumn() {
        TypeMetaData tmd = this.amd.getJavaType();
        if (tmd instanceof SimpleTypeMetaData) {
            return ((SimpleTypeMetaData)tmd).getColumn();
        }
        return null;
    }

    protected void updateModelFromMetaDataBasic(RClass cls, BasicAttribute overrideOf, AttributeOverride override, boolean metaDataChanged, int relativePositionOffset) {
        int pos;
        String comment;
        String cd;
        GenericEntityModelManager mm = this.entityIO.getModelManager();
        BasicAttribute amd = (BasicAttribute)this.amd;
        OrmColumn dc = this.getDefaultColumn();
        OrmColumn c = amd.getColumn();
        OrmColumn oc = overrideOf.getColumn();
        if (dc == null) {
            if (c != null) {
                c.delete();
                amd.setColumn(null);
            }
            return;
        }
        c = this.entityIO.ensureOrmColumn(c);
        if (override != null) {
            this.defColName = mm.getDefaultColumnName(amd);
            Column column = override.column();
            this.fillDefaults((AnnotationEx)column, dc);
            c.setJdbcType(column.jdbcType());
            c.setInsertable(column.insertable());
            if (mm.getVendorDef().isNumericType(c.getJdbcType())) {
                c.setLength(column.precision());
            } else {
                c.setLength(column.length());
            }
            c.setScale(column.scale());
            ((AnnotationEx)column).setDefault("name", this.defColName);
            c.setName(column.name());
            c.setNullable(column.nullable());
            c.setUpdatable(column.updatable());
            cd = column.columnDefinition();
            if (cd.length() == 0) {
                c.setColumnDefinitionSpecified(false);
                cd = mm.getColumnDefinition(c);
            } else {
                c.setColumnDefinitionSpecified(true);
            }
        } else {
            if (oc != null) {
                oc.copyTo(c);
            } else {
                dc.copyTo(c);
                c.setName(mm.getDefaultColumnName(amd));
            }
            this.defColName = c.getName();
            c.setColumnDefinitionSpecified(false);
            cd = mm.getColumnDefinition(c);
        }
        c.setColumnDefinition(cd);
        c.setOriginalColumnDefinition(cd);
        mm.updateDatabaseType(c);
        if (this.embeddedAttribute == null) {
            comment = String.valueOf(overrideOf.getEntityMetaData().getSchemaName()) + "." + overrideOf.getName();
            pos = oc == null ? 0 : oc.getRelativePositionInTable();
        } else {
            comment = String.valueOf(this.embeddedAttribute.getEntityMetaData().getSchemaName()) + "." + this.embeddedAttribute.getName() + "." + overrideOf.getName();
            pos = relativePositionOffset;
        }
        c.setComment(comment);
        c.setRelativePositionInTable(pos);
        if (amd.getColumn() != c) {
            amd.setColumn(c);
        }
        OrmTable table = this.entityIO.getEntityMetaData().getTable();
        c.setTable(table);
        if (amd.isPrimaryKey()) {
            if (!c.isPrimaryKey()) {
                table.getPrimaryKeyList().add((Object)c);
            }
        } else if (c.isPrimaryKey()) {
            table.getPrimaryKeyList().remove((Object)c);
        }
    }

    protected void fillDefaults(AnnotationEx column, OrmColumn dc) {
        column.setDefault("name", dc.getName());
        column.setDefault("nullable", dc.isNullable());
        column.setDefault("insertable", dc.isInsertable());
        column.setDefault("updatable", dc.isUpdatable());
        column.setDefault("length", dc.getLength());
        column.setDefault("precision", dc.getLength());
        column.setDefault("scale", dc.getScale());
        column.setDefault("jdbcType", dc.getJdbcType());
    }

    public boolean updateMetaDataFromModel(AttributeOverride override) {
        AttributeMetaData overrideOf = this.amd.getOverrideOf();
        if (overrideOf == null) {
            return false;
        }
        if (!(this.amd instanceof BasicAttribute)) {
            throw new IllegalStateException("Not implemented: " + this.amd);
        }
        this.updateMetaDataFromModelBasic(override);
        return true;
    }

    protected void updateMetaDataFromModelBasic(AttributeOverride override) {
        if (override == null) {
            return;
        }
        GenericEntityModelManager mm = this.entityIO.getModelManager();
        BasicAttribute amd = (BasicAttribute)this.amd;
        BasicAttribute overrideOf = (BasicAttribute)amd.getOverrideOf();
        OrmColumn dc = ((AnnotationEx)override).getValueCount() == 0 ? overrideOf.getColumn() : this.getDefaultColumn();
        OrmColumn c = amd.getColumn();
        if (dc == null || c == null) {
            return;
        }
        AnnotationEx column = (AnnotationEx)override.column();
        this.fillDefaults(column, dc);
        column.set("jdbcType", c.getJdbcType());
        column.set("insertable", c.isInsertable());
        if (mm.getVendorDef().isNumericType(c.getJdbcType())) {
            column.set("precision", c.getLength());
            column.set("length", null);
        } else {
            column.set("length", c.getLength());
            column.set("precision", null);
        }
        column.setDefault("name", this.defColName);
        column.set("name", c.getName(), true);
        c.setName(((Column)column).name());
        column.set("nullable", c.isNullable());
        column.set("scale", c.getScale());
        column.set("updatable", c.isUpdatable());
        boolean colDefChanged = !c.getColumnDefinition().equals(c.getOriginalColumnDefinition());
        String stdColDef = mm.getColumnDefinition(c);
        if (colDefChanged) {
            column.setDefault("columnDefinition", stdColDef);
            column.set("columnDefinition", c.getColumnDefinition(), true);
        }
        if (!column.hasValue("columnDefinition")) {
            c.setColumnDefinition(stdColDef);
        }
        c.setOriginalColumnDefinition(c.getColumnDefinition());
    }
}

