/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.Entity;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.core.options.IIntOption;
import org.eclipse.jsr220orm.generic.GenericEntityModelManager;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.AnnotationEx;
import org.eclipse.jsr220orm.generic.io.AnnotationRegistry;
import org.eclipse.jsr220orm.generic.io.AttributeIO;
import org.eclipse.jsr220orm.generic.io.AttributeOverrideMap;
import org.eclipse.jsr220orm.generic.io.BasicAttributeIO;
import org.eclipse.jsr220orm.generic.io.CollectionAttributeIO;
import org.eclipse.jsr220orm.generic.io.EmbeddedAttributeIO;
import org.eclipse.jsr220orm.generic.io.JoinIO;
import org.eclipse.jsr220orm.generic.io.OverrideAttributeIO;
import org.eclipse.jsr220orm.generic.io.ReferenceAttributeIO;
import org.eclipse.jsr220orm.generic.io.ast.AstState;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionTypeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.TypeMetaData;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityIO
implements IElementChangedListener,
Adapter,
Comparable,
IAdapterFactory {
    protected final GenericEntityModelManager mm;
    protected final EntityMetaData emd;
    protected final IType type;
    protected final JoinIO joinIO;
    protected Map<String, AttributeMetaData> npAttributeMap = new HashMap<String, AttributeMetaData>();
    protected AstState astState;
    protected List<AttributeInfo> todo;
    protected Map<String, String> renamedAttributeMap;
    protected int oldAccessType;
    protected BasicAttribute idGeneratorAttribute;
    protected List<IMarker> markers = new ArrayList<IMarker>();
    protected Set<EntityIO> weDependOn = new HashSet<EntityIO>();
    protected Set<EntityIO> dependOnUs = new HashSet<EntityIO>();
    public static final int STATUS_NOT_STARTED = 0;
    public static final int STATUS_SUPER_ENTITY_DONE = 1;
    public static final int STATUS_STARTED_ATTRIBUTES = 2;
    public static final int STATUS_COMPLETE = 10;
    protected int modelUpdateStatus;
    protected boolean updateAddDiscriminatorColumn;
    protected String defaultDiscriminatorValue;
    public static final IntOption MAPPING_NOT_PERSISTENT = new IntOption(0, "Not persistent", "Class is not stored in the database", Utils.getImage("NotPersistent16"));
    public static final IntOption MAPPING_ENTITY = new IntOption(1, "Entity", "Class is stored in the database with its own identity", Utils.getImage("TreeClass16"));
    public static final IntOption MAPPING_EMBEDDABLE = new IntOption(2, "Embeddable", "Class attributes are stored in the table for another class", Utils.getImage("Embedded16"));
    public static final IntOption MAPPING_EMBEDDABLE_SUPERCLASS = new IntOption(3, "Embeddable superclass", "Class attributes are stored in the tables for its subclasses", Utils.getImage("EmbeddableSuperclass16"));
    protected static final String[] DEFAULT_PACKAGES = new String[]{"java.lang.", "java.math.", "java.util.", "java.sql."};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;

    public EntityIO(GenericEntityModelManager mm, EntityMetaData emd, IType type) {
        this.emd = emd;
        this.mm = mm;
        this.type = type;
        this.joinIO = this.createJoinIO();
        emd.registerAdapterFactory((IAdapterFactory)this);
        emd.eAdapters().add((Object)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)4);
    }

    protected JoinIO createJoinIO() {
        return new JoinIO(this);
    }

    public static EntityIO get(EntityMetaData emd) {
        if (emd == null) {
            return null;
        }
        return (EntityIO)emd.adapt(EntityIO.class);
    }

    public void dispose() {
        this.deleteMarkers();
        this.clearWeDependOn();
        this.weDependOn = null;
        Iterator<EntityIO> i = this.dependOnUs.iterator();
        while (i.hasNext()) {
            Set<EntityIO> set = i.next().weDependOn;
            if (set == null) continue;
            set.remove(this);
        }
        this.dependOnUs = null;
        i = this.npAttributeMap.values().iterator();
        while (i.hasNext()) {
            ((AttributeMetaData)i.next()).delete();
        }
        this.npAttributeMap = null;
        this.emd.eAdapters().remove((Object)this);
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected void clearWeDependOn() {
        Iterator<EntityIO> i = this.weDependOn.iterator();
        while (i.hasNext()) {
            Set<EntityIO> set = i.next().dependOnUs;
            if (set == null) continue;
            set.remove(this);
        }
    }

    protected void deleteMarkers() {
        for (IMarker m : this.markers) {
            try {
                m.delete();
            }
            catch (CoreException e) {
                OrmPlugin.log((Throwable)e);
            }
        }
    }

    public void updateModelFromMetaDataPre() throws Exception {
        this.todo = null;
        this.idGeneratorAttribute = null;
        this.modelUpdateStatus = 0;
        this.renamedAttributeMap = null;
        this.deleteMarkers();
        this.astState = this.mm.getAstRClassFactory().getAstState();
        this.clearWeDependOn();
    }

    public void renameAttributes(ElementChangedEvent event) {
        AttributeMetaData amd;
        boolean field;
        this.renamedAttributeMap = null;
        IJavaElementDelta delta = this.findOurTypeDelta(event);
        if (delta == null) {
            return;
        }
        IJavaElementDelta[] added = delta.getAddedChildren();
        IJavaElementDelta[] removed = delta.getRemovedChildren();
        if (added.length != 1 || removed.length != 1) {
            return;
        }
        IJavaElement a = added[0].getElement();
        IJavaElement r = removed[0].getElement();
        int elementType = a.getElementType();
        if (elementType != r.getElementType()) {
            return;
        }
        switch (elementType) {
            case 8: {
                field = true;
                break;
            }
            case 9: {
                field = false;
                break;
            }
            default: {
                return;
            }
        }
        String oldName = r.getElementName();
        String newName = a.getElementName();
        if (!field) {
            if (!this.mm.isValidPropertyName(oldName) || !this.mm.isValidPropertyName(newName)) {
                return;
            }
            oldName = Utils.getAttributeNameForMethod(oldName);
            newName = Utils.getAttributeNameForMethod(newName);
        }
        if ((amd = this.emd.findAttributeMetaData(oldName)) != null && amd.isField() == field) {
            System.out.println("$ " + oldName + " -> " + newName + ": " + amd);
            this.renamedAttributeMap = new HashMap<String, String>();
            this.renamedAttributeMap.put(oldName, newName);
            amd.setName(newName);
        }
    }

    protected IJavaElementDelta findOurTypeDelta(ElementChangedEvent event) {
        if (event == null) {
            return null;
        }
        IJavaElementDelta delta = (IJavaElementDelta)event.getSource();
        if (!delta.getElement().getAncestor(5).equals(this.type.getParent())) {
            return null;
        }
        String ourName = this.type.getElementName();
        IJavaElementDelta[] changed = delta.getChangedChildren();
        if (changed.length == 0) {
            return null;
        }
        int i = 0;
        while (i < changed.length) {
            IJavaElement e = changed[i].getElement();
            if (e.getElementType() == 7 && e.getElementName().equals(ourName)) {
                return changed[i];
            }
            ++i;
        }
        return null;
    }

    protected void print(IJavaElementDelta delta, Map<String, String> ans, String indent) {
        String tp;
        String kind = "U";
        switch (delta.getKind()) {
            case 1: {
                kind = "A";
                break;
            }
            case 4: {
                kind = "C";
                break;
            }
            case 2: {
                kind = "R";
            }
        }
        switch (delta.getElement().getElementType()) {
            case 8: {
                tp = "FIELD";
                break;
            }
            case 9: {
                tp = "METHOD";
                break;
            }
            case 7: {
                tp = "TYPE";
                break;
            }
            default: {
                tp = "type " + delta.getElement().getElementType();
            }
        }
        System.out.println("> " + indent + kind + " " + tp + " " + delta.getElement().getElementName() + " " + (delta.getElement() == this.type));
        indent = String.valueOf(indent) + "  ";
        IJavaElementDelta[] affected = delta.getAffectedChildren();
        int i = 0;
        while (i < affected.length) {
            this.print(affected[i], ans, indent);
            ++i;
        }
    }

    public boolean updateModelFromMetaData(RClass cls, boolean metaDataChanged) throws Exception {
        if (this.modelUpdateStatus == 0) {
            this.updateModelSuperEntity(cls);
            this.modelUpdateStatus = 1;
            return true;
        }
        if (this.todo == null) {
            EntityIO entityIO;
            EntityMetaData superEntity = this.emd.getSuperEntity();
            if (superEntity != null && ((entityIO = EntityIO.get(superEntity)) == null || entityIO.getModelUpdateStatus() < 2)) {
                return false;
            }
            this.todo = new ArrayList<AttributeInfo>();
            this.defaultDiscriminatorValue = this.mm.getDefaultDiscriminatorValue(this.emd);
            switch (this.emd.getEntityType()) {
                case 1: {
                    if (this.emd.isBaseEntity()) {
                        this.updateModelInheritanceBase(cls, metaDataChanged);
                        break;
                    }
                    this.updateModelInheritanceNonBase(cls, metaDataChanged);
                    break;
                }
                case 2: 
                case 3: {
                    this.updateModelInheritanceEmbeddable(cls, metaDataChanged);
                }
            }
            IdClass idc = cls.getAnnotation(IdClass.class, true);
            this.emd.setIdClass(((AnnotationEx)idc).getClassValue("value"));
            this.fillTodoWithAttributeInfos(cls);
        }
        ArrayList<AttributeInfo> newTodo = null;
        for (AttributeInfo info : this.todo) {
            try {
                if (info.updateModelFromMetaData(cls, metaDataChanged)) continue;
                if (newTodo == null) {
                    newTodo = new ArrayList<AttributeInfo>();
                }
                newTodo.add(info);
            }
            catch (Exception e) {
                OrmPlugin.log((String)(String.valueOf(this.emd.getClassName()) + "." + info), (Throwable)e);
            }
        }
        this.modelUpdateStatus = 2;
        if (newTodo == null) {
            OrmTable table;
            if (this.idGeneratorAttribute == null) {
                this.emd.setIdGeneratorName(null);
                this.emd.setIdGeneratorType(1);
            }
            if ((table = this.emd.getTable()) != null) {
                table.sortColumns();
            }
            this.modelUpdateStatus = 10;
            this.todo = null;
            return true;
        }
        boolean ans = newTodo.size() < this.todo.size();
        this.todo = newTodo;
        return ans;
    }

    protected void updateModelSuperEntity(RClass cls) {
        EntityMetaData superEntity;
        String scName = cls.getSuperclassName();
        EntityMetaData entityMetaData = superEntity = scName == null ? null : this.mm.getEntityMetaData(scName);
        if (this.emd.getSuperEntity() != superEntity) {
            this.emd.setSuperEntity(superEntity);
        }
        if (superEntity != null) {
            this.addDependencyOn(superEntity);
        }
        Entity entity = cls.getAnnotation(Entity.class);
        Embeddable emb = cls.getAnnotation(Embeddable.class);
        EmbeddableSuperclass embSup = cls.getAnnotation(EmbeddableSuperclass.class);
        if (entity == null && emb == null && embSup == null) {
            AnnotationRegistry reg = this.mm.getAnnotationRegistry();
            switch (this.emd.getEntityType()) {
                case 2: {
                    emb = reg.getDefaultProxyEx(Embeddable.class);
                    break;
                }
                case 3: {
                    embSup = reg.getDefaultProxyEx(EmbeddableSuperclass.class);
                    break;
                }
                default: {
                    entity = reg.getDefaultProxyEx(Entity.class);
                }
            }
            this.registerForMetaDataUpdate();
        }
        AccessType access = null;
        if (entity != null) {
            String name;
            this.emd.setEntityType(1);
            if (emb != null) {
                this.addProblem("Cannot have Embeddable and Entity", (Annotation)emb);
            }
            if (embSup != null) {
                this.addProblem("Cannot have EmbeddableSuperclass and Entity", (Annotation)embSup);
            }
            if ((name = entity.name()).length() == 0) {
                name = cls.getSimpleName();
            }
            this.emd.setSchemaName(name);
            access = entity.access();
        } else if (emb != null) {
            this.emd.setEntityType(2);
            if (embSup != null) {
                this.addProblem("Cannot have EmbeddableSuperclass and Embeddable", (Annotation)embSup);
            }
            access = emb.access();
        } else {
            this.emd.setEntityType(3);
            access = embSup.access();
        }
        if (access != null && access == AccessType.FIELD) {
            this.emd.setAccessType(1);
        } else {
            this.emd.setAccessType(2);
        }
        this.oldAccessType = this.emd.getAccessType();
    }

    protected void updateModelInheritanceBase(RClass cls, boolean metaDataChanged) {
        this.ensureModelNoSuperJoin(cls);
        AnnotationRegistry reg = this.mm.getAnnotationRegistry();
        this.emd.getSuperEntity();
        Inheritance inheritance = cls.getAnnotation(Inheritance.class);
        DiscriminatorColumn discColumn = cls.getAnnotation(DiscriminatorColumn.class, this.updateAddDiscriminatorColumn);
        if (this.updateAddDiscriminatorColumn) {
            this.registerForMetaDataUpdate();
        }
        if (inheritance == null && (discColumn != null || this.emd.hasSubEntities())) {
            inheritance = reg.getDefaultProxy(Inheritance.class);
        }
        this.emd.setInheritanceSpecified(inheritance != null);
        if (inheritance == null) {
            this.emd.setInheritance(0);
            this.emd.setDiscriminatorType(1);
            this.emd.setDiscriminatorValue(null);
        } else {
            this.emd.setInheritance(this.getInheritanceTypeCode(inheritance.strategy()));
            this.emd.setDiscriminatorType(this.getDiscriminatorTypeCode(inheritance.discriminatorType()));
            String dv = inheritance.discriminatorValue();
            if (dv.length() == 0) {
                dv = this.defaultDiscriminatorValue;
            }
            this.emd.setDiscriminatorValue(dv);
        }
        this.updateModelEnsureOwnTable(cls);
        switch (this.emd.getInheritance()) {
            case 0: {
                this.updateModelDiscriminatorColumn(null);
                if (discColumn == null) break;
                this.addProblem("DiscriminatorColumn only allowed when inheritance is used", (Annotation)discColumn);
                break;
            }
            case 1: {
                if (discColumn == null) {
                    discColumn = this.mm.getAnnotationRegistry().getDefaultProxy(DiscriminatorColumn.class);
                }
                this.updateModelDiscriminatorColumn(discColumn);
                break;
            }
            case 3: {
                this.updateModelDiscriminatorColumn(discColumn);
                break;
            }
            case 2: {
                this.updateModelDiscriminatorColumn(null);
                if (discColumn == null) break;
                this.addProblem("DiscriminatorColumn is not allowed for TABLE_PER_CLASS inheritance", (Annotation)discColumn);
            }
        }
    }

    protected int getDiscriminatorTypeCode(DiscriminatorType t) {
        switch (t) {
            default: {
                return 1;
            }
            case CHAR: {
                return 3;
            }
            case INTEGER: 
        }
        return 2;
    }

    protected DiscriminatorType getDiscriminatorType(int code) {
        switch (code) {
            default: {
                return DiscriminatorType.STRING;
            }
            case 3: {
                return DiscriminatorType.CHAR;
            }
            case 2: 
        }
        return DiscriminatorType.INTEGER;
    }

    protected void ensureModelNoSuperJoin(RClass cls) {
        PrimaryKeyJoinColumn pkjc;
        if (Utils.deleteJoinAndSrcCols(this.emd.getSuperJoin())) {
            this.emd.setSuperJoin(null);
        }
        if ((pkjc = cls.getAnnotation(PrimaryKeyJoinColumn.class)) != null) {
            this.addProblem("PrimaryKeyJoinColumn only valid for a JOINED subclass", (Annotation)pkjc);
        }
        PrimaryKeyJoinColumns pkjcs = cls.getAnnotation(PrimaryKeyJoinColumns.class);
        if (pkjc != null) {
            this.addProblem("PrimaryKeyJoinColumns only valid for a JOINED subclass", (Annotation)pkjcs);
        }
    }

    protected void updateModelInheritanceEmbeddable(RClass cls, boolean metaDataChanged) {
        DiscriminatorColumn discColumn;
        boolean embeddableSuperclass = this.emd.isEmbeddableSuperclass();
        String msg = embeddableSuperclass ? "EmbeddableSuperclass" : "Embeddable";
        EntityMetaData superEntity = this.emd.getSuperEntity();
        if (superEntity != null) {
            if (embeddableSuperclass) {
                if (!superEntity.isEmbeddableSuperclass()) {
                    this.addProblem("Persistent superclass of an EmbeddableSuperclass must also be an EmbeddableSuperclass", cls.getLocation());
                }
            } else {
                this.addProblem(String.valueOf(msg) + " class may not have a persistent superclass", cls.getLocation());
            }
        }
        this.ensureModelNoSuperJoin(cls);
        Inheritance inheritance = cls.getAnnotation(Inheritance.class);
        if (inheritance != null) {
            this.addProblem("Inheritance not allowed for an " + msg + " class", (Annotation)inheritance);
        }
        if ((discColumn = cls.getAnnotation(DiscriminatorColumn.class)) != null) {
            this.addProblem("DiscriminatorColumn not allowed for an " + msg + " class", (Annotation)discColumn);
        }
        this.updateModelEnsureOwnTable(cls).setVirtual(true);
        this.updateModelDiscriminatorColumn(null);
        this.emd.setInheritance(0);
        this.emd.setDiscriminatorValue(null);
    }

    protected void registerForMetaDataUpdate() {
        this.mm.registerForMetaDataUpdate(this);
    }

    protected OrmTable updateModelEnsureOwnTable(RClass cls) {
        Table table = this.getTableAnnotation(cls);
        OrmTable ormTable = this.emd.getTable();
        if (ormTable == null || ormTable.getParentElement() != this.emd) {
            ormTable = this.mm.getFactory().createOrmTable();
            this.emd.setTable(ormTable);
            ormTable.setParentElement((MetadataElement)this.emd);
            ormTable.eAdapters().add((Object)this);
        }
        ormTable.setName(table.name());
        ormTable.setCatalog(table.catalog());
        ormTable.setSchema(table.schema());
        ormTable.setComment(this.emd.getSchemaName());
        return ormTable;
    }

    protected void updateModelDiscriminatorColumn(DiscriminatorColumn discColumn) {
        OrmColumn dc = this.emd.getDiscriminatorColumn();
        if (discColumn == null) {
            if (dc != null) {
                dc.delete();
                this.emd.setDiscriminatorColumn(null);
            }
        } else {
            if (dc == null) {
                dc = this.mm.getFactory().createOrmColumn();
                dc.eAdapters().add((Object)this);
                this.emd.setDiscriminatorColumn(dc);
            }
            dc.setRelativePositionInTable(this.mm.getColumnPositionDiscriminator());
            String name = discColumn.name();
            if (name.length() == 0) {
                name = "TYPE";
            }
            dc.setName(name);
            switch (this.emd.getDiscriminatorType()) {
                default: {
                    dc.setJdbcType(4);
                    break;
                }
                case 3: {
                    dc.setJdbcType(1);
                    break;
                }
                case 1: {
                    dc.setJdbcType(12);
                    dc.setLength(discColumn.length());
                }
            }
            dc.setInsertable(true);
            dc.setUpdatable(true);
            dc.setNullable(false);
            dc.setTable(this.emd.getTable());
            String cd = discColumn.columnDefinition();
            if (cd.length() == 0) {
                dc.setColumnDefinitionSpecified(false);
                cd = this.mm.getColumnDefinition(dc);
            } else {
                dc.setColumnDefinitionSpecified(true);
            }
            dc.setColumnDefinition(cd);
            dc.setOriginalColumnDefinition(cd);
            this.mm.updateDatabaseType(dc);
            dc.setComment("Discriminator for " + this.emd.getSchemaName());
        }
    }

    protected void updateModelInheritanceNonBase(RClass cls, boolean metaDataChanged) {
        Join sj;
        DiscriminatorColumn discColumn = cls.getAnnotation(DiscriminatorColumn.class);
        if (discColumn != null) {
            this.addProblem("DiscriminatorColumn not valid for a non-base class", (Annotation)discColumn);
        }
        this.updateModelDiscriminatorColumn(null);
        Inheritance inheritance = cls.getAnnotation(Inheritance.class);
        if (inheritance == null) {
            this.emd.setDiscriminatorValue(this.defaultDiscriminatorValue);
        } else {
            String dv = inheritance.discriminatorValue();
            if (dv.length() == 0) {
                dv = this.defaultDiscriminatorValue;
            }
            this.emd.setDiscriminatorValue(dv);
            AnnotationEx inheritanceEx = (AnnotationEx)inheritance;
            if (inheritanceEx.hasValue("strategy")) {
                this.addProblem("Inheritance.strategy may only be set for the base class of a heirachy", inheritanceEx.getLocation("strategy"));
            }
            if (inheritanceEx.hasValue("discriminatorType")) {
                this.addProblem("Inheritance.discriminatorType may only be set for the base class of a heirachy", inheritanceEx.getLocation("discriminatorType"));
            }
        }
        EntityMetaData superEntity = this.emd.getSuperEntity();
        this.emd.setInheritance(superEntity.getInheritance());
        if (superEntity.getInheritance() != 3 && (sj = this.emd.getSuperJoin()) != null) {
            sj.delete();
            this.emd.setSuperJoin(null);
        }
        switch (superEntity.getInheritance()) {
            default: {
                Table tableAnn;
                OrmTable table = superEntity.getTable();
                if (this.emd.getTable() != table) {
                    this.emd.setTable(table);
                }
                if ((tableAnn = cls.getAnnotation(Table.class)) == null) break;
                this.addProblem("Table not allowed for SINGLE_TABLE inheritance subclass", (Annotation)tableAnn);
                break;
            }
            case 3: {
                this.updateModelInheritanceJoinedSubclass(cls, metaDataChanged);
                break;
            }
            case 2: {
                this.updateModelEnsureOwnTable(cls);
            }
        }
    }

    protected void updateModelInheritanceJoinedSubclass(RClass cls, boolean metaDataChanged) {
        AnnotationEx ann;
        this.updateModelEnsureOwnTable(cls);
        AnnotationEx jcs = (AnnotationEx)cls.getAnnotation(PrimaryKeyJoinColumns.class);
        Join join = this.joinIO.updateModelJoin(this.emd.getSuperJoin(), (AnnotationEx)cls.getAnnotation(PrimaryKeyJoinColumn.class), jcs == null ? null : (Object[])jcs.get("value"), jcs == null ? null : jcs.getLocation(null), metaDataChanged, this.emd.getTable(), this.emd.getSuperEntity().getTable(), this.mm.getJoinedInheritanceCNS(this.emd), "Superclass " + this.emd.getSuperEntity().getSchemaName(), false, this.mm.getColumnPositionPrimaryKey());
        if (this.emd.getSuperJoin() != join) {
            this.emd.setSuperJoin(join);
        }
        if (join != null) {
            for (JoinPair p : join.getPairList()) {
                OrmColumn src = p.getSrc();
                if (src.isPrimaryKey()) continue;
                src.getTable().getPrimaryKeyList().add((Object)src);
            }
        }
        if ((ann = (AnnotationEx)cls.getAnnotation(JoinColumns.class)) != null) {
            this.addProblem("JoinColumns not allowed here" + (!cls.isAnnotationPresent(PrimaryKeyJoinColumns.class) ? " (have you tried PrimaryKeyJoinColumns?)" : ""), ann);
        }
        if ((ann = (AnnotationEx)cls.getAnnotation(JoinColumn.class)) != null) {
            this.addProblem("JoinColumn not allowed here" + (!cls.isAnnotationPresent(PrimaryKeyJoinColumn.class) ? " (have you tried PrimaryKeyJoinColumn?)" : ""), ann);
        }
    }

    protected void fillTodoWithAttributeInfos(RClass cls) {
        HashSet<AttributeMetaData> found = new HashSet<AttributeMetaData>();
        this.fillTodoWithInheritedAttributes(cls, found);
        this.fillTodoWithAttributeInfos(cls.getDeclaredFields(), true, found);
        this.fillTodoWithAttributeInfos(cls.getDeclaredMethods(), false, found);
        ArrayList<AttributeMetaData> toDelete = null;
        for (Object o : this.emd.getAttributeList()) {
            if (found.contains(o)) continue;
            if (toDelete == null) {
                toDelete = new ArrayList<AttributeMetaData>();
            }
            toDelete.add((AttributeMetaData)o);
        }
        if (toDelete != null) {
            for (AttributeMetaData amd : toDelete) {
                AttributeIO aio = AttributeIO.get(amd);
                if (aio != null) {
                    aio.dispose();
                }
                if (amd.isNonPersistent()) {
                    this.removeNonPersistentAttribute(amd);
                }
                amd.delete();
            }
        }
    }

    protected void fillTodoWithInheritedAttributes(RClass cls, Set<AttributeMetaData> found) {
        EntityMetaData superEntity = this.emd.getSuperEntity();
        if (superEntity == null || !superEntity.isEmbeddableSuperclass()) {
            return;
        }
        AttributeOverrideMap map = new AttributeOverrideMap(cls, this);
        for (AttributeMetaData overrideOf : superEntity.getAttributeList()) {
            String name;
            AttributeOverride attrOverride;
            if (!(overrideOf instanceof BasicAttribute)) continue;
            AttributeMetaData amd = this.emd.findAttributeMetaData(overrideOf.getName());
            OverrideAttributeIO aio = null;
            if (amd != null) {
                found.add(amd);
                aio = (OverrideAttributeIO)AttributeIO.get(amd);
            }
            if (aio == null) {
                aio = new OverrideAttributeIO(this, null);
            }
            if ((attrOverride = map.get(name = overrideOf.getName())) != null) {
                map.remove(name);
            }
            this.todo.add(new AttributeInfoOverride(overrideOf, attrOverride, aio));
        }
        for (AttributeOverride override : map.values()) {
            this.addProblem("AttributeOverride does not match any inherited attributes: " + override.name(), (Annotation)override);
        }
    }

    protected void fillTodoWithAttributeInfos(RAnnotatedElement[] all, boolean allContainsFields, Set<AttributeMetaData> found) {
        boolean accessField;
        boolean bl = accessField = this.emd.getAccessType() == 1;
        if (accessField == allContainsFields) {
            RAnnotatedElement[] rAnnotatedElementArray = all;
            int n = 0;
            int n2 = rAnnotatedElementArray.length;
            while (n < n2) {
                RAnnotatedElement attribute = rAnnotatedElementArray[n];
                if (this.mm.checkValidAttribute(attribute) == null) {
                    this.todo.add(this.createAttributeInfo(attribute, found));
                } else {
                    this.checkNoPersistentAnnotations(attribute);
                }
                ++n;
            }
        } else {
            RAnnotatedElement[] rAnnotatedElementArray = all;
            int n = 0;
            int n3 = rAnnotatedElementArray.length;
            while (n < n3) {
                RAnnotatedElement attribute = rAnnotatedElementArray[n];
                this.checkNoPersistentAnnotations(attribute);
                ++n;
            }
        }
    }

    protected AttributeInfo createAttributeInfo(RAnnotatedElement attribute, Set<AttributeMetaData> found) {
        Class aioCls = this.selectAttributeIOClass(attribute);
        String attributeName = Utils.getAttributeName(attribute);
        AttributeIO aio = null;
        AttributeMetaData amd = this.emd.findAttributeMetaData(attributeName);
        if (amd == null) {
            amd = this.getNonPeristentAttribute(attributeName);
        }
        if (amd != null) {
            aio = AttributeIO.get(amd);
            if (aio != null) {
                if (aio.getClass() != aioCls) {
                    aio.dispose();
                    amd.delete();
                    aio = this.createAttributeIO(aioCls);
                } else {
                    found.add(amd);
                }
            } else {
                amd.delete();
                aio = this.createAttributeIO(aioCls);
            }
        } else {
            aio = this.createAttributeIO(aioCls);
        }
        return new AttributeInfoNormal(attribute, aio);
    }

    protected Class selectAttributeIOClass(RAnnotatedElement attribute) {
        String typeName = attribute.getTypeName();
        TypeMetaData tmd = this.findTypeByClassName(typeName);
        if (tmd instanceof EntityMetaData) {
            if (((EntityMetaData)tmd).isEntity()) {
                return ReferenceAttributeIO.class;
            }
            return EmbeddedAttributeIO.class;
        }
        if (tmd instanceof CollectionTypeMetaData) {
            return CollectionAttributeIO.class;
        }
        return BasicAttributeIO.class;
    }

    protected void checkNoPersistentAnnotations(RAnnotatedElement attribute) {
        Annotation[] all;
        String string = attribute.isField() ? "Field " : "Method ";
        Annotation[] annotationArray = all = attribute.getAnnotations();
        int n = 0;
        int n2 = annotationArray.length;
        while (n < n2) {
            Annotation ann = annotationArray[n];
            if (ann.annotationType() != Transient.class) {
                boolean badAccess;
                StringBuffer s = new StringBuffer();
                boolean field = attribute.isField();
                if (field) {
                    s.append("Field '");
                    badAccess = this.emd.getAccessType() != 1;
                } else {
                    s.append("Property '");
                    badAccess = this.emd.getAccessType() != 2;
                }
                s.append(attribute.getName());
                s.append("' is not persistent: ");
                if (badAccess) {
                    s.append(String.valueOf(this.emd.getShortName()) + " is using ");
                    if (this.emd.getAccessType() == 1) {
                        s.append("FIELD");
                    } else {
                        s.append("PROPERTY");
                    }
                    s.append(" access");
                } else {
                    s.append(this.mm.checkValidAttribute(attribute));
                }
                this.addProblem(s.toString(), ann);
                break;
            }
            ++n;
        }
    }

    public void updateModelFromMetaDataPost(RClass cls, boolean failed) throws Exception {
        this.todo = null;
        this.checkEntity(cls.getLocation());
    }

    protected void checkEntity(Map location) {
        this.checkPrimaryKey(location);
        this.checkVersion(location);
    }

    protected void checkPrimaryKey(Map location) {
        if (this.emd.isBaseEntity() && this.emd.getPrimaryKeyList().isEmpty()) {
            this.addProblem("Entity has no primary key (Id) attributes", location);
        }
    }

    protected void checkVersion(Map location) {
        if (this.emd.getVersionList().size() > 1) {
            this.addProblem("Entity has more than one Version attribute, this is not portable", location, 1);
        }
    }

    protected Table getTableAnnotation(RClass cls) {
        Table t = cls.getAnnotation(Table.class, true);
        ((AnnotationEx)t).setDefault("name", this.getDefaultTableName(cls.getSimpleName()));
        return t;
    }

    public boolean isPersistentByDefault(RAnnotatedElement attribute) {
        if (this.mm.checkValidAttribute(attribute) != null) {
            return false;
        }
        if (attribute.isField()) {
            return this.emd.getAccessType() == 1;
        }
        return this.emd.getAccessType() == 2;
    }

    public TypeMetaData findTypeByClassName(String typeName) {
        EntityModel model = this.mm.getEntityModel();
        TypeMetaData tmd = model.findTypeByClassName(typeName);
        if (tmd == null) {
            int i = 0;
            while (i < DEFAULT_PACKAGES.length) {
                tmd = model.findTypeByClassName(String.valueOf(DEFAULT_PACKAGES[i]) + typeName);
                if (tmd != null) break;
                ++i;
            }
        }
        return tmd;
    }

    protected AttributeIO createAttributeIO(Class cls) {
        try {
            Constructor con = cls.getConstructor(EntityIO.class);
            return (AttributeIO)con.newInstance(this);
        }
        catch (Exception e) {
            OrmPlugin.log((Throwable)e);
            return null;
        }
    }

    protected BasicAttributeIO createBasicAttributeIO() {
        return new BasicAttributeIO(this);
    }

    protected ReferenceAttributeIO createReferenceAttributeIO() {
        return new ReferenceAttributeIO(this);
    }

    public void updateMetaDataFromModel(RClass cls) {
        boolean accessChanged;
        AccessType access;
        Class<EmbeddableSuperclass> mainType;
        switch (this.emd.getEntityType()) {
            case 0: {
                Utils.removeAnnotation(cls, EmbeddableSuperclass.class);
                Utils.removeAnnotation(cls, Embeddable.class);
                Utils.removeAnnotation(cls, Entity.class);
                return;
            }
            case 3: {
                mainType = EmbeddableSuperclass.class;
                Utils.removeAnnotation(cls, Embeddable.class);
                Utils.removeAnnotation(cls, Entity.class);
                break;
            }
            case 2: {
                mainType = Embeddable.class;
                Utils.removeAnnotation(cls, EmbeddableSuperclass.class);
                Utils.removeAnnotation(cls, Entity.class);
                break;
            }
            default: {
                mainType = Entity.class;
                Utils.removeAnnotation(cls, Embeddable.class);
                Utils.removeAnnotation(cls, EmbeddableSuperclass.class);
            }
        }
        AnnotationEx main = (AnnotationEx)cls.getAnnotation(mainType, true);
        if (main instanceof Entity) {
            main.setDefault("name", cls.getSimpleName());
            main.set("name", this.emd.getSchemaName());
        }
        switch (this.emd.getAccessType()) {
            case 1: {
                access = AccessType.FIELD;
                break;
            }
            case 2: {
                access = AccessType.PROPERTY;
                break;
            }
            default: {
                access = null;
            }
        }
        boolean bl = accessChanged = this.oldAccessType != this.emd.getAccessType();
        if (access != null) {
            main.set("access", access);
        }
        main.setMarker(true);
        AnnotationEx idc = (AnnotationEx)cls.getAnnotation(IdClass.class, true);
        idc.set("value", this.emd.getIdClass());
        AnnotationEx table = (AnnotationEx)this.getTableAnnotation(cls);
        table.set("name", this.emd.getTable().getName(), true);
        table.set("catalog", this.emd.getTable().getCatalog(), true);
        table.set("schema", this.emd.getTable().getSchema(), true);
        switch (this.emd.getEntityType()) {
            default: {
                if (this.emd.isBaseEntity()) {
                    this.updateMetaDataInheritanceTop(cls);
                    break;
                }
                this.updateMetaDataInheritanceNonBase(cls);
                break;
            }
            case 3: {
                this.updateMetaDataInheritanceTop(cls);
                break;
            }
            case 2: {
                Utils.removeAnnotation(cls, DiscriminatorColumn.class);
                Utils.removeAnnotation(cls, Inheritance.class);
                Utils.removeAnnotation(cls, PrimaryKeyJoinColumn.class);
                Utils.removeAnnotation(cls, PrimaryKeyJoinColumns.class);
            }
        }
        this.updateMetaDataInheritedAttributes(cls);
        this.updateMetaDataAttributes(cls, accessChanged);
        this.updateMetaDataNonPersistentAttributes(cls, accessChanged);
    }

    protected void updateMetaDataInheritedAttributes(RClass cls) {
        ArrayList<OverrideAttributeIO> toDelete = null;
        AttributeOverrideMap map = new AttributeOverrideMap(cls, null);
        AttributeOverride extra = null;
        for (AttributeMetaData amd : this.emd.getAttributeList()) {
            AttributeIO o = AttributeIO.get(amd);
            if (!(o instanceof OverrideAttributeIO)) continue;
            OverrideAttributeIO aio = (OverrideAttributeIO)o;
            String name = amd.getName();
            AttributeOverride override = map.get(name);
            if (override == null) {
                if (extra == null) {
                    extra = map.append();
                }
                override = extra;
            }
            if (!aio.updateMetaDataFromModel(override)) {
                if (toDelete == null) {
                    toDelete = new ArrayList<OverrideAttributeIO>();
                }
                toDelete.add(aio);
                continue;
            }
            if (override != extra || !((AnnotationEx)extra).hasValue("column")) continue;
            ((AnnotationEx)extra).set("name", name);
            extra = null;
        }
        map.cleanupAfterMetaDataUpdates();
    }

    protected void updateMetaDataAttributes(RClass cls, boolean accessChanged) {
        ArrayList<AttributeIO> toDelete = null;
        for (AttributeMetaData amd : this.emd.getAttributeList()) {
            AttributeIO aio = AttributeIO.get(amd);
            if (aio == null || aio instanceof OverrideAttributeIO || aio.updateMetaDataFromModel(cls, accessChanged)) continue;
            if (toDelete == null) {
                toDelete = new ArrayList<AttributeIO>();
            }
            toDelete.add(aio);
        }
        this.deleteModelAttributes(toDelete);
    }

    protected void deleteModelAttributes(List<AttributeIO> toDelete) {
        if (toDelete != null) {
            for (AttributeIO aio : toDelete) {
                AttributeMetaData amd = aio.getAttributeMetaData();
                this.emd.getAttributeList().remove((Object)amd);
                amd.delete();
                aio.dispose();
            }
        }
    }

    protected void updateMetaDataNonPersistentAttributes(RClass cls, boolean accessChanged) {
        ArrayList<AttributeIO> toDelete = null;
        for (Map.Entry<String, AttributeMetaData> e : this.npAttributeMap.entrySet()) {
            AttributeIO aio = AttributeIO.get(e.getValue());
            if (aio == null || aio.updateMetaDataFromModel(cls, accessChanged)) continue;
            if (toDelete == null) {
                toDelete = new ArrayList<AttributeIO>();
            }
            toDelete.add(aio);
        }
        if (toDelete != null) {
            for (AttributeIO aio : toDelete) {
                AttributeMetaData amd = aio.getAttributeMetaData();
                this.npAttributeMap.remove(amd.getName());
                amd.delete();
                aio.dispose();
            }
        }
    }

    protected void updateMetaDataInheritanceTop(RClass cls) {
        Utils.removeAnnotation(cls, PrimaryKeyJoinColumn.class);
        Utils.removeAnnotation(cls, PrimaryKeyJoinColumns.class);
        AnnotationEx inheritance = null;
        if (this.emd.getInheritance() != 0) {
            inheritance = (AnnotationEx)cls.getAnnotation(Inheritance.class, true);
            inheritance.setDefault("discriminatorValue", this.defaultDiscriminatorValue);
            inheritance.set("discriminatorValue", this.emd.getDiscriminatorValue());
        }
        this.updateMetaDataDiscriminatorColumn(cls, inheritance);
        switch (this.emd.getInheritance()) {
            case 0: {
                Utils.removeAnnotation(cls, Inheritance.class);
                break;
            }
            case 1: {
                inheritance.set("strategy", InheritanceType.SINGLE_TABLE);
                break;
            }
            case 3: {
                inheritance.set("strategy", InheritanceType.JOINED);
                break;
            }
            case 2: {
                inheritance.set("strategy", InheritanceType.TABLE_PER_CLASS);
            }
        }
    }

    protected void updateMetaDataDiscriminatorColumn(RClass cls, AnnotationEx inheritance) {
        OrmColumn dc = this.emd.getDiscriminatorColumn();
        if (dc == null) {
            Utils.removeAnnotation(cls, DiscriminatorColumn.class);
        } else {
            switch (dc.getJdbcType()) {
                case 1: {
                    inheritance.set("discriminatorType", DiscriminatorType.CHAR);
                    break;
                }
                case 4: {
                    inheritance.set("discriminatorType", DiscriminatorType.INTEGER);
                    break;
                }
                default: {
                    inheritance.set("discriminatorType", DiscriminatorType.STRING);
                }
            }
            AnnotationEx discColumn = (AnnotationEx)cls.getAnnotation(DiscriminatorColumn.class, true);
            discColumn.setMarker(true);
            discColumn.setDefault("name", "TYPE");
            discColumn.set("name", dc.getName());
            discColumn.set("length", dc.getLength());
            boolean colDefChanged = !dc.getColumnDefinition().equals(dc.getOriginalColumnDefinition());
            String stdColDef = this.mm.getColumnDefinition(dc);
            if (colDefChanged) {
                discColumn.setDefault("columnDefinition", stdColDef);
                discColumn.set("columnDefinition", dc.getColumnDefinition(), true);
            }
            if (!discColumn.hasValue("columnDefinition")) {
                dc.setColumnDefinition(stdColDef);
            }
            dc.setOriginalColumnDefinition(dc.getColumnDefinition());
            this.mm.updateDatabaseType(dc);
        }
    }

    protected void updateMetaDataInheritanceNonBase(RClass cls) {
        Utils.removeAnnotation(cls, DiscriminatorColumn.class);
        String dv = this.emd.getDiscriminatorValue();
        if (dv == null) {
            Utils.removeAnnotation(cls, Inheritance.class);
        } else {
            AnnotationEx inheritance = (AnnotationEx)cls.getAnnotation(Inheritance.class, true);
            inheritance.setDefault("discriminatorValue", this.defaultDiscriminatorValue);
            inheritance.set("discriminatorValue", dv);
        }
        EntityMetaData superEntity = this.emd.getSuperEntity();
        if (superEntity != null && superEntity.getInheritance() == 3) {
            this.updateMetaDataInheritanceJoined(cls);
        } else {
            Utils.removeAnnotation(cls, PrimaryKeyJoinColumn.class);
            Utils.removeAnnotation(cls, PrimaryKeyJoinColumns.class);
        }
    }

    protected void updateMetaDataInheritanceJoined(RClass cls) {
        Join join = this.emd.getSuperJoin();
        if (join == null) {
            return;
        }
        if (join.getPairList().size() == 1) {
            Utils.removeAnnotation(cls, PrimaryKeyJoinColumns.class);
            AnnotationEx jc = (AnnotationEx)cls.getAnnotation(PrimaryKeyJoinColumn.class, true);
            this.joinIO.updateMetaDataJoinColumn(jc, join, (JoinPair)join.getPairList().get(0), this.mm.getJoinedInheritanceCNS(this.emd), false);
        } else {
            Utils.removeAnnotation(cls, PrimaryKeyJoinColumn.class);
            EList pairList = join.getPairList();
            AnnotationEx joinColumns = (AnnotationEx)cls.getAnnotation(PrimaryKeyJoinColumns.class, true);
            int n = pairList.size();
            if (joinColumns.setArraySize("value", n)) {
                PrimaryKeyJoinColumn[] a = ((PrimaryKeyJoinColumns)joinColumns).value();
                int i = 0;
                while (i < n) {
                    this.joinIO.updateMetaDataJoinColumn((AnnotationEx)a[i], join, (JoinPair)pairList.get(i), this.mm.getJoinedInheritanceCNS(this.emd), false);
                    ++i;
                }
                if (n > 1) {
                    i = 0;
                    while (i < n) {
                        AnnotationEx jc = (AnnotationEx)a[i];
                        int c = jc.getValueCount();
                        if (jc.hasValue("referencedColumnName")) {
                            --c;
                        }
                        if (c > 0) break;
                        ++i;
                    }
                    if (i == n) {
                        joinColumns.delete();
                    }
                }
            }
        }
    }

    protected InheritanceType getInheritanceType(int code) {
        switch (code) {
            default: {
                return InheritanceType.SINGLE_TABLE;
            }
            case 3: {
                return InheritanceType.JOINED;
            }
            case 2: 
        }
        return InheritanceType.TABLE_PER_CLASS;
    }

    protected int getInheritanceTypeCode(InheritanceType t) {
        switch (t) {
            case SINGLE_TABLE: {
                return 1;
            }
            case JOINED: {
                return 3;
            }
            case TABLE_PER_CLASS: {
                return 2;
            }
        }
        return 0;
    }

    public void notifyChanged(Notification no) {
        this.mm.notifyChanged(no, this);
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && EntityMetaData.class.isAssignableFrom((Class)type) && OrmTable.class.isAssignableFrom((Class)type) && OrmColumn.class.isAssignableFrom((Class)type);
    }

    public EntityMetaData getEntityMetaData() {
        return this.emd;
    }

    public GenericEntityModelManager getModelManager() {
        return this.mm;
    }

    public void elementChanged(final ElementChangedEvent event) {
        if (this.mm.isIgnoreEvents()) {
            return;
        }
        IJavaElementDelta delta = (IJavaElementDelta)event.getSource();
        if (delta.getElement().getAncestor(5).equals(this.type.getParent())) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    EntityIO.this.mm.updateModelFromMetaData(EntityIO.this, event);
                }
            });
        }
    }

    public BasicAttribute getIdGeneratorAttribute() {
        return this.idGeneratorAttribute;
    }

    public void setIdGeneratorAttribute(BasicAttribute idGeneratorAttribute) {
        this.idGeneratorAttribute = idGeneratorAttribute;
    }

    public void addProblem(String msg, Map location) {
        this.addProblem(msg, location, 2);
    }

    public void addProblem(String msg, Map location, int severity) {
        try {
            IMarker marker = this.type.getResource().createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("message", (Object)msg);
            marker.setAttribute("severity", severity);
            if (location != null) {
                for (Map.Entry e : location.entrySet()) {
                    marker.setAttribute((String)e.getKey(), e.getValue());
                }
            }
            marker.setAttribute("transient", true);
            this.markers.add(marker);
        }
        catch (CoreException e) {
            OrmPlugin.log((Throwable)e);
        }
    }

    public void addProblem(String msg, Annotation annotation, String valueName) {
        this.addProblem(msg, (AnnotationEx)((Object)annotation), valueName);
    }

    public void addProblem(String msg, Annotation annotation) {
        this.addProblem(msg, (AnnotationEx)((Object)annotation), null);
    }

    public void addProblem(String msg, AnnotationEx annotation, String valueName) {
        this.addProblem(msg, annotation.getLocation(valueName));
    }

    public void addProblem(String msg, AnnotationEx annotation) {
        this.addProblem(msg, annotation, null);
    }

    public int compareTo(Object o) {
        EntityIO e = (EntityIO)o;
        return this.emd.getClassName().compareTo(e.emd.getClassName());
    }

    public IType getType() {
        return this.type;
    }

    public String toString() {
        if (this.emd == null) {
            return "EntityIO EntityMetaData == null";
        }
        return "EntityIO " + this.emd.getClassName();
    }

    protected String getDefaultTableName(String entityName) {
        return this.mm.getDefaultTableName(entityName);
    }

    public Set<EntityIO> getDependOnUs() {
        return this.dependOnUs;
    }

    public void addDependencyOn(EntityMetaData other) {
        if (other == null) {
            return;
        }
        EntityIO otherIO = EntityIO.get(other);
        otherIO.dependOnUs.add(this);
        this.weDependOn.add(otherIO);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        return this;
    }

    public Class[] getAdapterList() {
        return new Class[]{EntityIO.class};
    }

    public int getModelUpdateStatus() {
        return this.modelUpdateStatus;
    }

    public AttributeMetaData getNonPeristentAttribute(String name) {
        return this.npAttributeMap.get(name);
    }

    public void addNonPersistentAttribute(AttributeMetaData amd) {
        this.npAttributeMap.put(amd.getName(), amd);
    }

    public void removeNonPersistentAttribute(AttributeMetaData amd) {
        this.npAttributeMap.remove(amd.getName());
    }

    public String getNewAttributeName(String name) {
        return this.renamedAttributeMap == null ? null : this.renamedAttributeMap.get(name);
    }

    public OrmColumn createOrmColumn() {
        OrmColumn c = this.mm.getFactory().createOrmColumn();
        c.eAdapters().add((Object)this);
        return c;
    }

    protected OrmColumn ensureOrmColumn(OrmColumn c) {
        if (c == null) {
            c = this.createOrmColumn();
        }
        return c;
    }

    protected OrmTable ensureTable(OrmTable t) {
        if (t == null) {
            t = this.mm.getFactory().createOrmTable();
            t.eAdapters().add((Object)this);
        }
        return t;
    }

    public AstState getAstState() {
        return this.astState;
    }

    public void setAstState(AstState astState) {
        this.astState = astState;
    }

    public boolean isUseDiscriminatorColumnEnabled() {
        if (!this.emd.isBaseEntity()) {
            return false;
        }
        switch (this.emd.getInheritance()) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                return !this.emd.isInheritanceSpecified() || this.emd.getSubEntityList().isEmpty();
            }
        }
        return false;
    }

    public void setUseDiscriminatorColumn(boolean on) {
        if (on) {
            if (this.emd.getDiscriminatorColumn() == null) {
                try {
                    this.updateAddDiscriminatorColumn = true;
                    this.mm.updateModelFromMetaData(this);
                }
                finally {
                    this.updateAddDiscriminatorColumn = false;
                }
            }
        } else {
            final OrmColumn dc = this.emd.getDiscriminatorColumn();
            if (dc != null) {
                this.mm.executeModelChanges(new Runnable(){

                    public void run() {
                        dc.delete();
                        EntityIO.this.emd.setDiscriminatorColumn(null);
                    }
                });
            }
        }
    }

    public int getRelativePosition() {
        if (this.emd == null) {
            return 0;
        }
        EntityMetaData superEmd = this.emd.getSuperEntity();
        EntityIO sio = EntityIO.get(superEmd);
        if (sio == null) {
            return 0;
        }
        return 1000000 + sio.getRelativePosition() + 100000 * superEmd.getSubEntityList().indexOf((Object)this.emd);
    }

    public void getPossibleEntityMappings(List ans) {
        ans.add(MAPPING_ENTITY);
        ans.add(MAPPING_EMBEDDABLE);
        ans.add(MAPPING_EMBEDDABLE_SUPERCLASS);
        ans.add(MAPPING_NOT_PERSISTENT);
    }

    public IIntOption getEntityMapping() {
        switch (this.emd.getEntityType()) {
            case 1: {
                return MAPPING_ENTITY;
            }
            case 2: {
                return MAPPING_EMBEDDABLE;
            }
            case 3: {
                return MAPPING_EMBEDDABLE_SUPERCLASS;
            }
        }
        return null;
    }

    public void setEntityMapping(IIntOption option) {
        int et = MAPPING_NOT_PERSISTENT.equals((Object)option) ? 0 : (MAPPING_EMBEDDABLE.equals((Object)option) ? 2 : (MAPPING_EMBEDDABLE_SUPERCLASS.equals((Object)option) ? 3 : 1));
        if (et != this.emd.getEntityType()) {
            this.emd.setEntityType(et);
        }
    }

    public JoinIO getJoinIO() {
        return this.joinIO;
    }

    protected abstract class AttributeInfo {
        protected AttributeInfo() {
        }

        public abstract boolean updateModelFromMetaData(RClass var1, boolean var2);
    }

    protected class AttributeInfoNormal
    extends AttributeInfo {
        public RAnnotatedElement attribute;
        public AttributeIO attributeIO;

        public AttributeInfoNormal(RAnnotatedElement attribute, AttributeIO attributeIO) {
            this.attribute = attribute;
            this.attributeIO = attributeIO;
        }

        public boolean updateModelFromMetaData(RClass cls, boolean metaDataChanged) {
            return this.attributeIO.updateModelFromMetaData(cls, this.attribute, metaDataChanged);
        }

        public String toString() {
            return this.attribute + " " + this.attributeIO;
        }
    }

    protected class AttributeInfoOverride
    extends AttributeInfo {
        public AttributeOverride override;
        public AttributeMetaData overrideOf;
        public OverrideAttributeIO attributeIO;

        public AttributeInfoOverride(AttributeMetaData overrideOf, AttributeOverride override, OverrideAttributeIO attributeIO) {
            this.overrideOf = overrideOf;
            this.override = override;
            this.attributeIO = attributeIO;
        }

        public boolean updateModelFromMetaData(RClass cls, boolean metaDataChanged) {
            return this.attributeIO.updateModelFromMetaData(cls, this.overrideOf, this.override, metaDataChanged, 0);
        }

        public String toString() {
            return "Override " + this.overrideOf.getName() + " " + this.attributeIO;
        }
    }
}

