/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.generic.GenericPlugin;
import org.osgi.framework.Bundle;

public class PersistenceClasspathInitializer
extends ClasspathContainerInitializer {
    protected static final String EJB3_PERSISTENCE = "EJB3_PERSISTENCE";

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        IClasspathEntry parFileEntry;
        IClasspathEntry ejb3Persistence;
        Bundle bundle = GenericPlugin.getDefault().getBundle();
        String path = bundle.getEntry("/").toExternalForm();
        try {
            ejb3Persistence = JavaCore.newLibraryEntry((IPath)new Path(Platform.asLocalURL((URL)new URL(String.valueOf(path) + "lib/ejb3-persistence.jar")).getPath()), null, null);
            IProject project2 = project.getProject();
            PersistenceProperties props = new PersistenceProperties(project2);
            String parFileName = props.getParFileName();
            IFile parIFile = project2.getFile(parFileName);
            IPath parPath = parIFile.getRawLocation();
            File parFile = new File(parPath.toOSString());
            if (!parFile.exists()) {
                File parDir = parFile.getParentFile();
                if (!parDir.exists()) {
                    parDir.mkdirs();
                }
                JarOutputStream jos = new JarOutputStream(new FileOutputStream(parFile));
                JarEntry newEntry = new JarEntry(".");
                jos.putNextEntry(newEntry);
                jos.flush();
                jos.close();
                parIFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            parFileEntry = JavaCore.newLibraryEntry((IPath)parIFile.getFullPath(), null, null);
        }
        catch (Exception e) {
            Status status = new Status(4, bundle.getSymbolicName(), 0, "Problems adding ejb3-persistence.jar to casspath", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        final IClasspathEntry[] entries = new IClasspathEntry[]{ejb3Persistence, parFileEntry};
        IClasspathContainer container = new IClasspathContainer(){

            public IClasspathEntry[] getClasspathEntries() {
                return entries;
            }

            public String getDescription() {
                return "Generic EJB3 persistence";
            }

            public IPath getPath() {
                return new Path(PersistenceClasspathInitializer.EJB3_PERSISTENCE);
            }

            public int getKind() {
                return 1;
            }
        };
        JavaCore.setClasspathContainer((IPath)container.getPath(), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
    }
}

