/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jsr220Orm.generic.xml.VendorDefinitionDocument;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.core.internal.options.IntOption;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.core.options.IIntOption;
import org.eclipse.jsr220orm.core.options.IOptionsDescriptor;
import org.eclipse.jsr220orm.core.util.JdbcUtils;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.jsr220orm.generic.GenericPlugin;
import org.eclipse.jsr220orm.generic.PersistenceXmlManager;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.VendorDef;
import org.eclipse.jsr220orm.generic.io.AnnotationRegistry;
import org.eclipse.jsr220orm.generic.io.AttributeIO;
import org.eclipse.jsr220orm.generic.io.ColumnNameStrategy;
import org.eclipse.jsr220orm.generic.io.EntityIO;
import org.eclipse.jsr220orm.generic.io.ast.AstRClass;
import org.eclipse.jsr220orm.generic.io.ast.AstRClassFactory;
import org.eclipse.jsr220orm.generic.reflect.RAnnotatedElement;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.generic.reflect.RMethod;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.CollectionTypeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.MetadataFactory;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.ReferenceAttribute;
import org.eclipse.jsr220orm.metadata.SimpleTypeMetaData;
import org.eclipse.jsr220orm.metadata.TypeMetaData;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEntityModelManager
implements IEntityModelManager,
IAdapterFactory {
    protected MetadataFactory factory;
    protected EntityModel model;
    protected IJavaProject project;
    protected OrmNature nature;
    protected PersistenceXmlManager persistenceXmlManager;
    protected ASTParser astParser;
    protected AnnotationRegistry annotationRegistry;
    protected AstRClassFactory astRClassFactory;
    protected ConnectionInfo connectionInfo;
    protected int[] jdbcTypes;
    protected String vendorDefinitionResource = "vendor-generic.xml";
    protected VendorDef vendorDef;
    protected DatabaseDefinition dbdef;
    protected int ignoreEvents;
    protected Set<EntityIO> forMetaDataUpdate = new HashSet<EntityIO>();
    protected String classPathVariableName;
    protected int startModelEventBatchCount;
    protected Set<EntityIO> batchSet = new LinkedHashSet<EntityIO>();
    protected int columnPositionPrimaryKey = -5000;
    protected int columnPositionVersion = -4000;
    protected int columnPositionDiscriminator = -3000;
    protected int columnPositionForeignKey = 0;
    protected boolean useMarkerAnnotations;
    protected String builderId;
    protected static final int[] VALID_ACCESS_TYPES = new int[]{1, 2};
    protected static final int[] VALID_ID_GENERATOR_TYPES = new int[]{5, 4, 1, 3, 2};
    protected static final int[] VALID_FETCH_TYPES = new int[]{1, 2};
    protected static final int[] VALID_CASCADE_TYPES = new int[]{1, 2, 4, 8};
    protected static final int[] VALID_INHERITANCE_BASE;
    protected static final int[] VALID_INHERITANCE_BASE_WITH_SUBS;
    protected static final int[] EMPTY_INT_ARRAY;
    protected static final ColumnNameStrategy USE_DEST_NAME;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 3;
        VALID_INHERITANCE_BASE = nArray;
        VALID_INHERITANCE_BASE_WITH_SUBS = new int[]{1, 3};
        EMPTY_INT_ARRAY = new int[0];
        USE_DEST_NAME = new ColumnNameStrategy(){

            public String getColumnName(OrmColumn dest) {
                return dest.getName();
            }
        };
    }

    public void init(IProject project, OrmNature nature, DatabaseDefinition definition) throws Exception {
        String vendorDefRes;
        this.project = JavaCore.create((IProject)project);
        this.nature = nature;
        this.dbdef = definition;
        PersistenceProperties persistenceProperties = nature.getPersistenceProperties();
        this.builderId = persistenceProperties.getProperty("ejb3.verndor.builder");
        try {
            Utils.addBuilder(project, this.builderId);
        }
        catch (CoreException e) {
            GenericPlugin.getDefault().getLog().log(e.getStatus());
        }
        this.classPathVariableName = persistenceProperties.getProperty("classpath.variable.name");
        if (this.classPathVariableName != null) {
            try {
                Utils.addCpVarTo(this.project, this.classPathVariableName);
            }
            catch (JavaModelException e) {
                GenericPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        if ((vendorDefRes = persistenceProperties.getProperty("ejb3.vendor.definition")) != null) {
            this.vendorDefinitionResource = vendorDefRes;
        }
        this.factory = this.createMetadataFactory();
        this.astParser = ASTParser.newParser((int)3);
        this.annotationRegistry = this.createAnnotationRegistry();
        this.annotationRegistry.load(GenericPlugin.getPluginId());
        this.astRClassFactory = this.createAstRClassFactory();
        this.jdbcTypes = this.getAllJdbcTypeInts();
        this.vendorDef = this.createVendorDef();
        this.vendorDef.init(this.vendorDefinitionResource, this);
        this.model = this.createEntityModel();
        this.persistenceXmlManager = this.createPersistenceXmlManager();
        this.persistenceXmlManager.loadPersistenceXml();
        if (this.persistenceXmlManager.updateModelFromPersistenceXml()) {
            this.persistenceXmlManager.savePersistenceXml();
        }
    }

    public void initCleanup() {
        this.vendorDef.initCleanup();
    }

    protected VendorDef createVendorDef() {
        return new VendorDef();
    }

    protected PersistenceXmlManager createPersistenceXmlManager() {
        return new PersistenceXmlManager(this);
    }

    protected AnnotationRegistry createAnnotationRegistry() {
        return new AnnotationRegistry();
    }

    protected AstRClassFactory createAstRClassFactory() {
        return new AstRClassFactory(this.project, this.annotationRegistry);
    }

    protected MetadataFactory createMetadataFactory() {
        return MetadataFactory.eINSTANCE;
    }

    protected EntityModel createEntityModel() throws Exception {
        VendorDefinitionDocument.VendorDefinition.CollectionType[] collectionTypes;
        VendorDefinitionDocument.VendorDefinition.SimpleType[] simpleTypes;
        EntityModel model = this.factory.createEntityModel();
        EList typeList = model.getTypeList();
        VendorDefinitionDocument.VendorDefinition.SimpleType[] simpleTypeArray = simpleTypes = this.vendorDef.getSimpleTypes();
        int n = 0;
        int n2 = simpleTypeArray.length;
        while (n < n2) {
            VendorDefinitionDocument.VendorDefinition.SimpleType st = simpleTypeArray[n];
            SimpleTypeMetaData tmd = this.factory.createSimpleTypeMetaData();
            Class cls = Utils.loadClass(st.getName(), true, this.getClass().getClassLoader());
            tmd.setCls(cls);
            tmd.setClassName(st.getName());
            OrmColumn c = this.factory.createOrmColumn();
            int jdbcType = JdbcUtils.getJdbcTypeValue((String)st.getJdbcType());
            c.setJdbcType(jdbcType);
            c.setLength(st.getLength());
            c.setScale(st.getScale());
            c.setNullable(st.getNullable());
            c.setInsertable(true);
            c.setUpdatable(true);
            VendorDef.JdbcTypeInfo info = this.vendorDef.getJdbcTypeInfo(jdbcType);
            if (info != null) {
                c.setDatabaseType(info.dataTypeName);
            }
            tmd.setColumn(c);
            typeList.add(tmd);
            ++n;
        }
        VendorDefinitionDocument.VendorDefinition.CollectionType[] collectionTypeArray = collectionTypes = this.vendorDef.getCollectionTypes();
        n2 = 0;
        int n3 = collectionTypeArray.length;
        while (n2 < n3) {
            VendorDefinitionDocument.VendorDefinition.CollectionType ct = collectionTypeArray[n2];
            CollectionTypeMetaData cmd = this.factory.createCollectionTypeMetaData();
            Class cls = Utils.loadClass(ct.getName(), true, this.getClass().getClassLoader());
            cmd.setCls(cls);
            cmd.setClassName(cls.getName());
            typeList.add(cmd);
            ++n2;
        }
        return model;
    }

    public OrmNature getNature() {
        return this.nature;
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public MetadataFactory getFactory() {
        return this.factory;
    }

    public EntityModel getEntityModel() {
        return this.model;
    }

    public ASTParser getASTParser() {
        return this.astParser;
    }

    public AnnotationRegistry getAnnotationRegistry() {
        return this.annotationRegistry;
    }

    public AstRClassFactory getAstRClassFactory() {
        return this.astRClassFactory;
    }

    public DatabaseDefinition getDatabaseDefinition() {
        return this.dbdef;
    }

    public void dispose() {
        if (this.classPathVariableName != null) {
            try {
                Utils.removeCpVarFrom(this.project, this.classPathVariableName);
            }
            catch (JavaModelException e) {
                GenericPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        try {
            Utils.removeBuilder(this.project.getProject(), this.builderId);
        }
        catch (CoreException e) {
            GenericPlugin.getDefault().getLog().log(e.getStatus());
        }
        if (this.persistenceXmlManager != null) {
            this.persistenceXmlManager.dispose();
        }
        if (this.model != null) {
            for (TypeMetaData tmd : this.model.getTypeList()) {
                EntityIO entityIO;
                if (!(tmd instanceof EntityMetaData) || (entityIO = (EntityIO)tmd.adapt(EntityIO.class)) == null) continue;
                entityIO.dispose();
            }
        }
        this.model = null;
    }

    public int[] getValidAccessTypes(EntityMetaData entityMetaData) {
        return VALID_ACCESS_TYPES;
    }

    public int[] getValidInheritances(EntityMetaData emd) {
        if (emd.isBaseEntity()) {
            if (emd.hasSubEntities()) {
                return VALID_INHERITANCE_BASE_WITH_SUBS;
            }
            return VALID_INHERITANCE_BASE;
        }
        return EMPTY_INT_ARRAY;
    }

    public int[] getValidIdGeneratorTypes(EntityMetaData entityMetaData) {
        return VALID_ID_GENERATOR_TYPES;
    }

    public int[] getValidFetchTypes(AttributeMetaData attributeMetaData) {
        return VALID_FETCH_TYPES;
    }

    public int[] getValidCascadeTypes(ReferenceAttribute attributeMetaData) {
        return VALID_CASCADE_TYPES;
    }

    public int[] getValidCascadeTypes(CollectionAttribute attributeMetaData) {
        return VALID_CASCADE_TYPES;
    }

    public EntityMetaData getEntityMetaData(String className) {
        TypeMetaData tmd = this.model.findTypeByClassName(className);
        return tmd instanceof EntityMetaData ? (EntityMetaData)tmd : null;
    }

    public void makePersistent(Collection names, IIntOption option) {
        try {
            int type;
            if (EntityIO.MAPPING_ENTITY.equals((Object)option)) {
                type = 1;
            } else if (EntityIO.MAPPING_EMBEDDABLE.equals((Object)option)) {
                type = 2;
            } else if (EntityIO.MAPPING_EMBEDDABLE_SUPERCLASS.equals((Object)option)) {
                type = 3;
            } else {
                throw new IllegalArgumentException("Invalid option: " + option);
            }
            this.persistenceXmlManager.makePersistent(names, type);
        }
        catch (Exception e) {
            OrmPlugin.log((Throwable)e);
        }
    }

    public VendorDef getVendorDef() {
        return this.vendorDef;
    }

    public List getPossibleAttributeMappings(AttributeMetaData amd) {
        AttributeIO aio = (AttributeIO)amd.adapt(AttributeIO.class);
        ArrayList<IntOption> ans = new ArrayList<IntOption>();
        if (aio != null) {
            aio.getPossibleMappings(ans);
        } else {
            ans.add(AttributeIO.MAPPING_NOT_PERSISTENT);
        }
        return ans;
    }

    public IIntOption getAttributeMapping(AttributeMetaData amd) {
        AttributeIO aio = (AttributeIO)amd.adapt(AttributeIO.class);
        if (aio == null) {
            return AttributeIO.MAPPING_NOT_PERSISTENT;
        }
        return aio.getMapping();
    }

    public void setAttributeMapping(AttributeMetaData amd, IIntOption op) {
        System.out.println("%%% setAttributeMapping " + amd + " = " + op);
        AttributeIO aio = (AttributeIO)amd.adapt(AttributeIO.class);
        if (aio != null && !op.equals(aio.getMapping())) {
            try {
                ++this.ignoreEvents;
                aio.setMapping((IntOption)op);
                this.updateMetaDataFromModel((Collection<EntityIO>)Collections.singleton(aio.getEntityIO()));
            }
            finally {
                --this.ignoreEvents;
            }
        }
    }

    public int[] getValidJdbcTypes(OrmColumn column) {
        return this.jdbcTypes;
    }

    public void setDatabaseDefinition(DatabaseDefinition definition) {
        this.dbdef = definition;
    }

    protected int[] getAllJdbcTypeInts() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        Field[] a = Types.class.getFields();
        int i = a.length - 1;
        while (i >= 0) {
            Field f = a[i];
            int m = f.getModifiers();
            if (Modifier.isFinal(m) && Modifier.isStatic(m)) {
                try {
                    Integer value = (Integer)f.get(null);
                    types.add(value);
                }
                catch (Exception exception) {}
            }
            --i;
        }
        Collections.sort(types);
        int[] intTypes = new int[types.size()];
        int x = 0;
        while (x < types.size()) {
            intTypes[x] = (Integer)types.get(x);
            ++x;
        }
        return intTypes;
    }

    public String getColumnDefinition(OrmColumn c) {
        int jdbcType = c.getJdbcType();
        VendorDef.JdbcTypeInfo info = this.vendorDef.getJdbcTypeInfo(jdbcType);
        PredefinedDataTypeDefinition typeDef = null;
        String typeName = null;
        if (info != null) {
            typeDef = info.dataTypeDef;
            typeName = info.dataTypeName;
        }
        return RdbUtils.getColumnDefinition((DatabaseDefinition)this.dbdef, (PredefinedDataTypeDefinition)typeDef, (String)typeName, (OrmColumn)c);
    }

    public PredefinedDataTypeDefinition getColumnDataTypeDefinition(OrmColumn c) {
        int jdbcType = c.getJdbcType();
        VendorDef.JdbcTypeInfo info = this.vendorDef.getJdbcTypeInfo(jdbcType);
        if (info != null) {
            return info.dataTypeDef;
        }
        return null;
    }

    public void updateDatabaseType(OrmColumn col) {
        col.setDatabaseType(this.getDatabaseType(col.getName(), col.getColumnDefinition()));
    }

    public String getDatabaseType(String name, String columnDefinition) {
        int i = columnDefinition.indexOf(name);
        if (i < 0) {
            return columnDefinition;
        }
        i += name.length();
        int j = columnDefinition.lastIndexOf("NOT NULL");
        if (j < 0) {
            j = columnDefinition.lastIndexOf("NULL");
        }
        String s = j > 0 ? columnDefinition.substring(i, j) : columnDefinition.substring(i);
        return s.trim();
    }

    protected Set<EntityIO> findDependentEntities(Collection<EntityIO> root) {
        int before;
        HashSet<EntityIO> ans = new HashSet<EntityIO>();
        ans.addAll(root);
        do {
            HashSet<EntityIO> extra = new HashSet<EntityIO>();
            for (EntityIO entityIO : ans) {
                extra.addAll(entityIO.getDependOnUs());
            }
            before = ans.size();
            ans.addAll(extra);
        } while (ans.size() != before);
        return ans;
    }

    public void updateModelFromMetaData(EntityIO entityIO, ElementChangedEvent event) {
        ArrayList<EntityIO> a = new ArrayList<EntityIO>(1);
        a.add(entityIO);
        this.updateModelFromMetaData(a, event, entityIO);
    }

    public void updateModelFromMetaData(Collection<EntityIO> todoCol) {
        this.updateModelFromMetaData(todoCol, null, null);
    }

    public void updateModelFromMetaData(EntityIO entityIO) {
        this.updateModelFromMetaData((Collection<EntityIO>)Collections.singleton(entityIO), null, null);
    }

    protected void updateModelFromMetaData(Collection<EntityIO> todoCol, ElementChangedEvent event, EntityIO eventTarget) {
        long start = System.currentTimeMillis();
        this.forMetaDataUpdate.clear();
        ArrayList<EntityIO> todo = new ArrayList<EntityIO>(this.findDependentEntities(todoCol));
        Collections.sort(todo);
        System.out.println("%%% updateModelFromMetaData " + todo);
        for (EntityIO entityIO : todo) {
            try {
                entityIO.updateModelFromMetaDataPre();
            }
            catch (Exception e) {
                OrmPlugin.log((String)entityIO.toString(), (Throwable)e);
            }
        }
        try {
            ++this.ignoreEvents;
            if (event != null) {
                eventTarget.renameAttributes(event);
            }
            this.astRClassFactory.begin();
            int pass = 1;
            while (true) {
                ArrayList<EntityIO> newTodo = new ArrayList<EntityIO>();
                boolean nothingChanged = true;
                int n = todo.size();
                int i = 0;
                while (i < n) {
                    EntityIO entityIO = (EntityIO)todo.get(i);
                    try {
                        RClass cls = this.astRClassFactory.findClass(entityIO.getType().getFullyQualifiedName(), false);
                        int oldStatus = entityIO.getModelUpdateStatus();
                        boolean changed = entityIO.updateModelFromMetaData(cls, eventTarget == entityIO);
                        int newStatus = entityIO.getModelUpdateStatus();
                        if (newStatus != 10) {
                            newTodo.add(entityIO);
                        }
                        if (changed || newStatus != oldStatus) {
                            nothingChanged = false;
                        }
                    }
                    catch (Exception e) {
                        OrmPlugin.log((String)entityIO.toString(), (Throwable)e);
                    }
                    ++i;
                }
                todo = newTodo;
                if (nothingChanged || todo.isEmpty()) break;
                ++pass;
            }
            for (EntityIO entityIO : todoCol) {
                try {
                    RClass cls = this.astRClassFactory.findClass(entityIO.getType().getFullyQualifiedName(), false);
                    entityIO.updateModelFromMetaDataPost(cls, todo.contains(entityIO));
                }
                catch (Exception e) {
                    OrmPlugin.log((String)entityIO.toString(), (Throwable)e);
                }
            }
            for (EntityIO entityIO : this.forMetaDataUpdate) {
                this.updateMetaDataFromModelImp(entityIO);
            }
            long ms = System.currentTimeMillis() - start;
            System.out.println("%%% updateModelFromMetaData DONE " + ms + " ms " + pass + " pass(es) " + todo);
        }
        finally {
            --this.ignoreEvents;
            this.astRClassFactory.finish();
        }
    }

    public void registerForMetaDataUpdate(EntityIO entityIO) {
        this.forMetaDataUpdate.add(entityIO);
    }

    public void updateMetaDataFromModel(Collection<EntityIO> todoCol) {
        if (!this.project.isOpen()) {
            return;
        }
        try {
            ++this.ignoreEvents;
            long start = System.currentTimeMillis();
            ArrayList<EntityIO> todo = new ArrayList<EntityIO>(todoCol);
            Collections.sort(todo);
            System.out.println("%%% updateMetaDataFromModel " + todo);
            for (EntityIO entityIO : todo) {
                this.updateMetaDataFromModelImp(entityIO);
            }
            long ms = System.currentTimeMillis() - start;
            System.out.println("%%% updateMetaDataFromModel DONE " + ms + " ms ");
            this.updateModelFromMetaData(todo);
        }
        finally {
            --this.ignoreEvents;
        }
    }

    protected void updateMetaDataFromModelImp(EntityIO entityIO) {
        AstRClassFactory f = this.getAstRClassFactory();
        f.begin(entityIO.getAstState());
        try {
            try {
                AstRClass cls = (AstRClass)f.findClass(entityIO.getType().getFullyQualifiedName(), true);
                ICompilationUnit typeCu = cls.getTypeCu();
                CompilationUnit root = cls.getRoot();
                root.recordModifications();
                IBuffer buffer = typeCu.getBuffer();
                IDocument doc = ((DocumentAdapter)buffer).getDocument();
                entityIO.updateMetaDataFromModel(cls);
                TextEdit edits = root.rewrite(doc, typeCu.getJavaProject().getOptions(true));
                IUndoManager undoManager = this.getUndoManager(entityIO.getType());
                try {
                    if (undoManager != null) {
                        undoManager.beginCompoundChange();
                    }
                    edits.apply(doc, 2);
                }
                finally {
                    if (undoManager != null) {
                        undoManager.endCompoundChange();
                    }
                }
                typeCu.reconcile(3, false, typeCu.getOwner(), null);
            }
            catch (Exception e) {
                OrmPlugin.log((Throwable)e);
            }
        }
        finally {
            f.finish();
            entityIO.setAstState(null);
        }
    }

    protected IUndoManager getUndoManager(IType type) {
        ISourceViewer v;
        IEditorPart ep = EditorUtility.isOpenInEditor((Object)type);
        if (ep instanceof JavaEditor && (v = ((JavaEditor)ep).getViewer()) instanceof TextViewer) {
            return ((TextViewer)v).getUndoManager();
        }
        return null;
    }

    public void notifyChanged(Notification no, EntityIO entityIO) {
        if (this.ignoreEvents > 0 || no.getEventType() == 8) {
            return;
        }
        if (this.startModelEventBatchCount == 0) {
            this.updateMetaDataFromModel((Collection<EntityIO>)Collections.singleton(entityIO));
        } else {
            this.batchSet.add(entityIO);
        }
    }

    public boolean isIgnoreEvents() {
        return this.ignoreEvents > 0;
    }

    public AttributeMetaData getAttributeMetaData(EntityMetaData emd, String name, boolean isMethod) {
        EntityIO entityIO;
        AttributeMetaData amd;
        if (isMethod) {
            if (!name.startsWith("get")) {
                return null;
            }
            name = Utils.getAttributeNameForMethod(name);
        }
        if ((amd = emd.findAttributeMetaData(name)) == null && (entityIO = EntityIO.get(emd)) != null && (amd = entityIO.getNonPeristentAttribute(name)) != null) {
            amd.registerAdapterFactory((IAdapterFactory)this);
        }
        return amd;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (IEntityModelManager.class.equals((Object)adapterType)) {
            return this;
        }
        if (IOptionsDescriptor.class.equals((Object)adapterType)) {
            return this.getEntityModel().adapt(IOptionsDescriptor.class);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IEntityModelManager.class, IOptionsDescriptor.class};
    }

    public List getPossibleElementTypes(CollectionAttribute collectionAttribute) {
        EList allTypes = this.getEntityModel().getTypeList();
        ArrayList<TypeMetaData> possibleTypes = new ArrayList<TypeMetaData>(allTypes.size());
        for (TypeMetaData type : allTypes) {
            if (!(type instanceof EntityMetaData)) continue;
            possibleTypes.add(type);
        }
        return possibleTypes;
    }

    public String getDefaultDiscriminatorValue(EntityMetaData emd) {
        return emd.getSchemaName();
    }

    public List getValidMappedByAttribute(AttributeMetaData amd) {
        AttributeIO aio = AttributeIO.get(amd);
        if (aio == null) {
            return Collections.EMPTY_LIST;
        }
        return aio.getValidMappedByAttributes();
    }

    public int getColumnPositionDiscriminator() {
        return this.columnPositionDiscriminator;
    }

    public int getColumnPositionPrimaryKey() {
        return this.columnPositionPrimaryKey;
    }

    public int getColumnPositionForeignKey() {
        return this.columnPositionForeignKey;
    }

    public int getColumnPositionVersion() {
        return this.columnPositionVersion;
    }

    public boolean isUseDiscriminatorColumnEnabled(EntityMetaData emd) {
        EntityIO entityIO = EntityIO.get(emd);
        return entityIO == null || entityIO.isUseDiscriminatorColumnEnabled();
    }

    public void setUseDiscriminatorColumn(EntityMetaData emd, boolean on) {
        EntityIO entityIO = EntityIO.get(emd);
        if (entityIO != null) {
            entityIO.setUseDiscriminatorColumn(on);
        }
    }

    public void executeModelChanges(Runnable runnable) {
        try {
            ++this.startModelEventBatchCount;
            this.batchSet.clear();
            runnable.run();
        }
        finally {
            --this.startModelEventBatchCount;
        }
        if (this.startModelEventBatchCount == 0) {
            this.updateMetaDataFromModel(this.batchSet);
            this.batchSet.clear();
        }
    }

    public String getDefaultTableName(String entityName) {
        return entityName.toUpperCase();
    }

    public String getDefaultJoinTableName(CollectionAttribute amd, OrmTable srcTable, OrmTable destTable) {
        return String.valueOf(srcTable.getName()) + "_" + destTable.getName();
    }

    public ColumnNameStrategy getJoinTableOwnerCNS(CollectionAttribute amd) {
        return USE_DEST_NAME;
    }

    public ColumnNameStrategy getJoinTableInverseCNS(CollectionAttribute amd) {
        return USE_DEST_NAME;
    }

    public ColumnNameStrategy getJoinedInheritanceCNS(EntityMetaData emd) {
        return USE_DEST_NAME;
    }

    public ColumnNameStrategy getReferenceCNS(final ReferenceAttribute amd) {
        return new ColumnNameStrategy(){

            public String getColumnName(OrmColumn dest) {
                return String.valueOf(amd.getName().toUpperCase()) + "_" + dest.getName();
            }
        };
    }

    public String getDefaultColumnName(BasicAttribute amd) {
        return amd.getName().toUpperCase();
    }

    public boolean isPossibleEntity(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return false;
        }
        try {
            IType t = this.project.getJavaProject().findType(fullyQualifiedName);
            return t != null && !t.isBinary() && t.isClass();
        }
        catch (JavaModelException e) {
            OrmPlugin.log((Throwable)e);
            return false;
        }
    }

    public boolean isValidPropertyName(String name) {
        return name.length() > 3 && name.startsWith("get");
    }

    public String checkValidAttribute(RAnnotatedElement attribute) {
        int m = attribute.getModifiers();
        if (Modifier.isStatic(m)) {
            return "May not be static";
        }
        if (Modifier.isFinal(m)) {
            return "May not be final";
        }
        if (Modifier.isTransient(m)) {
            return "May not be transient";
        }
        if (attribute instanceof RMethod) {
            RMethod method = (RMethod)attribute;
            if (!this.isValidPropertyName(method.getName())) {
                return "Name must follow getXXX pattern";
            }
            if (!method.hasNoParameters()) {
                return "Cannot have parameters";
            }
        }
        return null;
    }

    public boolean isUseMarkerAnnotations() {
        return this.useMarkerAnnotations;
    }

    public boolean isUsingIdentityColumns(EntityMetaData emd) {
        return emd.getIdGeneratorType() == 4;
    }

    public boolean isIdGeneratorEnabled(EntityMetaData emd) {
        return !emd.getPrimaryKeyList().isEmpty();
    }

    public List getPossibleEntityMappings(EntityMetaData emd) {
        ArrayList<IntOption> ans = new ArrayList<IntOption>();
        EntityIO entityIO = EntityIO.get(emd);
        if (entityIO == null) {
            ans.add(EntityIO.MAPPING_ENTITY);
            ans.add(EntityIO.MAPPING_EMBEDDABLE);
            ans.add(EntityIO.MAPPING_EMBEDDABLE_SUPERCLASS);
        } else {
            entityIO.getPossibleEntityMappings(ans);
        }
        return ans;
    }

    public IIntOption getEntityMapping(EntityMetaData emd) {
        EntityIO entityIO = EntityIO.get(emd);
        if (entityIO == null) {
            return EntityIO.MAPPING_NOT_PERSISTENT;
        }
        return entityIO.getEntityMapping();
    }

    public void setEntityMapping(EntityMetaData emd, IIntOption option) {
        System.out.println("$ setEntityMapping " + emd.getShortName() + " " + option);
        EntityIO entityIO = EntityIO.get(emd);
        if (entityIO != null) {
            if (EntityIO.MAPPING_NOT_PERSISTENT.equals((Object)option)) {
                try {
                    try {
                        ++this.ignoreEvents;
                        entityIO.setEntityMapping(option);
                        this.updateMetaDataFromModelImp(entityIO);
                        this.persistenceXmlManager.makeNotPersistent((Collection<EntityMetaData>)Collections.singleton(emd));
                    }
                    catch (Exception e) {
                        OrmPlugin.log((Throwable)e);
                    }
                }
                finally {
                    --this.ignoreEvents;
                }
            } else {
                entityIO.setEntityMapping(option);
            }
        }
    }

    public Set getExtraSqlObjects() {
        return null;
    }
}

