/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.core.internal.product;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jsr220orm.core.internal.product.OrmProduct;

public class OrmProductRegistry {
    public static final OrmProductRegistry INSTANCE = new OrmProductRegistry();
    private Map ormProductMap = new TreeMap();

    private OrmProductRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.jsr220orm", "product");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configurationElement = configElements[j];
                    if (configurationElement.getName().equals("product")) {
                        String id = configurationElement.getAttribute("id");
                        String name = configurationElement.getAttribute("name");
                        String version = configurationElement.getAttribute("version");
                        String vendor = configurationElement.getAttribute("vendor");
                        String emmName = configurationElement.getAttribute("entityModelManager");
                        String icon = configurationElement.getAttribute("icon");
                        OrmProduct ormProduct = new OrmProduct(id, name, version, vendor, emmName, icon, extension.getNamespace());
                        this.ormProductMap.put(id, ormProduct);
                        IConfigurationElement[] params = configurationElement.getChildren();
                        int p = 0;
                        while (p < params.length) {
                            IConfigurationElement param = params[p];
                            String key = param.getAttribute("key");
                            String value = param.getAttribute("value");
                            ormProduct.getProperties().put(key, value);
                            ++p;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public Collection getOrmProducts() {
        return this.ormProductMap.values();
    }

    public OrmProduct getOrmProductById(String productId) {
        return (OrmProduct)this.ormProductMap.get(productId);
    }

    public boolean containtsProductKey(String prodKey) {
        return this.ormProductMap.containsKey(prodKey);
    }
}

