/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.wizards;

import java.lang.reflect.Constructor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jsr220orm.core.internal.product.OrmProduct;
import org.eclipse.jsr220orm.ui.IProductActivationWizard;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.properties.SelectProductComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.osgi.framework.Bundle;

public class AddPersistencePage
extends WizardPage {
    private IProject project;
    private IJavaProject javaProject;
    private SelectProductComposite prodSelect;
    private Text fProjectField;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private IProductActivationWizard selectedWizard;
    static /* synthetic */ Class class$0;

    public AddPersistencePage() {
        super("addPersistence", "Add Persistence to project.", OrmUiPlugin.getImageDescriptor("icons/orm16.png"));
    }

    public void setIProject(IProject project) {
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        Label label = new Label(composite, 0);
        this.fProjectField = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.fProjectField.setLayoutData((Object)gridData);
        Button button = new Button(composite, 0);
        this.prodSelect = new SelectProductComposite(composite, true);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.prodSelect.setLayoutData(gridData);
        label.setText("Project");
        button.setText("Browse");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IJavaProject jproject = AddPersistencePage.this.chooseProject();
                if (jproject != null) {
                    IPath path = jproject.getProject().getFullPath().makeRelative();
                    AddPersistencePage.this.fProjectField.setText(path.toString());
                }
            }
        });
        this.fProjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPersistencePage.this.updateProjectStatus();
            }
        });
        if (this.project != null) {
            IPath path = this.project.getProject().getFullPath().makeRelative();
            this.fProjectField.setText(path.toString());
        }
    }

    private void updateProjectStatus() {
        IProject project = this.getIProjectFromText();
        if (this.prodSelect != null) {
            try {
                this.prodSelect.setProject(project);
            }
            catch (Exception e) {
                OrmUiPlugin.logException(e, "Problem loading presistence settings.", this.getShell());
            }
        }
    }

    private IProject getIProjectFromText() {
        if (this.fProjectField == null) {
            return null;
        }
        String str = this.fProjectField.getText();
        if (str.length() == 0) {
            this.setErrorMessage("Please select a project.");
            return null;
        }
        Path path = new Path(str);
        if (path.segmentCount() != 1) {
            this.setErrorMessage("Please select a valid project path.");
            return null;
        }
        IProject project = this.fWorkspaceRoot.getProject(path.toString());
        if (!project.exists()) {
            this.setErrorMessage("Project does not exists.");
            return null;
        }
        this.setErrorMessage(null);
        return project;
    }

    private IJavaProject chooseProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.fWorkspaceRoot).getJavaProjects();
        }
        catch (JavaModelException e) {
            OrmUiPlugin.logException(e, "Could not find Java Projects", this.getShell());
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Select a Project");
        dialog.setMessage("Select a Project");
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.javaProject});
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        OrmProduct selectedProduct = this.getSelectedProduct();
        return true;
    }

    public OrmProduct getSelectedProduct() {
        return this.prodSelect.getSelectedProduct();
    }

    public boolean performFinish() {
        if (this.selectedWizard != null && !this.selectedWizard.performFinish()) {
            return false;
        }
        return this.prodSelect.setProductOnProject();
    }

    public void flushProps() {
        this.prodSelect.flushProps();
    }

    public IWizardPage getNextPage() {
        this.flushProps();
        this.selectedWizard = this.getNextIWizard();
        if (this.selectedWizard != null) {
            return this.selectedWizard.getStartingPage();
        }
        return super.getNextPage();
    }

    private IProductActivationWizard getNextIWizard() {
        this.flushProps();
        OrmProduct ormProduct = this.getSelectedProduct();
        if (ormProduct == null) {
            return null;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.jsr220orm.ui", "productActivationWizard");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                if (extension.getNamespace().equals(ormProduct.getNamespace())) {
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configurationElement = configElements[j];
                        if (configurationElement.getName().equals("wizard")) {
                            String className = configurationElement.getAttribute("class");
                            try {
                                IProductActivationWizard activationPage;
                                Bundle bundle = Platform.getBundle((String)ormProduct.getNamespace());
                                Class clazz = bundle.loadClass(className);
                                try {
                                    activationPage = (IProductActivationWizard)clazz.newInstance();
                                }
                                catch (Exception e) {
                                    try {
                                        Constructor constructor = clazz.getConstructor(String.class);
                                        activationPage = (IProductActivationWizard)constructor.newInstance(ormProduct.getName());
                                    }
                                    catch (Exception exception) {
                                        throw e;
                                    }
                                }
                                activationPage.setIProject(this.project);
                                activationPage.addPages();
                                return activationPage;
                            }
                            catch (Exception e) {
                                String message = String.valueOf(className) + " could not be created.";
                                OrmUiPlugin.log((IStatus)new Status(4, OrmUiPlugin.getPluginId(), 0, message, (Throwable)e));
                                break;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.selectedWizard != null) {
            this.selectedWizard.dispose();
        }
    }

    public IProductActivationWizard getSelectedWizard() {
        return this.selectedWizard;
    }

    public boolean canFinish() {
        return this.selectedWizard == null || this.selectedWizard.canFinish();
    }
}

