/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.popup.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.internal.ddl.DdlGenerator;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEWizard;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class GenerateDdlAction
implements IObjectActionDelegate {
    private IProject project;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            OrmNature nature = (OrmNature)this.project.getNature("org.eclipse.jsr220orm.core.nature");
            OrmProject activeOrmProject = nature.getActiveOrmProject();
            IEntityModelManager modelManager = activeOrmProject.getModelManager();
            DatabaseDefinition dbDef = nature.getDatabaseDefinition();
            DdlGenerator ddlGenerator = new DdlGenerator(modelManager, dbDef);
            FEWizard wizard = new FEWizard(ddlGenerator.getCreateDDL());
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            Database database = nature.getActiveDatabase();
            if (database instanceof ICatalogObject) {
                ((ICatalogObject)database).refresh();
            }
        }
        catch (Exception e) {
            OrmUiPlugin.logException(e, "Could not generate DDL", null);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.project = (IProject)((StructuredSelection)selection).getFirstElement();
    }
}

