/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.edit;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.ui.internal.diagram.er.command.RdbColumnDragCommand;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ColumnEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.RdbColumnEditPart;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class RdbColumnDragPolicy
extends GraphicalEditPolicy {
    private EditPart host;
    private IFigure dragFigure;
    private IFigure targetFeedback;

    public void activate() {
    }

    public void deactivate() {
    }

    public void eraseSourceFeedback(Request request) {
        if (this.dragFigure != null) {
            this.removeFeedback(this.dragFigure);
        }
        this.clearTargetFeedback();
    }

    public void eraseTargetFeedback(Request request) {
    }

    public Command getCommand(Request request) {
        EditPart editPart = this.getTargetEditPart(request);
        if (editPart instanceof ColumnEditPart && this.host instanceof RdbColumnEditPart) {
            OrmColumn ormColumn = (OrmColumn)editPart.getModel();
            Column rdbColumn = (Column)this.host.getModel();
            RdbColumnDragCommand command = new RdbColumnDragCommand(ormColumn, rdbColumn);
            return command;
        }
        return null;
    }

    public EditPart getHost() {
        return this.host;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest request2 = (ChangeBoundsRequest)request;
            List children = this.getHost().getParent().getChildren();
            for (GraphicalEditPart editPart : children) {
                IFigure figure = editPart.getFigure();
                if (!figure.getBounds().contains(request2.getLocation())) continue;
                return editPart;
            }
        }
        return this.host;
    }

    public void setHost(EditPart editpart) {
        this.host = editpart;
    }

    public void showSourceFeedback(Request request) {
        IFigure figure = this.getDragFigure();
        ChangeBoundsRequest request2 = (ChangeBoundsRequest)request;
        figure.getSize();
        figure.setLocation(request2.getLocation().getTranslated(15, 0));
        this.addFeedback(figure);
        this.clearTargetFeedback();
        this.setTargetFeedBack(request);
    }

    private void setTargetFeedBack(Request request) {
        EditPart target = this.getTargetEditPart(request);
        if (target != null && target != this.host) {
            this.targetFeedback = ((AbstractGraphicalEditPart)target).getFigure();
            this.targetFeedback.setOpaque(true);
            this.targetFeedback.repaint();
        }
    }

    private void clearTargetFeedback() {
        if (this.targetFeedback != null) {
            this.targetFeedback.setOpaque(false);
            this.targetFeedback = null;
        }
    }

    public IFigure getDragFigure() {
        if (this.dragFigure == null) {
            RdbColumnEditPart rep = (RdbColumnEditPart)this.getHost();
            this.dragFigure = rep.createFigure();
            rep.refreshVisuals(this.dragFigure, rep.getModel());
            IFigure hostFigure = this.getHostFigure();
            this.dragFigure.setFont(hostFigure.getFont());
            this.dragFigure.setSize(this.dragFigure.getPreferredSize());
        }
        return this.dragFigure;
    }

    public void showTargetFeedback(Request request) {
    }

    public boolean understandsRequest(Request request) {
        return "move".equals(request.getType());
    }
}

