/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Table;
import org.eclipse.dali.core.impl.PersistenceProjectImpl;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.TableItemProvider;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TableComposite
extends Composite
implements IPersistenceComposite {
    private Table table;
    private TableItemProvider tableItemProvider;
    private INotifyChangedListener tableListener;
    protected EditingDomain editingDomain;
    protected Combo tableCombo;
    protected boolean populating;
    static /* synthetic */ Class class$0;

    public TableComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.tableItemProvider = (TableItemProvider)adapterFactory.createTableAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group columnGroup = new Group((Composite)this, 16);
        columnGroup.setText("Table");
        columnGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        columnGroup.setLayoutData((Object)gridData);
        Label tableLabel = new Label((Composite)columnGroup, 16384);
        tableLabel.setText("Name:");
        this.tableCombo = this.buildTableCombo((Composite)columnGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.setLayoutData((Object)gridData);
    }

    private Combo buildTableCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add("Default()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableComposite.this.populating) {
                    return;
                }
                String tableText = ((Combo)e.getSource()).getText();
                if (tableText.equals("")) {
                    tableText = null;
                    if (TableComposite.this.table.getSpecifiedName() == null || TableComposite.this.table.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (tableText != null && combo.getItemCount() > 0 && tableText.equals(combo.getItem(0))) {
                    tableText = null;
                }
                if (TableComposite.this.table.getSpecifiedName() == null || !TableComposite.this.table.getSpecifiedName().equals(tableText)) {
                    TableComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TableComposite.this.editingDomain, (Object)TableComposite.this.table, (Object)DaliPackage.eINSTANCE.getTable_SpecifiedName(), (Object)tableText));
                }
            }
        });
        return combo;
    }

    private INotifyChangedListener getTableListener() {
        if (this.tableListener == null) {
            this.tableListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    TableComposite.this.tableChanged(notification);
                }
            };
        }
        return this.tableListener;
    }

    protected void tableChanged(Notification notification) {
        if (notification.getFeatureID(Table.class) == 1) {
            final String tableName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (TableComposite.this.tableCombo.getText() == null || !TableComposite.this.tableCombo.getText().equals(tableName)) {
                        if (tableName == null) {
                            TableComposite.this.tableCombo.select(0);
                        } else {
                            TableComposite.this.tableCombo.setText(tableName);
                        }
                    }
                }
            });
        } else if (notification.getFeatureID(Table.class) == 0) {
            final String defaultTableName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    int selectionIndex = TableComposite.this.tableCombo.getSelectionIndex();
                    TableComposite.this.tableCombo.setItem(0, "Default (" + defaultTableName + ")");
                    if (selectionIndex == 0) {
                        TableComposite.this.tableCombo.select(0);
                    }
                }
            });
        }
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.table != null) {
            this.tableItemProvider.removeListener(this.getTableListener());
            this.table.eAdapters().remove((Object)this.tableItemProvider);
        }
        this.table = (Table)model;
        if (this.table == null) {
            return;
        }
        this.tableItemProvider.addListener(this.getTableListener());
        this.table.eAdapters().add((Object)this.tableItemProvider);
        this.populateTableCombo();
        this.populating = false;
    }

    private void populateTableCombo() {
        String tableName = this.table.getSpecifiedName();
        String defaultTableName = this.table.getDefaultName();
        this.tableCombo.setItem(0, "Default (" + defaultTableName + ")");
        PersistenceProjectImpl persistenceProject = this.table.getPersistenceProject();
        ConnectionInfoWrapper connectionInfo = persistenceProject.getConnectionInfo();
        if (connectionInfo.isConnected()) {
            this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
            Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)connectionInfo.userTableNames(persistenceProject.getSchemaName()))).iterator();
            while (i.hasNext()) {
                this.tableCombo.add((String)i.next());
            }
        }
        if (tableName != null) {
            if (!this.tableCombo.getText().equals(tableName)) {
                this.tableCombo.setText(tableName);
            }
        } else if (!this.tableCombo.getText().equals("Default (" + defaultTableName + ")")) {
            this.tableCombo.select(0);
        }
    }
}

