/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.impl;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.PersistenceContainer;
import org.eclipse.dali.core.PersistenceFile;
import org.eclipse.dali.core.PersistenceFolder;
import org.eclipse.dali.core.PersistenceResource;
import org.eclipse.dali.core.adapters.java.JavaPersistenceFileModelAdapter;
import org.eclipse.dali.core.impl.PersistenceFileImpl;
import org.eclipse.dali.core.impl.PersistenceFolderImpl;
import org.eclipse.dali.core.impl.PersistenceResourceImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PersistenceContainerImpl
extends PersistenceResourceImpl
implements PersistenceContainer {
    protected EList persistenceResources = null;
    static /* synthetic */ Class class$0;

    protected PersistenceContainerImpl() {
    }

    protected PersistenceContainerImpl(IResource resource) {
        super(resource);
    }

    protected EClass eStaticClass() {
        return DaliPackage.eINSTANCE.getPersistenceContainer();
    }

    public EList getPersistenceResources() {
        if (this.persistenceResources == null) {
            this.persistenceResources = new EObjectContainmentEList(PersistenceResource.class, (InternalEObject)this, 0);
        }
        return this.persistenceResources;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getPersistenceResources()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getPersistenceResources();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getPersistenceResources().clear();
                this.getPersistenceResources().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getPersistenceResources().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.persistenceResources != null && !this.persistenceResources.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    protected boolean buildInternalResources() {
        IResourceVisitor visitor = new IResourceVisitor(){
            private IResource currentResource;
            {
                this.currentResource = PersistenceContainerImpl.this.getResource();
            }

            public boolean visit(IResource resource) {
                if (resource.equals((Object)this.currentResource)) {
                    return true;
                }
                switch (resource.getType()) {
                    case 1: {
                        IFile file = (IFile)resource;
                        if (!"java".equals(file.getFileExtension())) break;
                        PersistenceContainerImpl.this.getPersistenceFile((IPath)new Path(file.getName()));
                        break;
                    }
                    case 2: {
                        IFolder folder = (IFolder)resource;
                        PersistenceFolderImpl pFolder = (PersistenceFolderImpl)PersistenceContainerImpl.this.getPersistenceFolder((IPath)new Path(folder.getName()));
                        if (pFolder.buildInternalResources()) break;
                        PersistenceContainerImpl.this.getPersistenceResources().remove((Object)pFolder);
                    }
                }
                return false;
            }
        };
        try {
            this.getResource().accept(visitor, 1, 0);
        }
        catch (CoreException ex) {
            DaliPlugin.log(ex);
        }
        return !this.getPersistenceResources().isEmpty();
    }

    protected boolean synchInternalResources(IResourceDelta delta) throws CoreException {
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){
            private IResource currentResource;
            {
                this.currentResource = PersistenceContainerImpl.this.getResource();
            }

            public boolean visit(IResourceDelta delta) throws CoreException {
                block14: {
                    IResource resource = delta.getResource();
                    if (resource.equals((Object)this.currentResource)) {
                        return true;
                    }
                    block0 : switch (resource.getType()) {
                        case 1: {
                            IFile file = (IFile)resource;
                            switch (delta.getKind()) {
                                case 1: {
                                    if (!"java".equals(file.getFileExtension())) break;
                                    PersistenceContainerImpl.this.getPersistenceFile((IPath)new Path(file.getName()));
                                    break;
                                }
                                case 2: {
                                    PersistenceFile pFile = PersistenceContainerImpl.this.getPersistenceFile((IPath)new Path(file.getName()));
                                    if (pFile == null) break;
                                    PersistenceContainerImpl.this.getPersistenceResources().remove((Object)pFile);
                                }
                            }
                            break;
                        }
                        case 2: {
                            IFolder folder = (IFolder)resource;
                            PersistenceFolderImpl pFolder = (PersistenceFolderImpl)PersistenceContainerImpl.this.getPersistenceFolder((IPath)new Path(folder.getName()));
                            switch (delta.getKind()) {
                                case 1: 
                                case 4: {
                                    if (!pFolder.synchInternalResources(delta)) {
                                        PersistenceContainerImpl.this.getPersistenceResources().remove((Object)pFolder);
                                        break block0;
                                    }
                                    break block14;
                                }
                                case 2: {
                                    PersistenceContainerImpl.this.getPersistenceResources().remove((Object)pFolder);
                                }
                            }
                        }
                    }
                }
                return false;
            }
        };
        delta.accept(visitor);
        return !this.getPersistenceResources().isEmpty();
    }

    public IContainer getContainer() {
        return (IContainer)this.getResource();
    }

    public PersistenceFolder getPersistenceFolder(IPath path) {
        if (path.isEmpty()) {
            return null;
        }
        IPath currentSegment = path.uptoSegment(1);
        IFolder currentFolder = this.getContainer().getFolder(currentSegment);
        IPath remainingPath = path.removeFirstSegments(1);
        for (PersistenceResource nextPResource : this.getPersistenceResources()) {
            if (!nextPResource.getResource().equals((Object)currentFolder)) continue;
            if (remainingPath.isEmpty()) {
                return (PersistenceFolder)nextPResource;
            }
            return ((PersistenceFolder)nextPResource).getPersistenceFolder(remainingPath);
        }
        PersistenceFolderImpl pFolder = new PersistenceFolderImpl(currentFolder);
        this.getPersistenceResources().add((Object)pFolder);
        if (remainingPath.isEmpty()) {
            return pFolder;
        }
        return pFolder.getPersistenceFolder(remainingPath);
    }

    public PersistenceFile getPersistenceFile(IPath path) {
        if (path.isEmpty()) {
            return null;
        }
        int segmentCount = path.segmentCount();
        IPath folderPath = path.removeLastSegments(1);
        IPath relativeFilePath = path.removeFirstSegments(segmentCount - 1);
        PersistenceContainer pContainer = this;
        if (segmentCount > 1) {
            pContainer = this.getPersistenceFolder(folderPath);
        }
        if (pContainer == null) {
            return null;
        }
        IFile file = pContainer.getContainer().getFile(relativeFilePath);
        for (PersistenceResource nextPResource : pContainer.getPersistenceResources()) {
            if (!nextPResource.getResource().equals((Object)file)) continue;
            return (PersistenceFile)nextPResource;
        }
        if (!"java".equals(file.getFileExtension())) {
            return null;
        }
        PersistenceFileImpl pFile = new PersistenceFileImpl(file, new JavaPersistenceFileModelAdapter());
        this.getPersistenceResources().add((Object)pFile);
        pFile.engageModel();
        return pFile;
    }
}

