/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.adapters.java.Type;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public abstract class Attribute
extends Member {
    private Type declaringType = new Type(this.getJDTMember().getDeclaringType());

    Attribute(IMember member) {
        super(member);
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    protected TypeDeclaration declaringTypeDeclaration(CompilationUnit astRoot) {
        return (TypeDeclaration)this.declaringType.bodyDeclaration(astRoot);
    }

    public boolean isField() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public abstract String getTypeSignature();

    public abstract boolean isPersistentAttributeFor(IMember var1);

    void setColumnName(final String columnName) {
        this.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.getAnnotation(bodyDeclaration, "Column");
                if (columnName == null) {
                    if (annotation != null) {
                        ASTTools.removeAnnotationElement(bodyDeclaration, "Column", "name");
                    }
                    return;
                }
                if (annotation == null) {
                    annotation = Attribute.this.addAnnotation("Column");
                }
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation normalAnnotation = null;
                if (annotation.isNormalAnnotation()) {
                    normalAnnotation = (NormalAnnotation)annotation;
                    for (MemberValuePair valuePair : normalAnnotation.values()) {
                        if (!valuePair.getName().getFullyQualifiedName().equals("name")) continue;
                        valuePair.setValue((Expression)ASTTools.newStringLiteral(ast, columnName));
                        return;
                    }
                } else {
                    normalAnnotation = ASTTools.newNormalAnnotation(ast, "Column");
                    ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)normalAnnotation);
                }
                MemberValuePair valuePair = ast.newMemberValuePair();
                valuePair.setName(ast.newSimpleName("name"));
                valuePair.setValue((Expression)ASTTools.newStringLiteral(ast, columnName));
                normalAnnotation.values().add(valuePair);
            }
        });
    }

    void setMappingAnnotationElementValuePair(final String mappingAnnotation, final String elementName, final String elementValueQualification, final String elementValue) {
        JDTTools.addImport(this.getJDTMember().getCompilationUnit(), "javax.persistence." + elementValueQualification);
        JDTTools.addImport(this.getJDTMember().getCompilationUnit(), "javax.persistence." + mappingAnnotation);
        this.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.getAnnotation(bodyDeclaration, mappingAnnotation);
                if (annotation == null) {
                    Attribute.this.addBasicAnnotation(bodyDeclaration, elementName, elementValueQualification, elementValue);
                } else {
                    AST ast = bodyDeclaration.getAST();
                    NormalAnnotation normalAnnotation = null;
                    if (annotation.isNormalAnnotation()) {
                        normalAnnotation = (NormalAnnotation)annotation;
                        for (MemberValuePair valuePair : normalAnnotation.values()) {
                            if (!valuePair.getName().getFullyQualifiedName().equals(elementName)) continue;
                            valuePair.setValue((Expression)ast.newQualifiedName(ast.newName(elementValueQualification), ast.newSimpleName(elementValue)));
                            return;
                        }
                    } else {
                        normalAnnotation = ASTTools.newNormalAnnotation(ast, mappingAnnotation);
                        ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)normalAnnotation);
                    }
                    Attribute.this.addValuePair(normalAnnotation, elementName, elementValueQualification, elementValue);
                }
            }
        });
    }

    void addValuePair(NormalAnnotation annotation, String elementName, String elementValueQualification, String elementValue) {
        AST ast = annotation.getAST();
        MemberValuePair valuePair = ast.newMemberValuePair();
        valuePair.setName(ast.newSimpleName(elementName));
        FieldAccess fieldAccess = ast.newFieldAccess();
        fieldAccess.setExpression((Expression)ast.newSimpleName(elementValueQualification));
        fieldAccess.setName(ast.newSimpleName(elementValue));
        valuePair.setValue((Expression)fieldAccess);
        ASTTools.addValuePair(annotation, valuePair);
    }

    void addBasicAnnotation(BodyDeclaration bodyDeclaration, String elementName, String elementValueQualification, String elementValue) {
        AST ast = bodyDeclaration.getAST();
        NormalAnnotation annotation = ASTTools.newNormalAnnotation(ast, "Basic");
        if (elementValue != null) {
            this.addValuePair(annotation, elementName, elementValueQualification, elementValue);
        }
        ASTTools.addAnnotation(bodyDeclaration, (Annotation)annotation);
    }

    public boolean isPrimitiveType() {
        return Signature.getTypeSignatureKind((String)this.getTypeSignature()) == 2;
    }

    public boolean typeIs(String fullyQualifiedTypeName) {
        String[][] resolvedTypes;
        String typeName = Signature.getSignatureSimpleName((String)this.getTypeSignature());
        if (this.isPrimitiveType()) {
            return typeName.equals(fullyQualifiedTypeName);
        }
        try {
            resolvedTypes = this.getJDTMember().getDeclaringType().resolveType(typeName);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
        if (resolvedTypes == null || resolvedTypes.length > 1) {
            return false;
        }
        String packageName = resolvedTypes[0][0];
        return fullyQualifiedTypeName.equals(String.valueOf(packageName) + "." + typeName);
    }
}

