package org.leagueplanet;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Servlet implementation class for Servlet: LoginServlet
 * 
 */
public class LoginServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {

	private static final long serialVersionUID = 1L;

	private User getUser(HttpServletRequest request) {

		// get the current session or create it
		HttpSession session = request.getSession(true);

		// get the user or create it and add it to the session
		User user = (User) session.getAttribute("user");
		if (user == null) {
			user = new User();
			session.setAttribute("user", user);
		}

		return user;
	}

	private void forward(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		User user = getUser(request);
		String url = user.isLoggedIn() ? "/logout.jsp" : "/login.jsp";

		ServletContext context = getServletContext();
		RequestDispatcher dispatcher = context.getRequestDispatcher(url);
		dispatcher.forward(request, response);
	}

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		forward(request, response);
	}

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		User user = getUser(request);

		String userId = request.getParameter("userId");
		if (userId == null)
			userId = "";
		request.setAttribute("userId", userId);

		String password = request.getParameter("password");
		if (password == null)
			password = "";

		String action = request.getParameter("action");
		if (action == null)
			action = "Login";

		if (action.equals("Logout")) {
			user.logOut();
		} else {
			if (userId.length() < 2) {
				request.setAttribute("userIdMessage",
						"User id must have at least 2 characters!");
			} else {
				if (!password.equals("guest")) {
					request.setAttribute("passwordMessage",
							"Wrong password! Try using: guest");
				} else {
					user.logIn(userId);
				}
			}
		}

		forward(request, response);
	}
}