/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.api.repository.IModelRepository;
import org.eclipse.vorto.core.api.repository.ModelRepositoryFactory;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.core.api.repository.RepositoryException;
import org.eclipse.vorto.core.ui.exception.ExceptionHandlerFactory;
import org.eclipse.vorto.perspective.contentprovider.ModelRepositoryContentProvider;
import org.eclipse.vorto.perspective.dnd.ModelDragListener;
import org.eclipse.vorto.perspective.labelprovider.ModelRepositoryLabelProvider;
import org.eclipse.vorto.perspective.view.GeneratorDialog;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;

public abstract class AbstractModelRepositoryViewPart
extends ViewPart {
    private static final String VERSION = "Version";
    private static final String NAME = "Name";
    private static final String NAMESPACE = "Namespace";
    private static final String DESCRIPTION = "Description";
    public static final String ID = "org.eclipse.vorto.perspective.views.ModelRepositoryViewPart";
    private TableViewer viewer;
    private Text searchField;

    protected abstract String getInfoModelEditorId();

    protected abstract String getFunctionblockEditorId();

    protected abstract String getDatatypeEditorId();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Button btnSearch = this.createSearchButton(parent);
        btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filter = AbstractModelRepositoryViewPart.this.searchField.getText();
                try {
                    AbstractModelRepositoryViewPart.this.viewer.setInput((Object)AbstractModelRepositoryViewPart.this.getModelRepo().search(filter));
                }
                catch (Exception ex) {
                    ExceptionHandlerFactory.getHandler().handle((Throwable)ex);
                }
            }
        });
        this.searchField = this.createSearchField(parent, btnSearch);
        this.searchField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    String filter = AbstractModelRepositoryViewPart.this.searchField.getText();
                    try {
                        AbstractModelRepositoryViewPart.this.viewer.setInput((Object)AbstractModelRepositoryViewPart.this.getModelRepo().search(filter));
                    }
                    catch (Exception ex) {
                        ExceptionHandlerFactory.getHandler().handle((Throwable)ex);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.viewer = this.createTableViewer(parent, btnSearch);
        this.initContextMenu();
    }

    private void initContextMenu() {
        final MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (AbstractModelRepositoryViewPart.this.viewer.getStructuredSelection().isEmpty()) {
                    return;
                }
                ModelResource model = (ModelResource)AbstractModelRepositoryViewPart.this.viewer.getStructuredSelection().getFirstElement();
                if (model.getId().getModelType() == ModelType.InformationModel || model.getId().getModelType() == ModelType.Functionblock) {
                    AbstractModelRepositoryViewPart.this.addListGeneratorsToMenu(manager, model);
                }
                menuMgr.add((IAction)new PreviewSharedModelAction(model));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.viewer.getControl().setMenu(menu);
    }

    protected void addListGeneratorsToMenu(IMenuManager contextMenu, final ModelResource model) {
        contextMenu.add((IAction)new Action("Generate code"){

            public void run() {
                try {
                    List codegens = AbstractModelRepositoryViewPart.this.getModelRepo().listGenerators();
                    GeneratorDialog dialog = new GeneratorDialog(new Shell(), model, codegens);
                    dialog.create();
                    dialog.open();
                }
                catch (Exception e) {
                    ExceptionHandlerFactory.getHandler().handle((Throwable)e);
                }
            }
        });
    }

    private TableViewer createTableViewer(Composite parent, Button btnSearch) {
        TableViewer viewer = new TableViewer(parent, 68354);
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment((Control)btnSearch, 2);
        fd_table.left = new FormAttachment((Control)this.searchField, 0, 16384);
        fd_table.bottom = new FormAttachment(100, -5);
        fd_table.right = new FormAttachment(100, -10);
        viewer.getTable().setLayoutData((Object)fd_table);
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        String[] columnLabels = new String[]{"", NAMESPACE, NAME, VERSION, DESCRIPTION};
        int[] columnBounds = new int[]{50, 300, 200, 100, 400};
        int i = 0;
        while (i < columnLabels.length) {
            this.createTableViewerColumn(viewer, columnLabels[i], columnBounds[i]);
            ++i;
        }
        viewer.setContentProvider((IContentProvider)new ModelRepositoryContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ModelRepositoryLabelProvider());
        viewer.setSorter((ViewerSorter)new NameSorter());
        viewer.setInput((Object)this.getViewSite());
        viewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ModelDragListener((StructuredViewer)viewer));
        return viewer;
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private Text createSearchField(Composite parent, Button btnSearch) {
        Text field = new Text(parent, 2048);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 23);
        formData.right = new FormAttachment((Control)btnSearch, -10);
        field.setLayoutData((Object)formData);
        return field;
    }

    private Button createSearchButton(Composite parent) {
        Button button = new Button(parent, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(100, -110);
        formData.right = new FormAttachment(100, -10);
        button.setLayoutData((Object)formData);
        button.setText("Search");
        return button;
    }

    private IModelRepository getModelRepo() {
        return ModelRepositoryFactory.getModelRepository();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private class PreviewSharedModelAction
    extends Action {
        private IWorkbenchPage page;
        private ModelResource model;

        PreviewSharedModelAction(ModelResource model) {
            super("Preview model");
            this.page = Objects.requireNonNull(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
            this.model = Objects.requireNonNull(model);
        }

        public void run() {
            try {
                File file = File.createTempFile(this.model.getDisplayName(), this.model.getId().getModelType().getExtension());
                Files.write((byte[])AbstractModelRepositoryViewPart.this.getModelRepo().downloadContent(this.model.getId()), (File)file);
                IEditorPart editor = this.openFileInEditor(this.page, file, this.model.getId().getModelType());
                if (editor != null) {
                    this.page.addPartListener(this.onEditorCloseListener(this.page, (IWorkbenchPart)editor, file));
                }
            }
            catch (RepositoryException e) {
                ExceptionHandlerFactory.getHandler().handle((Throwable)e);
            }
            catch (IOException e) {
                ExceptionHandlerFactory.getHandler().handle((Throwable)new RuntimeException("Error downloading content from repository.", e));
            }
        }

        private IPartListener onEditorCloseListener(final IWorkbenchPage page, final IWorkbenchPart editor, final File file) {
            return new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    if (part.equals(editor) && file.delete()) {
                        page.removePartListener((IPartListener)this);
                    }
                }
            };
        }

        private IEditorPart openFileInEditor(IWorkbenchPage page, File file, ModelType modelType) {
            if (file.exists()) {
                try {
                    return IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new XtextReadonlyEditorInput((IStorage)new LocalFileStorage(file)), (String)this.getEditorId(modelType), (boolean)true);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        private String getEditorId(ModelType modelType) {
            if (modelType == ModelType.Datatype) {
                return AbstractModelRepositoryViewPart.this.getDatatypeEditorId();
            }
            if (modelType == ModelType.Functionblock) {
                return AbstractModelRepositoryViewPart.this.getFunctionblockEditorId();
            }
            return AbstractModelRepositoryViewPart.this.getInfoModelEditorId();
        }
    }
}

