/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.openejb.resource.jdbc.logging.AbstractSQLLogger;
import org.apache.openejb.resource.jdbc.logging.TimeWatcherExecutor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class LoggingPreparedSqlStatement
extends AbstractSQLLogger
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_SQL, LoggingPreparedSqlStatement.class);
    private final PreparedStatement delegate;
    private final String sql;
    private final List<Parameter> parameters = new ArrayList<Parameter>();

    public LoggingPreparedSqlStatement(PreparedStatement result, String query) {
        this.delegate = result;
        this.sql = query;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mtdName = method.getName();
        boolean execute = mtdName.startsWith("execute");
        TimeWatcherExecutor.TimerWatcherResult result = TimeWatcherExecutor.execute(method, this.delegate, args, execute);
        if (mtdName.startsWith("set") && args.length >= 2 && (args[0].getClass().equals(Integer.TYPE) || args[0].getClass().equals(Integer.class))) {
            this.parameters.add(new Parameter(mtdName.substring(3), (Integer)args[0], args[1]));
        } else if (execute) {
            String str = this.sql;
            if (str.contains("?")) {
                Collections.sort(this.parameters);
                for (Parameter param : this.parameters) {
                    try {
                        str = str.replaceFirst("\\?", param.value.toString());
                    }
                    catch (Exception e) {
                        str = str.replaceFirst("\\?", param.value.getClass().getName());
                    }
                }
            }
            LOGGER.info(this.format(str, result.getDuration()));
        }
        return result.getResult();
    }

    protected static class Parameter
    implements Comparable<Parameter> {
        private String type;
        private int key;
        private Object value;

        public Parameter(String type, int key, Object value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Parameter o) {
            return this.key - o.key;
        }

        public String toString() {
            return this.value + " (" + this.type + ")";
        }
    }
}

