/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.extender.internal.blueprint.activator;

import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextEventMulticaster;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextListener;
import org.eclipse.gemini.blueprint.extender.internal.activator.ApplicationContextConfigurationFactory;
import org.eclipse.gemini.blueprint.extender.internal.activator.ContextLoaderListener;
import org.eclipse.gemini.blueprint.extender.internal.activator.OsgiContextProcessor;
import org.eclipse.gemini.blueprint.extender.internal.activator.TypeCompatibilityChecker;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.BlueprintContainerProcessor;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.BlueprintListenerManager;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.BlueprintTypeCompatibilityChecker;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.support.BlueprintContainerConfig;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.activator.support.BlueprintExtenderConfiguration;
import org.eclipse.gemini.blueprint.extender.internal.blueprint.event.EventAdminDispatcher;
import org.eclipse.gemini.blueprint.extender.internal.support.ExtenderConfiguration;
import org.eclipse.gemini.blueprint.extender.support.ApplicationContextConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BlueprintLoaderListener
extends ContextLoaderListener {
    private volatile EventAdminDispatcher dispatcher;
    private volatile BlueprintListenerManager listenerManager;
    private volatile Bundle bundle;
    private volatile BlueprintContainerProcessor contextProcessor;
    private volatile TypeCompatibilityChecker typeChecker;

    public void start(BundleContext context) throws Exception {
        this.listenerManager = new BlueprintListenerManager(context);
        this.dispatcher = new EventAdminDispatcher(context);
        this.bundle = context.getBundle();
        this.contextProcessor = new BlueprintContainerProcessor(this.dispatcher, this.listenerManager, this.bundle);
        this.typeChecker = new BlueprintTypeCompatibilityChecker(this.bundle);
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.listenerManager.destroy();
    }

    protected ExtenderConfiguration initExtenderConfiguration(BundleContext bundleContext) {
        return new BlueprintExtenderConfiguration(bundleContext, this.log);
    }

    protected ApplicationContextConfigurationFactory createContextConfigFactory() {
        return new ApplicationContextConfigurationFactory(){

            public ApplicationContextConfiguration createConfiguration(Bundle bundle) {
                return new BlueprintContainerConfig(bundle);
            }
        };
    }

    protected OsgiContextProcessor createContextProcessor() {
        return this.contextProcessor;
    }

    protected TypeCompatibilityChecker getTypeCompatibilityChecker() {
        return this.typeChecker;
    }

    protected String getManagedBundleExtenderVersionHeader() {
        return "BlueprintExtender-Version";
    }

    protected void addApplicationListener(OsgiBundleApplicationContextEventMulticaster multicaster) {
        super.addApplicationListener(multicaster);
        multicaster.addApplicationListener((OsgiBundleApplicationContextListener)this.contextProcessor);
    }

    protected ApplicationContextConfiguration createContextConfig(Bundle bundle) {
        return new BlueprintContainerConfig(bundle);
    }
}

