/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class Item {
    private final String name;
    private final String description;
    private final OpenType type;

    public Item(String name, String description, OpenType type, String ... restrictions) {
        this.name = name;
        this.description = description;
        this.type = type;
    }

    public static TabularType tabularType(String name, String description, CompositeType rowType, String ... index) {
        try {
            return new TabularType(name, description, rowType, index);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompositeType compositeType(String name, String description, Item ... items) {
        return Item.extend(null, name, description, items);
    }

    public static ArrayType arrayType(int dim, OpenType elementType) {
        try {
            return new ArrayType(dim, elementType);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompositeType extend(CompositeType parent, String name, String description, Item ... items) {
        LinkedHashSet<Item> all = new LinkedHashSet<Item>();
        if (parent != null) {
            Iterator<String> i$ = parent.keySet().iterator();
            while (i$.hasNext()) {
                String nm;
                String key = nm = i$.next();
                all.add(new Item(key, parent.getDescription(key), parent.getType(key), new String[0]));
            }
        }
        Collections.addAll(all, items);
        int size = all.size();
        String[] names = new String[size];
        String[] descriptions = new String[size];
        OpenType[] types = new OpenType[size];
        int m = 0;
        for (Item item : all) {
            names[m] = item.name;
            descriptions[m] = item.description;
            types[m] = item.type;
            ++m;
        }
        try {
            return new CompositeType(name, description, names, descriptions, types);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

