/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.correction.AbstractPDEMarkerResolution;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class BundleQuickAssistAssistant
extends QuickAssistAssistant {
    private final Image createImage;
    private final Image renameImage;
    private final Image removeImage;

    public BundleQuickAssistAssistant() {
        this.setQuickAssistProcessor(new BundleQuickAssistProcessor());
        this.createImage = PDEPluginImages.DESC_ADD_ATT.createImage();
        this.removeImage = PDEPluginImages.DESC_DELETE.createImage();
        this.renameImage = PDEPluginImages.DESC_REFRESH.createImage();
    }

    public void dispose() {
        this.createImage.dispose();
        this.removeImage.dispose();
        this.renameImage.dispose();
    }

    class BundleCompletionProposal
    implements ICompletionProposal {
        Position position;
        IMarkerResolution resolution;
        IMarker marker;

        public BundleCompletionProposal(IMarkerResolution resolution, Position pos, IMarker marker) {
            this.position = pos;
            this.resolution = resolution;
            this.marker = marker;
        }

        public void apply(IDocument document) {
            this.resolution.run(this.marker);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.position.offset, 0);
        }

        public String getAdditionalProposalInfo() {
            if (this.resolution instanceof AbstractPDEMarkerResolution) {
                return ((AbstractPDEMarkerResolution)this.resolution).getDescription();
            }
            return null;
        }

        public String getDisplayString() {
            return this.resolution.getLabel();
        }

        public Image getImage() {
            if (this.resolution instanceof AbstractPDEMarkerResolution) {
                switch (((AbstractPDEMarkerResolution)this.resolution).getType()) {
                    case 1: {
                        return BundleQuickAssistAssistant.this.createImage;
                    }
                    case 3: {
                        return BundleQuickAssistAssistant.this.removeImage;
                    }
                    case 2: {
                        return BundleQuickAssistAssistant.this.renameImage;
                    }
                }
            }
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }

    class BundleQuickAssistProcessor
    implements IQuickAssistProcessor {
        Map<IMarker, IMarkerResolution[]> resolutionMap = new HashMap<IMarker, IMarkerResolution[]>();

        BundleQuickAssistProcessor() {
        }

        public String getErrorMessage() {
            return null;
        }

        public boolean canFix(Annotation annotation) {
            boolean canFix;
            if (!(annotation instanceof MarkerAnnotation)) {
                return false;
            }
            IMarker marker = ((MarkerAnnotation)annotation).getMarker();
            IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
            boolean bl = canFix = resolutions.length > 0;
            if (canFix && !this.resolutionMap.containsKey(marker)) {
                this.resolutionMap.put(marker, resolutions);
            }
            return canFix;
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            return false;
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            IAnnotationModel amodel = invocationContext.getSourceViewer().getAnnotationModel();
            IDocument doc = invocationContext.getSourceViewer().getDocument();
            int offset = invocationContext.getOffset();
            Iterator it = amodel.getAnnotationIterator();
            ArrayList<BundleCompletionProposal> list = new ArrayList<BundleCompletionProposal>();
            while (it.hasNext()) {
                MarkerAnnotation annotation;
                IMarker marker;
                IMarkerResolution[] mapping;
                Object key = it.next();
                if (!(key instanceof MarkerAnnotation) || (mapping = this.resolutionMap.get(marker = (annotation = (MarkerAnnotation)key).getMarker())) == null) continue;
                Position pos = amodel.getPosition((Annotation)annotation);
                try {
                    int line = doc.getLineOfOffset(pos.getOffset());
                    int start = pos.getOffset();
                    String delim = doc.getLineDelimiter(line);
                    int delimLength = delim != null ? delim.length() : 0;
                    int end = doc.getLineLength(line) + start - delimLength;
                    if (offset < start || offset > end) continue;
                    IMarkerResolution[] iMarkerResolutionArray = mapping;
                    int n = mapping.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarkerResolution element = iMarkerResolutionArray[n2];
                        list.add(new BundleCompletionProposal(element, pos, marker));
                        ++n2;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return list.toArray(new ICompletionProposal[list.size()]);
        }
    }
}

