/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.virgo.bundlor.EntryScannerListener;
import org.eclipse.virgo.bundlor.support.partialmanifest.StandardReadablePartialManifest;

public final class IncrementalReadablePartialManifest
extends StandardReadablePartialManifest
implements EntryScannerListener {
    private final Map<String, TypeDependencies> recordedTypeDependencies = new HashMap<String, TypeDependencies>();
    private final Stack<String> currentlyAnalysedEntries = new Stack();

    public void recordReferencedType(String fullyQualifiedTypeName) {
        TypeDependencies typeDependencies = this.createTypeDependencies(null);
        if (typeDependencies != null) {
            typeDependencies.addImportedType(fullyQualifiedTypeName);
        }
        super.recordReferencedType(fullyQualifiedTypeName);
    }

    public void recordReferencedPackage(String fullyQualifiedPackageName) {
        TypeDependencies typeDependencies = this.createTypeDependencies(null);
        if (typeDependencies != null) {
            typeDependencies.addImportedPackage(fullyQualifiedPackageName);
        }
        super.recordReferencedPackage(fullyQualifiedPackageName);
    }

    public void recordType(String fullyQualifiedTypeName) {
        this.createTypeDependencies(fullyQualifiedTypeName);
        super.recordType(fullyQualifiedTypeName);
    }

    public void recordUsesPackage(String usingPackage, String usedPackage) {
        TypeDependencies typeDependencies = this.createTypeDependencies(null);
        if (typeDependencies != null) {
            typeDependencies.addUses(usingPackage, usedPackage);
        }
        super.recordUsesPackage(usingPackage, usedPackage);
    }

    private void unrecordType() {
        String currentEntry = this.currentEntry();
        if (this.recordedTypeDependencies.containsKey(currentEntry)) {
            TypeDependencies existingTypeDependencies = this.recordedTypeDependencies.get(currentEntry);
            String fullyQualifiedTypeName = existingTypeDependencies.getFullQualifiedTypeName();
            this.recordedTypeDependencies.remove(currentEntry);
            String oldPackageName = IncrementalReadablePartialManifest.getPackageName((String)fullyQualifiedTypeName);
            this.unrecordType(fullyQualifiedTypeName);
            boolean otherTypes = false;
            for (TypeDependencies typeDependencies : this.recordedTypeDependencies.values()) {
                String existingPackageName = IncrementalReadablePartialManifest.getPackageName((String)typeDependencies.getFullQualifiedTypeName());
                if (existingPackageName == null || !existingPackageName.equals(oldPackageName)) continue;
                otherTypes = true;
                break;
            }
            if (!otherTypes && oldPackageName != null) {
                this.unrecordExportPackage(oldPackageName);
            }
            for (String string : existingTypeDependencies.getImportedTypes()) {
                boolean otherImports = false;
                block2: for (TypeDependencies existingTypePartialManifest : this.recordedTypeDependencies.values()) {
                    for (String existingImportedType : existingTypePartialManifest.getImportedTypes()) {
                        if (!string.equals(existingImportedType)) continue;
                        otherImports = true;
                        continue block2;
                    }
                }
                if (otherImports) continue;
                this.removeImportedType(string);
            }
            for (String string : existingTypeDependencies.getReferencedPackages()) {
                boolean otherReferences = false;
                block5: for (TypeDependencies existingTypePartialManifest : this.recordedTypeDependencies.values()) {
                    for (String existingReferencedPackage : existingTypePartialManifest.getReferencedPackages()) {
                        if (!string.equals(existingReferencedPackage)) continue;
                        otherReferences = true;
                        continue block5;
                    }
                }
                if (otherReferences) continue;
                this.removeReferencedPackage(string);
            }
            for (Map.Entry entry : existingTypeDependencies.getUses().entrySet()) {
                for (TypeDependencies existingTypePartialManifest : this.recordedTypeDependencies.values()) {
                    for (Map.Entry<String, Set<String>> existingUses : existingTypePartialManifest.getUses().entrySet()) {
                        if (!existingUses.getKey().equals(entry.getKey())) continue;
                        ((Set)entry.getValue()).removeAll((Collection)existingUses.getValue());
                    }
                }
                this.removeUses((String)entry.getKey(), (Set)entry.getValue());
            }
        }
    }

    private TypeDependencies createTypeDependencies(String fullyQualifiedClassName) {
        String currentEntry = this.currentEntry();
        if (this.recordedTypeDependencies.containsKey(currentEntry)) {
            return this.recordedTypeDependencies.get(currentEntry);
        }
        TypeDependencies typeDependency = new TypeDependencies(fullyQualifiedClassName);
        this.recordedTypeDependencies.put(currentEntry, typeDependency);
        return typeDependency;
    }

    public void onBeginEntry(String name) {
        name = name.replace('\\', '/');
        this.currentlyAnalysedEntries.push(name);
        this.unrecordType();
    }

    public void onEndEntry() {
        this.currentlyAnalysedEntries.pop();
    }

    public String currentEntry() {
        if (!this.currentlyAnalysedEntries.isEmpty()) {
            return this.currentlyAnalysedEntries.peek();
        }
        return "template.mf";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypeDependencies {
        private final String fullQualifiedTypeName;
        private final Set<String> importedTypes = new HashSet<String>();
        private final Set<String> referencedPackages = new TreeSet<String>();
        private final Map<String, Set<String>> uses = new HashMap<String, Set<String>>();

        public TypeDependencies(String fullQualifiedTypeName) {
            this.fullQualifiedTypeName = fullQualifiedTypeName;
        }

        void addImportedType(String fullyQualifiedTypeName) {
            if (fullyQualifiedTypeName != null) {
                this.importedTypes.add(fullyQualifiedTypeName);
            }
        }

        void addUses(String usingPackage, String usedPackage) {
            if (IncrementalReadablePartialManifest.this.isRecordablePackage(usingPackage) && IncrementalReadablePartialManifest.this.isRecordablePackage(usedPackage) && !usingPackage.equals(usedPackage)) {
                Set<String> usesSet = this.getUsesSet(usingPackage);
                usesSet.add(usedPackage);
            }
        }

        void addImportedPackage(String importedPackage) {
            if (importedPackage != null && IncrementalReadablePartialManifest.this.isRecordablePackage(importedPackage)) {
                this.referencedPackages.add(importedPackage);
            }
        }

        private Set<String> getUsesSet(String exportingPackage) {
            Set<String> usesSet = this.uses.get(exportingPackage);
            if (usesSet == null) {
                usesSet = new TreeSet<String>();
                this.uses.put(exportingPackage, usesSet);
            }
            return usesSet;
        }

        String getFullQualifiedTypeName() {
            return this.fullQualifiedTypeName;
        }

        Set<String> getImportedTypes() {
            return this.importedTypes;
        }

        Set<String> getReferencedPackages() {
            return this.referencedPackages;
        }

        Map<String, Set<String>> getUses() {
            return this.uses;
        }
    }
}

