/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.emf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.emf.types.BaseEMFTypeKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassUnscopedTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.AbstractQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.InputKeyImplication;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;

public final class EMFQueryMetaContext
extends AbstractQueryMetaContext {
    public static final EMFQueryMetaContext DEFAULT = new EMFQueryMetaContext(false, true, UnscopedTypeSupport.EMIT_ALWAYS);
    public static final EMFQueryMetaContext DEFAULT_SURROGATE = new EMFQueryMetaContext(false, true, UnscopedTypeSupport.EMIT_EXCEPT_AS_WEAKENED_REPLACEMENT);
    private static final EClass EOBJECT_CLASS = EcorePackage.eINSTANCE.getEObject();
    private static final EClassTransitiveInstancesKey EOBJECT_SCOPED_KEY = new EClassTransitiveInstancesKey(EOBJECT_CLASS);
    private static final EClassUnscopedTransitiveInstancesKey EOBJECT_UNSCOPED_KEY = new EClassUnscopedTransitiveInstancesKey(EOBJECT_CLASS);
    private boolean assumeNonDangling;
    private boolean subResourceScopeSplit;
    private UnscopedTypeSupport emitUnscopedEClassTypes;
    private static final Comparator<IInputKey> SUGGESTED_ELIMINATION_ORDERING = new Comparator<IInputKey>(){

        @Override
        public int compare(IInputKey o1, IInputKey o2) {
            if (o1 instanceof EClassTransitiveInstancesKey && o2 instanceof EClassTransitiveInstancesKey) {
                return this.getRarity((EClassTransitiveInstancesKey)o1) - this.getRarity((EClassTransitiveInstancesKey)o2);
            }
            return this.getKeyTypeEliminationSequence(o1) - this.getKeyTypeEliminationSequence(o2);
        }

        private int getRarity(EClassTransitiveInstancesKey key) {
            return ((EClass)key.getEmfKey()).getEAllSuperTypes().size() + (EOBJECT_SCOPED_KEY.equals((Object)key) ? 0 : 1);
        }

        private int getKeyTypeEliminationSequence(IInputKey o1) {
            return o1 instanceof EClassTransitiveInstancesKey ? -1 : 0;
        }
    };

    EMFQueryMetaContext(boolean assumeNonDangling, boolean subResourceScopeSplit, UnscopedTypeSupport emitUnscopedEClassTypes) {
        this.assumeNonDangling = assumeNonDangling;
        this.subResourceScopeSplit = subResourceScopeSplit;
        this.emitUnscopedEClassTypes = emitUnscopedEClassTypes;
    }

    public EMFQueryMetaContext(EMFScope scope) {
        this(scope.getOptions().isDanglingFreeAssumption(), scope.getScopeRoots().size() == 1 && scope.getScopeRoots().iterator().next() instanceof EObject, UnscopedTypeSupport.EMIT_ALWAYS);
    }

    public boolean isEnumerable(IInputKey key) {
        this.ensureValidKey(key);
        return key.isEnumerable();
    }

    public boolean canLeadOutOfScope(IInputKey key) {
        EStructuralFeature feature;
        this.ensureValidKey(key);
        if (key instanceof EStructuralFeatureInstancesKey && (feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey()) instanceof EReference) {
            return this.canLeadOutOfScope((EReference)feature);
        }
        return false;
    }

    public boolean canLeadOutOfScope(EReference reference) {
        return !this.assumeNonDangling && (reference.isResolveProxies() || this.subResourceScopeSplit && !reference.isContainment());
    }

    public boolean isStateless(IInputKey key) {
        this.ensureValidKey(key);
        return key instanceof JavaTransitiveInstancesKey || key instanceof EClassUnscopedTransitiveInstancesKey;
    }

    public Map<Set<Integer>, Set<Integer>> getFunctionalDependencies(IInputKey key) {
        this.ensureValidKey(key);
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            HashMap<Set<Integer>, Set<Integer>> result = new HashMap<Set<Integer>, Set<Integer>>();
            if (this.isFeatureMultiplicityToOne(feature)) {
                result.put(Collections.singleton(0), Collections.singleton(1));
            }
            if (this.isFeatureMultiplicityOneTo(feature)) {
                result.put(Collections.singleton(1), Collections.singleton(0));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public EClassTransitiveInstancesKey getSourceTypeKey(EStructuralFeatureInstancesKey key) {
        return new EClassTransitiveInstancesKey(((EStructuralFeature)key.getEmfKey()).getEContainingClass());
    }

    public IInputKey getTargetTypeKey(EStructuralFeatureInstancesKey key) {
        EStructuralFeature feature = (EStructuralFeature)key.getEmfKey();
        if (feature instanceof EAttribute) {
            return new EDataTypeInSlotsKey(((EAttribute)feature).getEAttributeType());
        }
        if (feature instanceof EReference) {
            EClass eReferenceType = ((EReference)feature).getEReferenceType();
            if (this.canLeadOutOfScope((IInputKey)key)) {
                return new EClassUnscopedTransitiveInstancesKey(eReferenceType);
            }
            return new EClassTransitiveInstancesKey(eReferenceType);
        }
        throw new IllegalArgumentException();
    }

    public Collection<InputKeyImplication> getImplications(IInputKey implyingKey) {
        this.ensureValidKey(implyingKey);
        HashSet<InputKeyImplication> result = new HashSet<InputKeyImplication>();
        if (implyingKey instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)implyingKey).getEmfKey();
            EList directSuperTypes = eClass.getESuperTypes();
            if (!directSuperTypes.isEmpty()) {
                for (EClass superType : directSuperTypes) {
                    EClassTransitiveInstancesKey implied = new EClassTransitiveInstancesKey(superType);
                    result.add(new InputKeyImplication(implyingKey, (IInputKey)implied, Arrays.asList(0)));
                }
            } else if (!EOBJECT_SCOPED_KEY.equals(implyingKey)) {
                result.add(new InputKeyImplication(implyingKey, (IInputKey)EOBJECT_SCOPED_KEY, Arrays.asList(0)));
            }
            if (UnscopedTypeSupport.EMIT_NEVER != this.emitUnscopedEClassTypes) {
                result.add(new InputKeyImplication(implyingKey, (IInputKey)new EClassUnscopedTransitiveInstancesKey(eClass), Arrays.asList(0)));
            }
        } else if (implyingKey instanceof EClassUnscopedTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassUnscopedTransitiveInstancesKey)implyingKey).getEmfKey();
            EList directSuperTypes = eClass.getESuperTypes();
            if (!directSuperTypes.isEmpty()) {
                for (EClass superType : directSuperTypes) {
                    EClassUnscopedTransitiveInstancesKey implied = new EClassUnscopedTransitiveInstancesKey(superType);
                    result.add(new InputKeyImplication(implyingKey, (IInputKey)implied, Arrays.asList(0)));
                }
            } else if (!EOBJECT_UNSCOPED_KEY.equals(implyingKey)) {
                result.add(new InputKeyImplication(implyingKey, (IInputKey)EOBJECT_UNSCOPED_KEY, Arrays.asList(0)));
            }
        } else if (implyingKey instanceof JavaTransitiveInstancesKey) {
            Class instanceClass = ((JavaTransitiveInstancesKey)implyingKey).getInstanceClass();
            if (instanceClass != null) {
                Class superclass = instanceClass.getSuperclass();
                if (superclass != null) {
                    JavaTransitiveInstancesKey impliedSuper = new JavaTransitiveInstancesKey(superclass);
                    result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedSuper, Arrays.asList(0)));
                }
                Class<?>[] classArray = instanceClass.getInterfaces();
                int implied = classArray.length;
                int n = 0;
                while (n < implied) {
                    Class<?> superInterface = classArray[n];
                    if (superInterface != null) {
                        JavaTransitiveInstancesKey impliedInterface = new JavaTransitiveInstancesKey(superInterface);
                        result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedInterface, Arrays.asList(0)));
                    }
                    ++n;
                }
            }
        } else if (implyingKey instanceof EStructuralFeatureInstancesKey) {
            EReference opposite;
            EReference reference;
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)implyingKey).getEmfKey();
            EClass sourceType = this.featureSourceType(feature);
            EClassTransitiveInstancesKey impliedSource = new EClassTransitiveInstancesKey(sourceType);
            EClassifier targetType = this.featureTargetType(feature);
            BaseEMFTypeKey impliedTarget = feature instanceof EReference ? (!this.canLeadOutOfScope(reference = (EReference)feature) ? new EClassTransitiveInstancesKey((EClass)targetType) : (UnscopedTypeSupport.EMIT_NEVER != this.emitUnscopedEClassTypes ? new EClassUnscopedTransitiveInstancesKey((EClass)targetType) : null)) : new EDataTypeInSlotsKey((EDataType)targetType);
            result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedSource, Arrays.asList(0)));
            if (impliedTarget != null) {
                result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedTarget, Arrays.asList(1)));
            }
            if ((opposite = this.featureOpposite(feature)) != null && !this.canLeadOutOfScope((EReference)feature)) {
                EStructuralFeatureInstancesKey impliedOpposite = new EStructuralFeatureInstancesKey((EStructuralFeature)opposite);
                result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedOpposite, Arrays.asList(1, 0)));
            }
        } else if (implyingKey instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)implyingKey).getEmfKey();
            Class instanceClass = dataType.getInstanceClass();
            if (instanceClass != null) {
                JavaTransitiveInstancesKey implied = new JavaTransitiveInstancesKey(instanceClass);
                result.add(new InputKeyImplication(implyingKey, (IInputKey)implied, Arrays.asList(0)));
            }
        } else {
            this.illegalInputKey(implyingKey);
        }
        return result;
    }

    public Map<InputKeyImplication, Set<InputKeyImplication>> getConditionalImplications(IInputKey implyingKey) {
        this.ensureValidKey(implyingKey);
        if (implyingKey instanceof EClassUnscopedTransitiveInstancesKey) {
            EClass emfKey = (EClass)((EClassUnscopedTransitiveInstancesKey)implyingKey).getEmfKey();
            HashMap<InputKeyImplication, Set<InputKeyImplication>> result = new HashMap<InputKeyImplication, Set<InputKeyImplication>>();
            result.put(new InputKeyImplication(implyingKey, (IInputKey)EOBJECT_SCOPED_KEY, Arrays.asList(0)), new HashSet<InputKeyImplication>(Arrays.asList(new InputKeyImplication(implyingKey, (IInputKey)new EClassTransitiveInstancesKey(emfKey), Arrays.asList(0)))));
            return result;
        }
        return super.getConditionalImplications(implyingKey);
    }

    public Collection<InputKeyImplication> getWeakenedAlternatives(IInputKey implyingKey) {
        this.ensureValidKey(implyingKey);
        if (UnscopedTypeSupport.EMIT_ALWAYS == this.emitUnscopedEClassTypes && implyingKey instanceof EClassTransitiveInstancesKey) {
            EClass emfKey = (EClass)((EClassTransitiveInstancesKey)implyingKey).getEmfKey();
            HashSet<InputKeyImplication> result = new HashSet<InputKeyImplication>();
            result.add(new InputKeyImplication(implyingKey, (IInputKey)new EClassUnscopedTransitiveInstancesKey(emfKey), Arrays.asList(0)));
            return result;
        }
        return super.getWeakenedAlternatives(implyingKey);
    }

    public void ensureValidKey(IInputKey key) {
        if (!(key instanceof BaseEMFTypeKey) && !(key instanceof JavaTransitiveInstancesKey)) {
            this.illegalInputKey(key);
        }
    }

    public void illegalInputKey(IInputKey key) {
        throw new IllegalArgumentException("The input key " + key + " is not a valid EMF input key.");
    }

    public boolean isFeatureMultiplicityToOne(EStructuralFeature feature) {
        return !feature.isMany();
    }

    public boolean isFeatureMultiplicityOneTo(EStructuralFeature typeObject) {
        if (typeObject instanceof EReference) {
            EReference feature = (EReference)typeObject;
            EReference eOpposite = feature.getEOpposite();
            return feature.isContainment() || eOpposite != null && !eOpposite.isMany();
        }
        return false;
    }

    public EClass featureSourceType(EStructuralFeature feature) {
        return feature.getEContainingClass();
    }

    public EClassifier featureTargetType(EStructuralFeature typeObject) {
        if (typeObject instanceof EAttribute) {
            EAttribute attribute = (EAttribute)typeObject;
            return attribute.getEAttributeType();
        }
        if (typeObject instanceof EReference) {
            EReference reference = (EReference)typeObject;
            return reference.getEReferenceType();
        }
        throw new IllegalArgumentException("typeObject has invalid type " + typeObject.getClass().getName());
    }

    public EReference featureOpposite(EStructuralFeature typeObject) {
        if (typeObject instanceof EReference) {
            EReference reference = (EReference)typeObject;
            return reference.getEOpposite();
        }
        return null;
    }

    public Comparator<IInputKey> getSuggestedEliminationOrdering() {
        return SUGGESTED_ELIMINATION_ORDERING;
    }

    private static enum UnscopedTypeSupport {
        EMIT_ALWAYS,
        EMIT_EXCEPT_AS_WEAKENED_REPLACEMENT,
        EMIT_NEVER;

    }
}

