/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.initialselectors;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.IInitialPopulationSelector;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class RandomInitalSelector
implements IInitialPopulationSelector {
    private ThreadContext context;
    private DesignSpaceManager dsm;
    private Set<TrajectoryFitness> initialPopulation;
    private int populationSize;
    private int minDepth;
    private int maxDepth;
    private int lengthRemaining;
    private Random random = new Random();
    private boolean isInterrupted = false;

    public RandomInitalSelector(int minDepth, int maxDepth) {
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    @Override
    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.dsm = context.getDesignSpaceManager();
        this.lengthRemaining = this.newLength();
        this.initialPopulation = new HashSet<TrajectoryFitness>(this.populationSize);
    }

    private int newLength() {
        return this.random.nextInt(this.maxDepth - this.minDepth) + this.minDepth;
    }

    /*
     * Unable to fully structure code
     */
    public void explore() {
        ** GOTO lbl16
        {
            --this.lengthRemaining;
            this.context.executeRandomActivationId();
            gcSatisfied = this.context.checkGlobalConstraints();
            if (!gcSatisfied) {
                this.context.backtrack();
                ++this.lengthRemaining;
            }
            do {
                if (this.lengthRemaining > 0) continue block0;
                this.initialPopulation.add(new TrajectoryWithStateFitness(this.dsm.getTrajectoryInfo(), this.context.calculateFitness()));
                this.dsm.undoUntilRoot();
                this.lengthRemaining = this.newLength();
lbl16:
                // 2 sources

            } while (!this.isInterrupted && this.initialPopulation.size() < this.populationSize);
        }
    }

    public void interruptStrategy() {
        this.isInterrupted = true;
    }

    @Override
    public Set<TrajectoryFitness> getInitialPopulation() {
        return this.initialPopulation;
    }
}

