/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.modelmanipulation;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.AbstractEcoreManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelReadOperations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.ModelManipulationException;

public abstract class AbstractModelManipulations
extends AbstractEcoreManipulations<Resource, EObject>
implements IModelManipulations,
IModelReadOperations {
    private static final String INVALID_MULTIPLICITY_FOR_POSITIONING_MESSAGE = "Positioning only works on features with 'many' multiplicity.";
    private static final String NOT_IN_CONTAINMENT_HIERARCHY_MESSAGE = "Elements must be moved into the containment hierarchy.";
    private static final String UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE = "The container of EClass %s does neither define or inherit an EStructuralFeature %s.";
    private static final String FEATURE_TYPE_MISMATCH = "The type of EStructuralFeature %s is incompatible with %s.";
    protected final ViatraQueryEngine engine;
    private NavigationHelper baseEMFIndex;

    public AbstractModelManipulations(ViatraQueryEngine engine) {
        this.engine = engine;
    }

    protected NavigationHelper getBaseEMFIndex() {
        if (this.baseEMFIndex == null) {
            this.baseEMFIndex = EMFScope.extractUnderlyingEMFIndex((ViatraQueryEngine)this.engine);
        }
        return this.baseEMFIndex;
    }

    protected void doMoveTo(Collection<EObject> what, EObject newContainer, EReference reference) throws ModelManipulationException {
        for (EObject obj : what) {
            this.doMoveTo(obj, newContainer, reference);
        }
    }

    protected abstract void doMoveTo(EObject var1, Resource var2) throws ModelManipulationException;

    protected abstract void doMoveTo(EObject var1, Resource var2, int var3) throws ModelManipulationException;

    protected abstract void doMoveTo(EObject var1, EObject var2, EReference var3) throws ModelManipulationException;

    protected abstract void doMoveTo(EObject var1, EObject var2, EReference var3, int var4) throws ModelManipulationException;

    protected abstract void doRemove(EObject var1, EStructuralFeature var2, Object var3) throws ModelManipulationException;

    protected abstract void doRemove(EObject var1, EStructuralFeature var2, int var3) throws ModelManipulationException;

    protected abstract void doRemove(EObject var1) throws ModelManipulationException;

    protected abstract void doRemove(EObject var1, EStructuralFeature var2) throws ModelManipulationException;

    protected abstract void doAdd(EObject var1, EStructuralFeature var2, Collection<? extends Object> var3) throws ModelManipulationException;

    protected abstract void doAdd(EObject var1, EStructuralFeature var2, Object var3, int var4) throws ModelManipulationException;

    protected abstract void doSet(EObject var1, EStructuralFeature var2, Object var3) throws ModelManipulationException;

    protected abstract EObject doCreate(EObject var1, EReference var2, EClass var3) throws ModelManipulationException;

    protected abstract EObject doCreate(Resource var1, EClass var2) throws ModelManipulationException;

    protected abstract void doChangeIndex(EObject var1, EStructuralFeature var2, int var3, int var4) throws ModelManipulationException;

    protected abstract int doCount(EObject var1, EStructuralFeature var2) throws ModelManipulationException;

    protected abstract Stream<? extends Object> doStream(EObject var1, EStructuralFeature var2) throws ModelManipulationException;

    protected abstract boolean doIsSetTo(EObject var1, EStructuralFeature var2, Object var3) throws ModelManipulationException;

    @Override
    public EClass eClass(EObject element) throws ModelManipulationException {
        return element.eClass();
    }

    @Override
    public int count(EObject container, EStructuralFeature feature) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        return this.doCount(container, feature);
    }

    @Override
    public Stream<? extends Object> stream(EObject container, EStructuralFeature feature) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        return this.doStream(container, feature);
    }

    @Override
    public boolean isSetTo(EObject container, EStructuralFeature feature, Object value) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        Preconditions.checkArgument((boolean)feature.getEType().isInstance(value), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), value});
        return this.doIsSetTo(container, feature, value);
    }

    @Override
    public EObject create(Resource res, EClass clazz) throws ModelManipulationException {
        return this.doCreate(res, clazz);
    }

    @Override
    public EObject createChild(EObject container, EReference reference, EClass clazz) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)reference.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), reference.getName()});
        Preconditions.checkArgument((reference.getEReferenceType().isSuperTypeOf(clazz) || this.isEObjectClass(reference.getEReferenceType()) ? 1 : 0) != 0, (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{reference.getName(), clazz.getName()});
        Preconditions.checkArgument((boolean)reference.isContainment(), (String)"Created elements must be inserted directly into the containment hierarchy.");
        Preconditions.checkArgument((!clazz.isAbstract() ? 1 : 0) != 0, (String)"Cannot instantiate abstract EClass %s.", (Object[])new Object[]{clazz.getName()});
        return this.doCreate(container, reference, clazz);
    }

    @Override
    public void addTo(EObject container, EStructuralFeature feature, Object element) throws ModelManipulationException {
        this.addTo(container, feature, Collections.singleton(element));
    }

    @Override
    public void addTo(EObject container, EStructuralFeature feature, Object element, int index) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        Preconditions.checkArgument((boolean)feature.getEType().isInstance(element), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), element});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"The EStructuralFeature %s must have an upper bound larger than 1.", (Object[])new Object[]{feature.getName()});
        Preconditions.checkArgument((!(feature instanceof EReference) || !((EReference)feature).isContainment() ? 1 : 0) != 0, (String)"Adding existing elements into the containment reference %s is not supported.", (Object[])new Object[]{feature.getName()});
        this.doAdd(container, feature, element, index);
    }

    @Override
    public void addTo(EObject container, EStructuralFeature feature, Collection<? extends Object> elements) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        for (Object object : elements) {
            Preconditions.checkArgument((boolean)feature.getEType().isInstance(object), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), object});
        }
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"The EStructuralFeature %s must have an upper bound larger than 1.", (Object[])new Object[]{feature.getName()});
        Preconditions.checkArgument((!(feature instanceof EReference) || !((EReference)feature).isContainment() ? 1 : 0) != 0, (String)"Adding existing elements into the containment reference %s is not supported.", (Object[])new Object[]{feature.getName()});
        this.doAdd(container, feature, elements);
    }

    @Override
    public void set(EObject container, EStructuralFeature feature, Object value) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        Preconditions.checkArgument((value == null || feature.getEType().isInstance(value) ? 1 : 0) != 0, (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), value});
        Preconditions.checkArgument((!feature.isMany() ? 1 : 0) != 0, (String)"The EStructuralFeature %s must have an upper bound of 1.", (Object[])new Object[]{feature.getName()});
        this.doSet(container, feature, value);
    }

    @Override
    public void remove(EObject object) throws ModelManipulationException {
        this.doRemove(object);
    }

    @Override
    public void remove(EObject container, EStructuralFeature feature, Object element) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        Preconditions.checkArgument((boolean)feature.getEType().isInstance(element), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), element});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"Remove only works on EStructuralFeatures with 'many' multiplicity.");
        this.doRemove(container, feature, element);
    }

    @Override
    public void remove(EObject container, EStructuralFeature feature, int index) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"Remove only works on features with 'many' multiplicity.");
        this.doRemove(container, feature, index);
    }

    @Override
    public void remove(EObject container, EStructuralFeature feature) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass.getName(), feature.getName()});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"Remove only works on references with 'many' multiplicity.");
        this.doRemove(container, feature);
    }

    @Override
    public void moveTo(EObject what, Resource newContainer) throws ModelManipulationException {
        this.doMoveTo(what, newContainer);
    }

    @Override
    public void moveTo(EObject what, Resource newContainer, int index) throws ModelManipulationException {
        this.doMoveTo(what, newContainer, index);
    }

    @Override
    public void moveTo(EObject what, EObject newContainer, EReference reference) throws ModelManipulationException {
        EClass newContainerClass = newContainer.eClass();
        Preconditions.checkArgument((boolean)reference.getEContainingClass().isSuperTypeOf(newContainerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{newContainerClass, reference.getName()});
        Preconditions.checkArgument((boolean)reference.getEReferenceType().isInstance((Object)what), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{reference.getName(), what});
        Preconditions.checkArgument((boolean)reference.isContainment(), (String)NOT_IN_CONTAINMENT_HIERARCHY_MESSAGE);
        this.doMoveTo(what, newContainer, reference);
    }

    @Override
    public void moveTo(EObject what, EObject newContainer, EReference reference, int index) throws ModelManipulationException {
        EClass newContainerClass = newContainer.eClass();
        Preconditions.checkArgument((boolean)reference.getEContainingClass().isSuperTypeOf(newContainerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{newContainerClass, reference.getName()});
        Preconditions.checkArgument((boolean)reference.getEReferenceType().isInstance((Object)what), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{reference.getName(), what});
        Preconditions.checkArgument((boolean)reference.isMany(), (String)INVALID_MULTIPLICITY_FOR_POSITIONING_MESSAGE);
        Preconditions.checkArgument((boolean)reference.isContainment(), (String)NOT_IN_CONTAINMENT_HIERARCHY_MESSAGE);
        this.doMoveTo(what, newContainer, reference, index);
    }

    @Override
    public void moveTo(Collection<EObject> what, EObject newContainer, EReference reference) throws ModelManipulationException {
        EClass newContainerClass = newContainer.eClass();
        Preconditions.checkArgument((boolean)reference.getEContainingClass().isSuperTypeOf(newContainerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{newContainerClass, reference.getName()});
        for (EObject element : what) {
            Preconditions.checkArgument((boolean)reference.getEReferenceType().isInstance((Object)element), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{reference.getName(), element});
        }
        Preconditions.checkArgument((boolean)reference.isContainment(), (String)NOT_IN_CONTAINMENT_HIERARCHY_MESSAGE);
        this.doMoveTo(what, newContainer, reference);
    }

    @Override
    public void changeIndex(EObject container, EStructuralFeature feature, int oldIndex, int newIndex) throws ModelManipulationException {
        EClass containerClass = container.eClass();
        Preconditions.checkArgument((boolean)feature.getEContainingClass().isSuperTypeOf(containerClass), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{containerClass, feature.getName()});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)INVALID_MULTIPLICITY_FOR_POSITIONING_MESSAGE);
        this.doChangeIndex(container, feature, oldIndex, newIndex);
    }

    protected static Collection<Object> getSlotValuesInternal(EObject container, EStructuralFeature feature) {
        Object slot = container.eGet(feature);
        if (feature.isMany()) {
            return (Collection)slot;
        }
        return slot == null ? Collections.emptySet() : Collections.singleton(slot);
    }
}

