/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.tabular;

import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.IEngineContext;
import org.eclipse.viatra.query.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.scopes.IStorageBackend;
import org.eclipse.viatra.query.runtime.matchers.scopes.TabularRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.IIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterBinary;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterUnary;
import org.eclipse.viatra.query.runtime.tabular.TabularEngineContext;

public abstract class TabularIndexHost {
    private final IStorageBackend storage;
    protected final TabularRuntimeContext runtimeContext;
    protected final TabularIndexScope scope = new TabularIndexScope();

    public TabularIndexHost(IStorageBackend storage, TabularRuntimeContext runtimeContext) {
        this.storage = storage;
        this.runtimeContext = runtimeContext;
    }

    public TabularRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public TabularIndexScope getScope() {
        return this.scope;
    }

    protected abstract boolean isQueryScopeEmulated(Class<? extends QueryScope> var1);

    public void startUpdateTransaction() {
        this.storage.startTransaction();
    }

    public void finishUpdateTransaction() {
        this.storage.finishTransaction();
    }

    protected ITableWriterUnary.Table<Object> newUnaryInputTable(IInputKey key, boolean unique) {
        return this.registerNewTable(this.storage.createUnaryTable(key, (ITableContext)this.runtimeContext, unique));
    }

    protected ITableWriterBinary.Table<Object, Object> newBinaryInputTable(IInputKey key, boolean unique) {
        return this.registerNewTable(this.storage.createBinaryTable(key, (ITableContext)this.runtimeContext, unique));
    }

    protected <Table extends IIndexTable> Table registerNewTable(Table newTable) {
        this.runtimeContext.registerIndexTable(newTable);
        return newTable;
    }

    public class TabularIndexScope
    extends QueryScope {
        public TabularIndexHost getIndexHost() {
            return TabularIndexHost.this;
        }

        public int hashCode() {
            return this.getIndexHost().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TabularIndexScope) {
                return this.getIndexHost().equals(((TabularIndexScope)obj).getIndexHost());
            }
            return false;
        }

        @Override
        public boolean isCompatibleWithQueryScope(Class<? extends QueryScope> queryScopeClass) {
            return TabularIndexHost.this.isQueryScopeEmulated(queryScopeClass) || super.isCompatibleWithQueryScope(queryScopeClass);
        }

        @Override
        protected IEngineContext createEngineContext(ViatraQueryEngine engine, IIndexingErrorListener errorListener, Logger logger) {
            return new TabularEngineContext(this.getIndexHost(), engine, errorListener, logger);
        }
    }
}

