/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests;

import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlViewAllEventsTest
extends ControlViewTest {
    private static final String TEST_STREAM = "CreateSessionTestLTTng2_8.cfg";
    private static final String CREATE_SESSION_KERNEL_SCENARIO_NAME = "CreateSessionAllKernelEvents";
    private static final String SESSION_NAME = "mysession";

    @Override
    protected String getTestStream() {
        return TEST_STREAM;
    }

    @Override
    protected String getSessionName() {
        return SESSION_NAME;
    }

    @Override
    @Test
    public void testTraceSessionTree() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_SESSION_KERNEL_SCENARIO_NAME);
        this.testCreateSession();
        this.testEnableKernelEvent();
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testDestroySession();
        this.testDisconnectFromNode();
    }

    @Override
    protected void testEnableKernelEvent() {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup("Select", "All Tracepoint Events and Syscalls").click();
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Kernel", (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0"});
        Assert.assertEquals((Object)"channel0", (Object)channelItem.getText());
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0", "*"});
        Assert.assertEquals((Object)"*", (Object)eventItem.getText());
    }
}

