/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentoutline;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.texteditor.IUpdate;

public class PropertyChangeUpdateAction
extends Action
implements IUpdate {
    private String fPreferenceKey;
    private IPreferenceStore fStore;
    private boolean fUpdateFromPropertyChange = true;

    public PropertyChangeUpdateAction(String text, IPreferenceStore store, String preferenceKey, boolean defaultValue) {
        super(text, 2);
        this.fPreferenceKey = preferenceKey;
        this.fStore = store;
        this.fStore.setDefault(this.getPreferenceKey(), defaultValue);
        this.setId(this.getPreferenceKey());
        this.setChecked(this.getPreferenceStore().getBoolean(this.getPreferenceKey()));
    }

    public String getPreferenceKey() {
        return this.fPreferenceKey;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    public boolean isUpdateFromPropertyChange() {
        return this.fUpdateFromPropertyChange;
    }

    public final void run() {
        super.run();
        this.fStore.setValue(this.getPreferenceKey(), this.isChecked());
        if (!this.isUpdateFromPropertyChange()) {
            this.update();
        }
    }

    public void setUpdateFromPropertyChange(boolean updateFromPropertyChange) {
        this.fUpdateFromPropertyChange = updateFromPropertyChange;
    }

    public void update() {
        this.setChecked(this.fStore.getBoolean(this.getPreferenceKey()));
    }
}

