/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchObjectProvider;
import org.eclipse.launchbar.core.internal.Activator;

public class ProjectLaunchObjectProvider
implements ILaunchObjectProvider,
IResourceChangeListener {
    private ILaunchBarManager manager;

    @Override
    public void init(ILaunchBarManager manager) throws CoreException {
        this.manager = manager;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                manager.launchObjectAdded(project);
            }
            ++n2;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(delta -> {
                IResource res = delta.getResource();
                if (res instanceof IProject) {
                    int flags;
                    IProject project = (IProject)res;
                    int kind = delta.getKind();
                    if ((kind & 1) != 0) {
                        this.manager.launchObjectAdded(project);
                    } else if ((kind & 2) != 0) {
                        this.manager.launchObjectRemoved(project);
                    } else if ((kind & 4) != 0 && ((flags = delta.getFlags()) & 0x80000) != 0) {
                        this.manager.launchObjectChanged(project);
                    }
                    return false;
                }
                return !(res instanceof IFile) && !(res instanceof IFolder);
            });
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }
}

