/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.util.Base64;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.BlobDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;

public class BlobDefinition
extends SimpleDatatypeDefinition {
    private final byte[] fArray;
    private final String fType;

    public BlobDefinition(@NonNull IDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName, byte[] array, String mediaType) {
        super(declaration, definitionScope, fieldName);
        this.fArray = array;
        this.fType = mediaType;
    }

    @Override
    public String getStringValue() {
        return this.toString();
    }

    @Override
    public byte[] getBytes() {
        return this.fArray;
    }

    @Override
    public @NonNull BlobDeclaration getDeclaration() {
        return (BlobDeclaration)super.getDeclaration();
    }

    @Override
    public String toString() {
        if (this.fArray.length < this.getDeclaration().getMaximumSize()) {
            String encoded = Base64.getEncoder().encodeToString(this.fArray);
            return "[ " + this.fType + " ]" + encoded;
        }
        return "";
    }
}

